/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Layouts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class LayoutMgr
implements ILayoutMgr {
    private static ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");

    public Layout save(User user, Layout layout) throws WCMException {
        this.validate(layout);
        m_oLayoutGenerator.generateHtml(layout, false);
        layout.save(user);
        return layout;
    }

    public boolean delete(User user, Layout layout) throws WCMException {
        if (layout == null) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label1", "\u6b32\u5220\u9664\u7684\u5e03\u5c40\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        if (!layout.canEdit(user)) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label2", "ID\u4e3a[{0}]\u7684\u5e03\u5c40\u5df2\u7ecf\u88ab\u5176\u5b83\u7528\u6237\u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"), new String[]{String.valueOf(layout.getId())}));
        }
        layout.delete(user);
        m_oLayoutGenerator.deleteCss(layout);
        return true;
    }

    public boolean delete(User user, Layouts layouts) throws WCMException {
        if (layouts == null) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label1", "\u6b32\u5220\u9664\u7684\u5e03\u5c40\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        for (int i = 0; i < layouts.size(); ++i) {
            this.delete(user, (Layout)layouts.getAt(i));
        }
        return true;
    }

    public boolean validateRatio(Layout layout) throws WCMException {
        int n = layout.getRatioType();
        if (n != Layout.RATIO_TYPE_FIXED && n != Layout.RATIO_TYPE_PERCENTAGE) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label3", "\u5e03\u5c40\u6bd4\u4f8b\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
        }
        int n2 = layout.getColumns();
        if (n2 > Layout.MAX_COLUMNS) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label4", "\u5e03\u5c40\u7684\u5217\u6570\u8d85\u8fc7\u4e86\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5927\u5217\u6570[{0}]\uff01"), new String[]{String.valueOf(Layout.MAX_COLUMNS)}));
        }
        String string = layout.getRatio();
        if (String.valueOf(string.charAt(0)).equals(Layout.RATIO_SEPERATE) || string.endsWith(Layout.RATIO_SEPERATE)) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label10", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4ee5\u6570\u503c\u5206\u9694\u7b26 {0} \u5f00\u5934\u6216\u8005\u7ed3\u5c3e\uff01"), new String[]{Layout.RATIO_SEPERATE}));
        }
        String[] stringArray = string.split(Layout.RATIO_SEPERATE);
        if (stringArray.length != n2) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label5", "\u5e03\u5c40\u6bd4\u4f8b\u4e0d\u7b26\u5408\u89c4\u8303[\u4e0e\u5e03\u5c40\u7684\u5217\u6570\u4e0d\u76f8\u7b49]\uff01"));
        }
        int n3 = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].trim().equals(Layout.ADAPTIVE_CHAR)) {
                    if (Integer.parseInt(stringArray[i]) > 0) continue;
                    throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label6", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u548c\u96f6\uff01"));
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label7", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u7b26\u5408\u89c4\u8303[\u6bd4\u4f8b\u503c\u53ea\u80fd\u4e3a\u6b63\u6574\u6570\u6216\u8005\u5b57\u7b26*]\uff01"));
        }
        if (n3 > 1) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label8", "\u5e03\u5c40\u6bd4\u4f8b\u503c\u4e0d\u6b63\u786e[\u81f3\u591a\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3a*\u7684\u503c]\uff01"));
        }
        return true;
    }

    public boolean validate(Layout layout) throws WCMException {
        try {
            this.validateRatio(layout);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(LayoutMgr.class, "LayoutMgr.label11", "\u6821\u9a8c\u5e03\u5c40\u4fe1\u606f\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), exception);
        }
        return true;
    }

    public Layouts query(User user, WCMFilter wCMFilter) throws WCMException {
        return Layouts.openWCMObjs(user, wCMFilter);
    }

    public Layout findLayoutByName(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter(null, "LAYOUTNAME=?", "LAYOUTID desc");
        wCMFilter.addSearchValues(string);
        Layouts layouts = Layouts.openWCMObjs(user, wCMFilter);
        return layouts.size() > 0 ? (Layout)layouts.getAt(0) : null;
    }
}

