/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cluster.FileMsgProcessor;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.Layout;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayoutGenerator
implements ILayoutGenerator {
    private String sCssFileName = "app/special/layout/default.css";
    private String m_sFloatLeft = "float:left;";
    private String m_sFloatRight = "float:right;";
    private String m_sWidth = "width:";
    private int adaptiveColumn = 0;
    private int colNums = 0;
    private boolean formIe6Bug = false;

    public String generateHtml(Layout layout, boolean bl, boolean bl2) throws WCMException {
        if (layout.getId() <= 0) {
            if (!bl) {
                layout.setNextId();
            }
        } else {
            layout.refreshProperty(layout);
        }
        this.colNums = layout.getColumns();
        this.adaptiveColumn = this.getAdaptiveColumn(layout);
        String string = "r_c" + layout.getColumns() + "_" + layout.getId();
        String string2 = layout.getRatio();
        StringBuffer stringBuffer = new StringBuffer(500);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer.append("\n<!--layout ").append(string).append(" start-->\n");
        stringBuffer.append("<div class='").append("trs_layout").append(" ").append(string).append("' _ratio='").append(string2).append("' _ratiotype='").append(layout.getRatioType()).append("'>\n");
        if (!bl) {
            stringBuffer2.append("\n/* ").append(string).append(" _ratio='").append(string2).append("' _ratiotype='").append(layout.getRatioType()).append("'*/\n");
        }
        this.isFormIe6Bug(string2, layout.getRatioType());
        for (int i = 1; i <= this.colNums; ++i) {
            int n = this.getPageColumnOfLayout(i, this.colNums);
            String string3 = this.getCssOfColumn(i, layout);
            stringBuffer.append(this.getHtmlOfColumn(i, bl, string3, bl2 ? "{" + String.valueOf(n - 1) + "}" : "<div class='c-empty-column'>\u70b9\u51fb\u6dfb\u52a0\u8d44\u6e90</div>"));
            if (!bl) {
                stringBuffer2.append(".").append(string).append(" .c_" + i).append("{").append(string3).append("}\n");
            }
            if (i == this.colNums) continue;
            if (this.adaptiveColumn != 0 && i >= this.adaptiveColumn) {
                stringBuffer.append("<div class='c_sep c_right'></div>\n");
                continue;
            }
            stringBuffer.append("<div class='c_sep c_left'></div>\n");
        }
        stringBuffer.append("</div>\n");
        stringBuffer.append("<!--layout ").append(string).append(" end -->\n");
        layout.setHtmlContent(stringBuffer.toString());
        if (!bl) {
            stringBuffer2.append("/* ").append(string).append(" end */");
            this.saveCss(layout.getId(), stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    public String generateHtml(Layout layout, boolean bl) throws WCMException {
        return this.generateHtml(layout, bl, false);
    }

    private void isFormIe6Bug(String string, int n) {
        if (n != Layout.RATIO_TYPE_PERCENTAGE || this.adaptiveColumn != 0) {
            this.formIe6Bug = false;
            return;
        }
        String[] stringArray = string.split(Layout.RATIO_SEPERATE);
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = Integer.parseInt(stringArray[i]);
            if (n2 % 2 == 0) continue;
            this.formIe6Bug = true;
            return;
        }
        this.formIe6Bug = false;
    }

    private int getPageColumnOfLayout(int n, int n2) {
        if (this.adaptiveColumn == 0) {
            return n;
        }
        if (n < this.adaptiveColumn) {
            return n;
        }
        return n2 - n + this.adaptiveColumn;
    }

    private void saveCss(int n, String string) throws WCMException {
        String string2 = this.getCssFilePath();
        String string3 = this.getFileContent(string2);
        Pattern pattern = Pattern.compile("r_c\\d+_" + n);
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.find()) {
            string3 = string3 + string;
        } else if (string3.indexOf(string.trim()) < 0) {
            string3 = this.replaceLayoutCssWith(n, string3, string);
        }
        this.writeCssFile(string2, string3, "UTF-8");
    }

    public void deleteCss(Layout layout) throws WCMException {
        if (layout.getId() <= 0) {
            return;
        }
        int n = layout.getId();
        String string = this.getCssFilePath();
        String string2 = this.getFileContent(string);
        Pattern pattern = Pattern.compile("r_c\\d+_" + n);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            string2 = this.replaceLayoutCssWith(n, string2, "");
        }
        this.writeCssFile(string, string2, "UTF-8");
    }

    private String getCssOfColumn(int n, Layout layout) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = layout.getRatio().split(Layout.RATIO_SEPERATE);
        if (n <= 0 || n > stringArray.length) {
            return null;
        }
        if (this.adaptiveColumn == 0 || n < this.adaptiveColumn) {
            stringBuffer.append(this.m_sFloatLeft).append(this.m_sWidth).append(stringArray[n - 1]);
        } else if (n >= this.adaptiveColumn && n != stringArray.length) {
            stringBuffer.append(this.m_sFloatRight).append(this.m_sWidth).append(stringArray[stringArray.length - n + this.adaptiveColumn - 1]);
        } else {
            return stringBuffer.toString();
        }
        if (layout.getRatioType() == Layout.RATIO_TYPE_FIXED) {
            stringBuffer.append(Layout.RATIO_FIXED_WIDTH).append(";");
        } else {
            stringBuffer.append(Layout.RATIO_PERCENTAGE_WIDTH).append(";");
        }
        return stringBuffer.toString();
    }

    private int getAdaptiveColumn(Layout layout) {
        String[] stringArray = layout.getRatio().split(Layout.RATIO_SEPERATE);
        for (int i = 1; i <= stringArray.length; ++i) {
            if (!stringArray[i - 1].equals(Layout.ADAPTIVE_CHAR)) continue;
            return i;
        }
        return 0;
    }

    private String getHtmlOfColumn(int n, boolean bl, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        String string3 = "";
        if (n + 1 == this.adaptiveColumn) {
            string3 = "margin_right";
        }
        if (this.adaptiveColumn > 0 && n + 1 == this.colNums && this.adaptiveColumn != this.colNums) {
            string3 = "margin_left";
        }
        if (this.formIe6Bug && n == 1) {
            string3 = string3 + " margin_left_IE6BUG_DIVFLOAT100";
        }
        if (this.formIe6Bug && n == this.colNums) {
            string3 = string3 + " margin_right_IE6BUG_DIVFLOAT100";
        }
        String string4 = "";
        if (bl) {
            string4 = string4 + "style='" + string + "'";
        }
        stringBuffer.append("<div class='").append("trs_column").append(" c_").append(n).append(" ").append(string3).append("' ");
        stringBuffer.append(string4).append(">\n");
        stringBuffer.append("<div class='c-box'>");
        stringBuffer.append(string2);
        stringBuffer.append("</div>\n");
        stringBuffer.append("</div>\n");
        return stringBuffer.toString();
    }

    private String getCssFilePath() throws WCMException {
        String string = ConfigServer.getServer().getInitProperty("WCM_PATH");
        string = CMyString.setStrEndWith(string, File.separatorChar);
        return string + this.sCssFileName;
    }

    private String getFileContent(String string) throws WCMException {
        String string2 = "";
        try {
            string2 = CMyFile.readFile(string, "UTF-8");
            return string2;
        }
        catch (Exception exception) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutGenerator.class, "LayoutGenerator.label1", "\u6ca1\u6709\u627e\u5230\u5e03\u5c40\u7684\u603b\u6837\u5f0f\u6587\u4ef6\uff01[filepath={0}]"), new String[]{string}));
        }
    }

    private void writeCssFile(String string, String string2, String string3) throws WCMException {
        try {
            CMyFile.writeFile(string, string2, string3);
            FileMsgProcessor.send(new File(string).getAbsolutePath());
        }
        catch (Exception exception) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutGenerator.class, "LayoutGenerator.label2", "\u5199\u6587\u4ef6\u5931\u8d25\uff01[filepath={0}]"), new String[]{string}));
        }
    }

    private String replaceLayoutCssWith(int n, String string, String string2) {
        Pattern pattern = Pattern.compile("(?s)(\\n|\\r|\\r\\n)/\\* r_c\\d+_" + n + " .*?r_c\\d+_" + n + " end \\*/");
        String string3 = null;
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(0);
            return CMyString.replaceStr(string, string3, string2);
        }
        return string;
    }

    public boolean validateHtml(Layout layout) throws WCMException {
        return true;
    }
}

