/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.persistent.template.TagBean;
import com.trs.components.common.publish.persistent.template.TagBeans;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class TagParserFactory
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)TagParserFactory.class.getName());
    private HashMap m_beansMap = new HashMap();
    private boolean m_bLoaded = false;
    private static TagParserFactory s_instance = new TagParserFactory();

    private TagParserFactory() {
    }

    public synchronized void clear() {
        logger.debug((Object)"to clear tag parser factory ...");
        this.m_beansMap.clear();
        this.m_bLoaded = false;
    }

    public synchronized void refresh() throws WCMException {
        if (this.m_bLoaded) {
            this.clear();
        }
        logger.debug((Object)"to refresh tag parser factory ...");
        TagBeans tagBeans = null;
        try {
            tagBeans = new TagBeans(User.getSystem());
            tagBeans.open(new WCMFilter("", "ENABLED=1", ""));
            for (int i = 0; i < tagBeans.size(); ++i) {
                TagBean tagBean = (TagBean)tagBeans.getAt(i);
                if (tagBean == null) continue;
                this.pushTagBeanIntoCache(tagBean.getTagName(), tagBean.getTagBean());
            }
            this.m_bLoaded = true;
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to refresh the tag parser factory!", (Throwable)exception);
            throw new WCMException(1100, "Failed to refresh the tag parser factory!", exception);
        }
        finally {
            if (tagBeans != null) {
                tagBeans.clear();
            }
        }
    }

    private void pushTagBeanIntoCache(String string, String string2) throws Exception {
        try {
            this.m_beansMap.put(string.toUpperCase(), Class.forName(string2));
            logger.debug((Object)("TagBean <" + string + "> is pushed into cache."));
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to push tag bean <" + string + "> into cache!"), (Throwable)exception);
        }
    }

    private void removeTagBeanFromCache(TagBean tagBean) {
        String string = tagBean.getTagName();
        this.m_beansMap.remove(string);
        logger.debug((Object)("TagBean <" + string + "> is removed from cache."));
    }

    public Class getTagParserClass(String string) {
        return (Class)this.m_beansMap.get(string.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TagParserFactory getInstance() throws WCMException {
        if (!TagParserFactory.s_instance.m_bLoaded) {
            TagParserFactory tagParserFactory = s_instance;
            synchronized (tagParserFactory) {
                if (!TagParserFactory.s_instance.m_bLoaded) {
                    s_instance.refresh();
                }
            }
        }
        return s_instance;
    }

    public static boolean isNestedTemplateTag(String string) {
        return "TRS_TEMPLATE".equalsIgnoreCase(string);
    }

    public static ITagParser createParserByName(String string) throws WCMException {
        TagParserFactory tagParserFactory = TagParserFactory.getInstance();
        Class clazz = tagParserFactory.getTagParserClass(string);
        if (clazz == null) {
            throw new WCMException(11, "Parser not found for tag <" + string + ">");
        }
        try {
            return (ITagParser)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WCMException(11, "Failed to create new instance for parser class " + clazz.getName(), exception);
        }
    }

    public static void notifyOnTagBeanAdded(TagBean tagBean) throws WCMException {
        try {
            TagParserFactory.getInstance().pushTagBeanIntoCache(tagBean.getTagName(), tagBean.getTagBean());
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed push new tag bean into cache!", exception);
        }
    }

    public static void notifyOnTagBeanDeleted(TagBean tagBean) throws WCMException {
        TagParserFactory.getInstance().removeTagBeanFromCache(tagBean);
    }

    public static void notifyOnTagBeanModified(TagBean tagBean) throws WCMException {
        try {
            TagParserFactory tagParserFactory = TagParserFactory.getInstance();
            if (tagBean.isChangeProperty("TAGNAME")) {
                tagParserFactory.removeTagBeanFromCache(tagBean);
                if (tagBean.isChangeProperty("TAGBEAN")) {
                    tagParserFactory.pushTagBeanIntoCache((String)tagBean.getNewProperty("TAGNAME"), (String)tagBean.getNewProperty("TAGBEAN"));
                } else {
                    tagParserFactory.pushTagBeanIntoCache((String)tagBean.getNewProperty("TAGNAME"), tagBean.getTagBean());
                }
                return;
            }
            if (tagBean.isChangeProperty("TAGBEAN")) {
                tagParserFactory.pushTagBeanIntoCache(tagBean.getTagName(), (String)tagBean.getNewProperty("TAGBEAN"));
                return;
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to update the cache when tag bean is modified!", exception);
        }
    }
}

