/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.auth;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ICMSObjSubstanceContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;

public class TemplateRightObjImpl
implements IRightObj {
    private Template m_oCurrTemplate = null;

    public TemplateRightObjImpl() {
    }

    public TemplateRightObjImpl(int n) throws WCMException {
        this.loadById(n);
    }

    public TemplateRightObjImpl(CMSObj cMSObj) {
        this.makeFrom(cMSObj);
    }

    public boolean hasRight(User user, int n) throws WCMException {
        if (AuthServer.hasSuperRight(user, this.getSubstance())) {
            return true;
        }
        int n2 = n;
        if (n2 == 68) {
            n2 = this.getSubstance().isAddMode() ? 21 : 23;
        }
        boolean bl = false;
        try {
            IPublishFolder iPublishFolder = this.m_oCurrTemplate.getFolder();
            if (iPublishFolder == null) {
                bl = true;
                throw new WCMException(200006, "The located folder [Type=" + this.m_oCurrTemplate.getFolderType() + ",Id=" + this.m_oCurrTemplate.getFolderId() + "] of this template[" + this.getSubstance() + "] is not found!");
            }
            CMSObj cMSObj = iPublishFolder.getSubstance();
            return AuthServer.hasRight(user, cMSObj, n2);
        }
        catch (Exception exception) {
            if (bl) {
                throw (WCMException)exception;
            }
            throw new WCMException(1100, "Failed to check the user right!", exception);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ICMSObjSubstanceContent)) {
            return false;
        }
        ICMSObjSubstanceContent iCMSObjSubstanceContent = (ICMSObjSubstanceContent)object;
        return this.getType() == iCMSObjSubstanceContent.getType() && this.getId() == iCMSObjSubstanceContent.getId();
    }

    public int getType() {
        return 102;
    }

    public int getId() {
        if (this.m_oCurrTemplate == null) {
            return 0;
        }
        return this.m_oCurrTemplate.getId();
    }

    public CMSObj getSubstance() {
        return this.m_oCurrTemplate;
    }

    public void setSubstance(CMSObj cMSObj) {
        this.m_oCurrTemplate = (Template)cMSObj;
    }

    public String getInfo() {
        if (this.m_oCurrTemplate == null) {
            return null;
        }
        return this.m_oCurrTemplate.toString();
    }

    public boolean loadById(int n) throws WCMException {
        this.m_oCurrTemplate = Template.findById(n);
        return this.m_oCurrTemplate != null;
    }

    public void makeFrom(CMSObj cMSObj) {
        this.m_oCurrTemplate = (Template)cMSObj;
    }
}

