/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.config;

import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishElementType;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.config.persistent.PublishDistributionConfig;
import com.trs.components.common.publish.config.persistent.PublishElementConfig;
import com.trs.components.common.publish.config.persistent.PublishServerConfig;
import com.trs.components.common.publish.config.persistent.TargetTypeConfig;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PublishServerConfigMapper
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)PublishServerConfigMapper.class.getName());
    private int m_nLoadBatchContentsModal = 1;
    private int m_nLoadBatchContentsPageSize = 30;
    private boolean m_bDirDividedByDate = false;
    private boolean m_bPublishInRootPath = false;
    private boolean m_bDetailPageSeperateTo51Style = false;
    private String m_sDirDividedByDateFormat = null;
    private String m_sDirDividedByDateFormatLocal = null;
    private boolean m_bSendWarningIfFileNotFound = true;
    private boolean m_bIgnoreIfHostNotFound = true;
    private boolean m_bAutoPublishDocInHomeWhenNeeded = false;
    private String m_sDefaultEncoding = null;
    private HashMap m_hElementTypes = new HashMap(3);
    private LaborResourceConfig m_oLaborResourceConfig = null;
    private TemplateParseConfig m_oTemplateParseConfig = null;
    private String[] m_arrTemplateTagsHavingSrc = null;
    private String[] m_arrTemplateTagSrcAttributeNames = null;
    private String[] m_arrTemplateSupportedExts = null;
    private String[] m_arrTemplateSupportedApdExts = null;
    private List m_listTagFormattersConfigs = null;
    private PublishDistributionConfig m_oDistributionConfig = null;
    private Map m_hDistributionTargetTypes = new HashMap(2);
    private boolean m_bLoaded = false;
    private static PublishServerConfigMapper s_instance = new PublishServerConfigMapper();
    private static String m_sPublishSrvId;

    private PublishServerConfigMapper() {
        this.m_listTagFormattersConfigs = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublishServerConfigMapper getInstance() throws WCMException {
        if (!s_instance.isLoaded()) {
            PublishServerConfigMapper publishServerConfigMapper = s_instance;
            synchronized (publishServerConfigMapper) {
                if (!s_instance.isLoaded()) {
                    s_instance.refresh();
                }
            }
        }
        return s_instance;
    }

    public boolean isLoaded() {
        return this.m_bLoaded;
    }

    public synchronized void clear() {
        logger.debug((Object)"to clear configuration...");
        this.m_hElementTypes.clear();
        if (this.m_hDistributionTargetTypes != null) {
            this.m_hDistributionTargetTypes.clear();
        }
    }

    public synchronized void refresh() throws WCMException {
        try {
            this.clear();
            if (this.m_bLoaded) {
                this.m_bLoaded = false;
            }
            this.loadCommonPublishConfiguration();
            this.loadDefinedPublishConfiguration();
            this.m_bLoaded = true;
            logger.debug((Object)"publish server config has been loaded successfully!");
        }
        catch (Exception exception) {
            throw new WCMException(12, "Failed to load from the config", exception);
        }
    }

    private void loadDefinedPublishConfiguration() throws WCMException {
        PublishServerConfig[] publishServerConfigArray = this.getPublishServerConfig();
        for (int i = 0; i < publishServerConfigArray.length; ++i) {
            PublishServerConfig publishServerConfig = publishServerConfigArray[i];
            this.loadOneKindOfElementTypes(publishServerConfig.getFolderTypes(), "FolderTypes", true);
            this.loadOneKindOfElementTypes(publishServerConfig.getContentTypes(), "ContentTypes", false);
            this.loadTagFormatters(publishServerConfig.getTagFormatters());
        }
    }

    private void loadTagFormatters(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this.m_listTagFormattersConfigs.addAll(arrayList);
    }

    private void loadCommonPublishConfiguration() throws WCMException {
        PublishServerConfig publishServerConfig = this.getPublishServerConfig("CommonPublishServer");
        this.m_nLoadBatchContentsModal = publishServerConfig.getLoadBatchContentsModal();
        this.m_nLoadBatchContentsPageSize = publishServerConfig.getLoadBatchContentsPageSize();
        this.m_bPublishInRootPath = publishServerConfig.isPublishInRootPath();
        this.m_bDetailPageSeperateTo51Style = publishServerConfig.isDetailPageSeperateTo51Style();
        this.m_bDirDividedByDate = publishServerConfig.isDirDividedByDate();
        if (this.m_bDirDividedByDate) {
            this.m_sDirDividedByDateFormat = publishServerConfig.getDirDividedByDateFormat();
            char c = File.separatorChar;
            this.m_sDirDividedByDateFormatLocal = c == '/' ? this.m_sDirDividedByDateFormat.replace('\\', c) : this.m_sDirDividedByDateFormat.replace('/', c);
        } else {
            this.m_sDirDividedByDateFormat = null;
            this.m_sDirDividedByDateFormatLocal = null;
        }
        this.m_bSendWarningIfFileNotFound = publishServerConfig.isSendWarningIfFileNotFound();
        this.m_bIgnoreIfHostNotFound = publishServerConfig.isIgnoreIfHostNotFound();
        this.m_bAutoPublishDocInHomeWhenNeeded = publishServerConfig.isAutoPublishDocInHomeWhenNeeded();
        this.m_sDefaultEncoding = publishServerConfig.getDefaultEncoding();
        this.m_oLaborResourceConfig = publishServerConfig.getLaborResource();
        this.m_oTemplateParseConfig = publishServerConfig.getTemplateParse();
        this.loadTemplateParseConfig(publishServerConfig.getTemplateParse());
        this.m_oDistributionConfig = publishServerConfig.getPublishDistribution();
        this.loadDistributionConfig(publishServerConfig.getPublishDistribution());
    }

    private PublishServerConfig getPublishServerConfig(String string) {
        logger.debug((Object)"to load publish server config...");
        List list = XMLConfigServer.getInstance().getConfigObjects(string);
        if (list == null || list.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label1", "\u6ca1\u6709\u914d\u7f6e!"));
        }
        return (PublishServerConfig)list.get(0);
    }

    private PublishServerConfig[] getPublishServerConfig() {
        logger.debug((Object)"to load publish server config...");
        List list = XMLConfigServer.getInstance().getConfigObjects(PublishServerConfig.class);
        if (list == null || list.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label2", "\u6ca1\u6709\u5173\u4e8e\u53d1\u5e03\u5c5e\u6027\u7684\u914d\u7f6e!"));
        }
        PublishServerConfig[] publishServerConfigArray = new PublishServerConfig[list.size()];
        for (int i = 0; i < publishServerConfigArray.length; ++i) {
            publishServerConfigArray[i] = (PublishServerConfig)list.get(i);
        }
        return publishServerConfigArray;
    }

    private void loadOneKindOfElementTypes(List list, String string, boolean bl) throws WCMException {
        if (list == null) {
            String string2 = bl ? "FolderTypeConfig" : "ContentTypeConfig";
            throw new WCMException(152, "config element of " + string2 + " is not found!");
        }
        if (list.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                PublishElementType publishElementType = new PublishElementType();
                publishElementType.fromConfigElement((PublishElementConfig)list.get(i));
                publishElementType.setIsFolder(bl);
                this.m_hElementTypes.put(new Integer(publishElementType.getType()), publishElementType);
            }
        }
        catch (Exception exception) {
            throw new WCMException(150, "Failed to load the element types from XML element " + string, exception);
        }
    }

    private void loadTemplateParseConfig(TemplateParseConfig templateParseConfig) {
        logger.debug((Object)"to load template parse config ...");
        if (this.m_oTemplateParseConfig != null) {
            String string = templateParseConfig.getTagsHavingSrc();
            if (string != null) {
                this.m_arrTemplateTagsHavingSrc = CMyString.split(string, ",");
            }
            if ((string = templateParseConfig.getTagSrcAttributeNames()) != null) {
                this.m_arrTemplateTagSrcAttributeNames = CMyString.split(string, ",");
            }
            if ((string = templateParseConfig.getSupportedExts()) != null) {
                this.m_arrTemplateSupportedExts = CMyString.split(string, ",");
            }
            if ((string = templateParseConfig.getSupportedApdExts()) != null) {
                this.m_arrTemplateSupportedApdExts = CMyString.split(string, ",");
            }
        }
    }

    private void loadDistributionConfig(PublishDistributionConfig publishDistributionConfig) throws WCMException {
        logger.debug((Object)"to load distribution config ...");
        ArrayList arrayList = publishDistributionConfig.getTargetTypes();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                PublishDistributionTargetType publishDistributionTargetType = new PublishDistributionTargetType();
                publishDistributionTargetType.fromConfigElement((TargetTypeConfig)arrayList.get(i));
                this.m_hDistributionTargetTypes.put(publishDistributionTargetType.getName().toUpperCase(), publishDistributionTargetType);
            }
        }
    }

    public static boolean isDirDividedByDate() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bDirDividedByDate;
    }

    public static boolean isPublishInRootPath() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bPublishInRootPath;
    }

    public static boolean isDetailPageSeperateTo51Style() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bDetailPageSeperateTo51Style;
    }

    public static int getLoadBatchContentsModal() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_nLoadBatchContentsModal;
    }

    public static int getLoadBatchContentsPageSize() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_nLoadBatchContentsPageSize;
    }

    public static String getDirDividedByDateFormat(boolean bl) throws WCMException {
        if (bl) {
            return PublishServerConfigMapper.getInstance().m_sDirDividedByDateFormatLocal;
        }
        return PublishServerConfigMapper.getInstance().m_sDirDividedByDateFormat;
    }

    public static boolean isSendWarningIfFileNotFound() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bSendWarningIfFileNotFound;
    }

    public static boolean isIgnoreIfHostNotFound() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bIgnoreIfHostNotFound;
    }

    public static boolean isAutoPublishDocInHomeWhenNeeded() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_bAutoPublishDocInHomeWhenNeeded;
    }

    public static String getDefaultEncoding() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_sDefaultEncoding;
    }

    public static PublishElementType getElementType(int n) throws WCMException {
        return (PublishElementType)PublishServerConfigMapper.getInstance().m_hElementTypes.get(new Integer(n));
    }

    public static LaborResourceConfig getLaborResourceConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oLaborResourceConfig;
    }

    public static TemplateParseConfig getTemplateParseConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oTemplateParseConfig;
    }

    public static String[] getTemplateTagsHavingSrc() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateTagsHavingSrc;
    }

    public static String[] getTemplateTagSrcAttributeNames() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateTagSrcAttributeNames;
    }

    public static String[] getTemplateSupportedExts() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateSupportedExts;
    }

    public static String[] getTemplateSupportedApdExts() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_arrTemplateSupportedApdExts;
    }

    public static List getTagFormattersConfigs() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_listTagFormattersConfigs;
    }

    public static PublishDistributionConfig getDistributionConfig() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_oDistributionConfig;
    }

    public static Map getDistributionTargetTypes() throws WCMException {
        return PublishServerConfigMapper.getInstance().m_hDistributionTargetTypes;
    }

    public static PublishDistributionTargetType lookupDistributionTargetTypeByName(String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            return null;
        }
        return (PublishDistributionTargetType)PublishServerConfigMapper.getInstance().m_hDistributionTargetTypes.get(string.toUpperCase());
    }

    public static String getPublishSrvId() {
        return m_sPublishSrvId;
    }

    public static void setPublishSrvId(String string) {
        m_sPublishSrvId = string;
        try {
            PublishServerConfigMapper.getInstance().refresh();
        }
        catch (WCMException wCMException) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label3", "\u8bd5\u56fe\u8bfb\u53d6[") + string + I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label4", "]\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u9519") + wCMException.getMessage(), wCMException);
        }
    }

    public static FileNamedStyle getDetailFileNamedStyle(String string) {
        List list = XMLConfigServer.getInstance().getConfigObjects(string);
        if (list == null || list.size() == 0) {
            throw new RuntimeException(I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label5", "\u5728\u6ca1\u6709\u627e\u5230\u5173\u8054\u5230[") + string + I18NMessage.get(PublishServerConfigMapper.class, "PublishServerConfigMapper.label6", "]\u5173\u4e8e\u53d1\u5e03\u6587\u4ef6\u547d\u540d\u7684\u914d\u7f6e\u8bbe\u7f6e!"));
        }
        FileNamedStyle fileNamedStyle = (FileNamedStyle)list.get(0);
        return fileNamedStyle;
    }

    public static FileNamedStyle getDetailFileNamedStyle() {
        return PublishServerConfigMapper.getDetailFileNamedStyle("CommonFileNamedStyle");
    }
}

