/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.Hashtable;

public final class MsgReceiver
extends BaseObj {
    public static final int OBJ_TYPE = 10003;
    public static final String DB_TABLE_NAME = "WCMMSGRECEIVER";
    public static final String DB_ID_NAME = "MSGRECEIVERID";
    private static final String FIELD_RECEIVERID = "RECEIVERID";
    private static final String FIELD_MSGID = "MSGID";
    private static final String FIELD_RECEIVERTYPE = "RECEIVERTYPE";
    private static final String FIELD_RECEIVERNAME = "RECEIVERNAME";

    public int getWCMType() {
        return 10003;
    }

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            Hashtable hashtable = this.getAllProperty();
            if (hashtable.get(FIELD_MSGID) == null) {
                throw new WCMException(1106, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label1", "\u5c5e\u6027MsgId\u6ca1\u6709\u8bbe\u7f6e(MsgReceiver.isValid)"));
            }
            if (hashtable.get(FIELD_RECEIVERID) == null) {
                throw new WCMException(1106, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label2", "\u5c5e\u6027ReceiverId\u6ca1\u6709\u8bbe\u7f6e(MsgReceiver.isValid)"));
            }
            if (hashtable.get(FIELD_RECEIVERTYPE) == null) {
                throw new WCMException(1106, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label3", "\u5c5e\u6027ReceiverType\u6ca1\u6709\u8bbe\u7f6e(MsgReceiver.isValid)"));
            }
            if (hashtable.get(FIELD_RECEIVERNAME) == null) {
                throw new WCMException(1106, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label4", "\u5c5e\u6027ReceiverName\u6ca1\u6709\u8bbe\u7f6e(MsgReceiver.isValid)"));
            }
        } else if (this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MsgReceiver.isValid)"));
        }
        return true;
    }

    public int getMsgId() {
        return this.getPropertyAsInt(FIELD_MSGID, 0);
    }

    public boolean setMsgId(int n) throws WCMException {
        return this.setProperty(FIELD_MSGID, n);
    }

    public int getReceiverId() {
        return this.getPropertyAsInt(FIELD_RECEIVERID, 0);
    }

    public boolean setReceiverId(int n) throws WCMException {
        return this.setProperty(FIELD_RECEIVERID, n);
    }

    public int getReceiverType() {
        return this.getPropertyAsInt(FIELD_RECEIVERTYPE, 0);
    }

    public boolean setReceiverType(int n) throws WCMException {
        if (this.isValidReceiverType(n)) {
            return this.setProperty(FIELD_RECEIVERTYPE, n);
        }
        throw new WCMException(10, I18NMessage.get(MsgReceiver.class, "MsgReceiver.label6", "\u65e0\u6548\u7684\u63a5\u6536\u8005\u7c7b\u578b[") + n + "]!");
    }

    public String getReceiverName() {
        return this.getPropertyAsString(FIELD_RECEIVERNAME);
    }

    public boolean setReceiverName(String string) throws WCMException {
        return this.setProperty(FIELD_RECEIVERNAME, string);
    }

    private boolean isValidReceiverType(int n) {
        return 204 == n || 201 == n || 203 == n;
    }

    public static final MsgReceiver findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MsgReceiver)BaseObj.findById(MsgReceiver.class, n);
    }

    public static final MsgReceiver createNewInstance() throws WCMException {
        return (MsgReceiver)BaseObj.createNewInstance(MsgReceiver.class);
    }

    public static final MsgReceiver findByKey(Object object) throws WCMException {
        return (MsgReceiver)BaseObj.findByKey(MsgReceiver.class, object);
    }
}

