/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.components.common.job.Schedule;
import com.trs.infra.util.job.BaseJob;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;

public abstract class BaseScheduleWorker
extends BaseJob {
    private static Logger logger = Logger.getLogger(BaseScheduleWorker.class);

    public void execute(JobExecutionContext jobExecutionContext) {
        super.execute(jobExecutionContext);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Job:" + jobExecutionContext.getJobDetail() + " next fire at:" + jobExecutionContext.getTrigger().getNextFireTime()));
        }
        this.clearScheduleIfNecessary(jobExecutionContext);
    }

    private void clearScheduleIfNecessary(JobExecutionContext jobExecutionContext) {
        String string = "";
        if (jobExecutionContext.getTrigger().getNextFireTime() == null) {
            try {
                string = jobExecutionContext.getJobDetail().getName();
                String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
                Schedule schedule = Schedule.findById(Integer.parseInt(string2));
                if (schedule != null) {
                    if (schedule.getParam() > 0) {
                        // empty if block
                    }
                    schedule.delete();
                }
            }
            catch (Exception exception) {
                logger.error((Object)("failed to delete the one time schedule[" + string + " after it had excuted!"), (Throwable)exception);
            }
        }
    }
}

