/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.components.common.bookmark.MarkShare;
import com.trs.components.common.bookmark.MarkShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BookMarkMgr {
    private static final int ALL_BOOKMARKS = -1;
    private static Logger m_oLogger = Logger.getLogger((String)BookMarkMgr.class.getName());

    public void moveBookMark(BookMark bookMark, MarkKind markKind) throws WCMException {
        this.assertNotNull(bookMark);
        this.assertNotNull(markKind);
        bookMark.canEdit(this.getLoginUser());
        bookMark.setKind(markKind);
        bookMark.update(this.getLoginUser());
    }

    public void moveMarkKind(MarkKind markKind, MarkKind markKind2) throws WCMException {
        this.assertNotNull(markKind);
        this.assertNotNull(markKind2);
        markKind.canEdit(this.getLoginUser());
        markKind.setParent(markKind2.getId());
        markKind.update(this.getLoginUser());
    }

    public MarkShares getShareMarks(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("", "ViewerId=" + user.getId(), "", "ShareId");
        wCMFilter2.mergeWith(wCMFilter);
        return MarkShares.openWCMObjs(user, wCMFilter2);
    }

    public BookMarks getSharedBookMarks(User user, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(user);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS(");
        stringBuffer.append(" SELECT OBJID FROM ");
        stringBuffer.append("WCMMARKSHARE");
        stringBuffer.append(" MarkShare ");
        stringBuffer.append(" WHERE(");
        stringBuffer.append(" (VIEWERID=");
        stringBuffer.append(user.getId());
        stringBuffer.append(" AND VIEWERTYPE=");
        stringBuffer.append(204);
        stringBuffer.append(" AND OBJTYPE=");
        stringBuffer.append(303);
        stringBuffer.append(" )");
        stringBuffer.append(" OR ");
        stringBuffer.append(" (VIEWERTYPE=");
        stringBuffer.append(201);
        stringBuffer.append(" AND OBJTYPE=");
        stringBuffer.append(303);
        stringBuffer.append(" AND EXISTS(");
        stringBuffer.append(" SELECT ");
        stringBuffer.append("GROUPID");
        stringBuffer.append(" FROM ");
        stringBuffer.append("WCMGRPUSER");
        stringBuffer.append(" GrpUser ");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("USERID");
        stringBuffer.append("=");
        stringBuffer.append(user.getId());
        stringBuffer.append(" AND MarkShare.VIEWERID=GrpUser.");
        stringBuffer.append("GROUPID");
        stringBuffer.append(" )");
        stringBuffer.append(" )");
        stringBuffer.append(" )");
        stringBuffer.append(" AND MarkShare.ObjId=");
        stringBuffer.append("WCMBOOKMARK");
        stringBuffer.append('.');
        stringBuffer.append("MARKID");
        stringBuffer.append(" )");
        WCMFilter wCMFilter2 = new WCMFilter("", stringBuffer.toString(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return BookMarks.openWCMObjs(user, wCMFilter2);
    }

    public MarkKinds getSharedMarkKinds(User user, WCMFilter wCMFilter) throws WCMException {
        this.assertNotNull(user);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS(");
        stringBuffer.append(" SELECT OBJID FROM ");
        stringBuffer.append("WCMMARKSHARE");
        stringBuffer.append(" MarkShare ");
        stringBuffer.append(" WHERE(");
        stringBuffer.append(" (VIEWERID=");
        stringBuffer.append(user.getId());
        stringBuffer.append(" AND VIEWERTYPE=");
        stringBuffer.append(204);
        stringBuffer.append(" AND OBJTYPE=");
        stringBuffer.append(307);
        stringBuffer.append(" )");
        stringBuffer.append(" OR ");
        stringBuffer.append(" (VIEWERTYPE=");
        stringBuffer.append(201);
        stringBuffer.append(" AND OBJTYPE=");
        stringBuffer.append(307);
        stringBuffer.append(" AND EXISTS(");
        stringBuffer.append(" SELECT ");
        stringBuffer.append("GROUPID");
        stringBuffer.append(" FROM ");
        stringBuffer.append("WCMGRPUSER");
        stringBuffer.append(" GrpUser ");
        stringBuffer.append(" WHERE ");
        stringBuffer.append("USERID");
        stringBuffer.append("=");
        stringBuffer.append(user.getId());
        stringBuffer.append(" AND MarkShare.VIEWERID=GrpUser.");
        stringBuffer.append("GROUPID");
        stringBuffer.append(" )");
        stringBuffer.append(" )");
        stringBuffer.append(" )");
        stringBuffer.append(" AND MarkShare.ObjId=");
        stringBuffer.append("KINDID");
        stringBuffer.append(" )");
        WCMFilter wCMFilter2 = new WCMFilter("", stringBuffer.toString(), "");
        wCMFilter2.mergeWith(wCMFilter);
        return MarkKinds.openWCMObjs(user, wCMFilter2);
    }

    public BookMarks getBookMarks(int n, WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        String string = "CrUser='" + CMyString.filterForSQL(user.getName()) + "' ";
        if (n != -1) {
            string = string + " AND MKind=" + n;
        }
        WCMFilter wCMFilter2 = new WCMFilter("", string, "MarkId ASC");
        wCMFilter2.mergeWith(wCMFilter);
        return BookMarks.openWCMObjs(user, wCMFilter2);
    }

    public BookMarks getBookMarks(MarkKind markKind, WCMFilter wCMFilter) throws WCMException {
        if (markKind == null) {
            int n = 0;
            return this.getBookMarks(n, wCMFilter);
        }
        return this.getBookMarks(markKind.getId(), wCMFilter);
    }

    public BookMarks getBookMarks(WCMFilter wCMFilter) throws WCMException {
        return this.getBookMarks(-1, wCMFilter);
    }

    public MarkKinds getMarkKinds(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("", "CrUser='" + CMyString.filterForSQL(user.getName()) + "' AND ParentId=0", "KindId ASC");
        wCMFilter2.mergeWith(wCMFilter);
        return MarkKinds.openWCMObjs(user, wCMFilter2);
    }

    public MarkKinds getChildren(MarkKind markKind, WCMFilter wCMFilter) throws WCMException {
        int n = 0;
        if (markKind != null) {
            n = markKind.getId();
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "ParentId=" + n + " AND CrUser='" + CMyString.filterForSQL(this.getLoginUser().getName()) + "'", "KindId");
        wCMFilter2.mergeWith(wCMFilter);
        return MarkKinds.openWCMObjs(this.getLoginUser(), wCMFilter2);
    }

    public boolean deleteMarkKind(MarkKind markKind) throws WCMException {
        this.assertNotNull(markKind);
        this.deleteChildren(markKind);
        String[] stringArray = new String[]{"DELETE FROM WCMMarkShare WHERE ObjType=307 AND ObjId=" + markKind.getId(), "DELETE FROM WCMBookMark WHERE MKind=" + markKind.getId()};
        this.getDBManager().sqlExecuteUpdate(stringArray);
        return markKind.delete(this.getLoginUser()) == 1;
    }

    private void deleteChildren(MarkKind markKind) throws WCMException {
        MarkKinds markKinds = this.getChildren(markKind, null);
        for (int i = 0; i < markKinds.size(); ++i) {
            MarkKind markKind2 = (MarkKind)markKinds.getAt(i);
            if (markKind2 == null) continue;
            this.deleteMarkKind(markKind2);
        }
    }

    public boolean deleteBookMark(BookMark bookMark) throws WCMException {
        this.assertNotNull(bookMark);
        String string = "DELETE FROM WCMMarkShare WHERE ObjType=303 AND ObjId=" + bookMark.getId();
        this.getDBManager().sqlExecuteUpdate(string);
        return bookMark.delete(ContextHelper.getLoginUser()) == 1;
    }

    private void shareMark(int n, String string, int n2, int n3) throws WCMException {
        if (string == null || string.length() == 0) {
            this.cancelShares(n2, n3);
        }
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=" + n2 + " AND ObjId=" + n3 + " AND ViewerType=" + n, "");
        MarkShares markShares = MarkShares.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (!markShares.isEmpty()) {
            markShares.removeAll();
        }
        MarkShare markShare = null;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            try {
                n4 = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                m_oLogger.error((Object)"failed to parse the id sequence!", (Throwable)numberFormatException);
                throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label1", "\u65e0\u6548\u7684\u5171\u4eab\u8005id"), numberFormatException);
            }
            markShare = (MarkShare)markShares.addNew();
            markShare.setObjId(n3);
            markShare.setObjType(n2);
            markShare.setViewerId(n4);
            markShare.setViewerType(n);
            markShare.setCrUser(ContextHelper.getLoginUser());
            markShares.update();
            markShares.clear();
        }
    }

    public Groups getSharedGroups(int n, CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        return this.getSharedGroups(n, cMSObj.getId());
    }

    public Users getSharedUsers(int n, CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        return this.getSharedUsers(n, cMSObj.getId());
    }

    private Users getSharedUsers(int n, int n2) throws WCMException {
        String string = "USERID IN (SELECT ViewerId FROM WCMMARKSHARE WHERE ObjType=" + n + " AND ObjId=" + n2 + " AND ViewerType=" + 204 + ")";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        return Users.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    private Groups getSharedGroups(int n, int n2) throws WCMException {
        String string = "GROUPID IN (SELECT ViewerId FROM WCMMARKSHARE WHERE ObjType=" + n + " AND ObjId=" + n2 + " AND ViewerType=" + 201 + ")";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    private boolean isValidViewer(int n, String string) throws WCMException {
        if (string == null) {
            return false;
        }
        switch (n) {
            case 204: {
                Users users = Users.findByIds(this.getLoginUser(), string);
                return users != null && !users.isEmpty();
            }
            case 201: {
                Groups groups = Groups.findByIds(this.getLoginUser(), string);
                return groups != null && !groups.isEmpty();
            }
            case 203: {
                return true;
            }
        }
        return false;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label3", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label4", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public BookMark saveBookMark(BookMark bookMark) throws WCMException {
        this.assertNotNull(bookMark);
        bookMark.save(ContextHelper.getLoginUser());
        return bookMark;
    }

    public MarkKind saveMarkKind(MarkKind markKind) throws WCMException {
        this.assertNotNull(markKind);
        markKind.save(ContextHelper.getLoginUser());
        return markKind;
    }

    public void cancelShares(int n, CMSBaseObjs cMSBaseObjs) throws WCMException {
        if (cMSBaseObjs == null || cMSBaseObjs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        for (int i = 0; i < cMSBaseObjs.size(); ++i) {
            this.cancelShares(n, cMSBaseObjs.getAt(i).getId());
        }
    }

    public void shareTo(int n, CMSBaseObjs cMSBaseObjs, int n2, String string) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            return;
        }
        if (cMSBaseObjs == null || cMSBaseObjs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        if (!this.isValidViewer(n2, string)) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label5", "\u65e0\u6548\u7684\u5171\u4eab\u8005!"));
        }
        for (int i = 0; i < cMSBaseObjs.size(); ++i) {
            this.shareMark(n2, string, n, cMSBaseObjs.getAt(i).getId());
        }
    }

    private void cancelShares(int n, int n2) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjId=" + n2 + " AND ObjType=" + n, "");
        MarkShares markShares = MarkShares.openWCMObjs(this.getLoginUser(), wCMFilter);
        markShares.removeAll();
    }

    private void assertNotNull(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label6", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label7", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }
}

