/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.comment.domain.DocumentTopicRelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class DocumentTopic
extends CMSObj {
    public static final int OBJ_TYPE = 1723559682;
    public static final String DB_TABLE_NAME = "XWCMDOCUMENTTOPIC";
    public static final String DB_ID_NAME = "DOCUMENTTOPICID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1723559682;
    }

    public String getTitle() {
        return this.getPropertyAsString("TITLE");
    }

    public boolean setTitle(String string) throws WCMException {
        return this.setProperty("TITLE", string);
    }

    public String getUrl() {
        return this.getPropertyAsString("URL");
    }

    public boolean setUrl(String string) throws WCMException {
        return this.setProperty("URL", string);
    }

    public String getDescription() {
        return this.getPropertyAsString("DESCRIPTION");
    }

    public boolean setDescription(String string) throws WCMException {
        return this.setProperty("DESCRIPTION", string);
    }

    public int getCategory() {
        return this.getPropertyAsInt("CATEGORY", 0);
    }

    public boolean setCategory(int n) throws WCMException {
        return this.setProperty("CATEGORY", n);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("CHANNELID", 0);
    }

    public boolean setChannelId(int n) throws WCMException {
        return this.setProperty("CHANNELID", n);
    }

    public Channel getChannel() {
        Channel channel = null;
        try {
            channel = Channel.findById(this.getChannelId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return channel;
    }

    public WebSite getSite() {
        Channel channel = this.getChannel();
        if (channel != null) {
            try {
                return channel.getSite();
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isValid() throws WCMException {
        if (!this.isAddMode() && !this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(DocumentTopic.class, "DocumentTopic.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(DocumentTopic.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public static final DocumentTopic findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (DocumentTopic)BaseObj.findById(DocumentTopic.class, n);
    }

    public static final DocumentTopic createNewInstance() throws WCMException {
        return (DocumentTopic)BaseObj.createNewInstance(DocumentTopic.class);
    }

    public static final DocumentTopic findByKey(Object object) throws WCMException {
        return (DocumentTopic)BaseObj.findByKey(DocumentTopic.class, object);
    }

    public void deleteOthersBeforeDelete() {
        super.deleteOthersBeforeDelete();
        DocumentTopicRelationMgr documentTopicRelationMgr = (DocumentTopicRelationMgr)DreamFactory.createObjectById("DocumentTopicRelationMgr");
        try {
            documentTopicRelationMgr.deleteTopicDocRelation(this.id);
        }
        catch (WCMException wCMException) {
            throw new RuntimeException("Failed to delete topicwith [ID=" + this.id + "], for you failed to delete the relation befor deleting this Topic", wCMException);
        }
    }
}

