/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.handlers;

import com.trs.DreamFactory;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.infra.I18NMessage;
import org.apache.log4j.Logger;

public class AutoToNextHandler
implements IActionHandler {
    private static Logger logger = Logger.getLogger(AutoToNextHandler.class);
    private IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");

    public boolean execute(ExecuteContext executeContext, FlowAction flowAction) {
        ActionParametersAnalyser actionParametersAnalyser = new ActionParametersAnalyser(flowAction.getParams());
        String string = actionParametersAnalyser.getParameterValue("NextNode");
        if (string == null || string.length() == 0) {
            logger.warn((Object)I18NMessage.get(AutoToNextHandler.class, "AutoToNextHandler.label1", "\u6ca1\u6709\u6307\u5b9a\u4e0b\u4e00\u4e2a\u8282\u70b9\u7684\u540d\u79f0\uff01"));
            return false;
        }
        FlowNode flowNode = null;
        try {
            flowNode = FlowNode.findByName(executeContext.getCurrNode().getFlowId(), string);
            if (flowNode == null) {
                logger.warn((Object)(I18NMessage.get(AutoToNextHandler.class, "AutoToNextHandler.label2", "\u6307\u5b9a\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9[Name=") + string + I18NMessage.get(AutoToNextHandler.class, "AutoToNextHandler.label3", "]\u4e0d\u5b58\u5728\uff01")));
                return false;
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(AutoToNextHandler.class, "AutoToNextHandler.label4", "\u83b7\u53d6\u4e0b\u4e00\u4e2a\u8282\u70b9\u53d1\u751f\u9519\u8bef\uff01"), (Throwable)exception);
            return false;
        }
        try {
            FlowContext flowContext = executeContext.getFlowContext();
            flowContext.setFromRule(true);
            if (flowNode.isEndNode()) {
                this.m_oFlowServer.forceEnd(flowContext);
            } else {
                this.m_oFlowServer.autoToNextNode(flowContext, flowNode);
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(AutoToNextHandler.class, "AutoToNextHandler.label5", "\u4ea4\u7ed9\u4e0b\u4e00\u4e2a\u8282\u70b9\u5931\u8d25\uff01"), (Throwable)exception);
            return false;
        }
        return true;
    }
}

