/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.Flows;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.log4j.Logger;

public class FlowEmployMgr {
    private static final Logger logger = Logger.getLogger((String)FlowEmployMgr.class.getName());
    public static final String SQL_QUERY_FLOW_USED = "EXISTS(SELECT employ.FLOWID FROM WCMFLOWEMPLOY employ WHERE employ.EMPLOYERTYPE=? And employ.EMPLOYERID=? AND employ.FLOWID=WCMFLOW.FLOWID)";
    public static final String SQL_QUERY_USEING_FLOW = "EXISTS(SELECT employ.EMPLOYERID FROM WCMFLOWEMPLOY employ WHERE employ.FLOWID=?  AND employ.EMPLOYERTYPE=?  AND employ.EMPLOYERID=";

    public FlowEmploys getEmploysOf(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getEmploysOfEmployer(baseObj.getWCMType(), baseObj.getId());
    }

    public FlowEmploys getEmploysOfEmployer(int n, int n2) throws WCMException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EMPLOYERID=").append(n2);
            stringBuffer.append(" AND EMPLOYERTYPE=").append(n);
            WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "FLOWEMPLOYID desc");
            stringBuffer.setLength(0);
            FlowEmploys flowEmploys = new FlowEmploys(ContextHelper.getLoginUser());
            flowEmploys.open(wCMFilter);
            return flowEmploys;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query flow employs of the specified employer!", exception);
        }
    }

    public void setFlow(BaseObj baseObj, int n) throws WCMException {
        this.setFlow(baseObj.getWCMType(), baseObj.getId(), n);
    }

    public void setFlow(int n, int n2, int n3) throws WCMException {
        User user = ContextHelper.getLoginUser();
        FlowEmploys flowEmploys = new FlowEmploys(user, 1, 1);
        try {
            WCMFilter wCMFilter = new WCMFilter("", "EMPLOYERID=? AND EMPLOYERTYPE=?", "");
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n);
            wCMFilter.setMaxRowNumber(1);
            flowEmploys.open(wCMFilter);
            FlowEmploy flowEmploy = null;
            if (flowEmploys.isEmpty()) {
                flowEmploy = new FlowEmploy();
                flowEmploy.setEmployer(n, n2);
                flowEmploy.setFlow(n3);
                flowEmploy.insert(user);
            } else {
                flowEmploy = (FlowEmploy)flowEmploys.getAt(0);
                if (flowEmploy.getFlowId() == n3) {
                    return;
                }
                if (flowEmploy.canEdit(user)) {
                    flowEmploy.setFlow(n3);
                    flowEmploy.update(user);
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to set the employer flow!", exception);
        }
        finally {
            flowEmploys.clear();
        }
    }

    public Flows getEmployedFlows(BaseObj baseObj) throws WCMException {
        try {
            WCMFilter wCMFilter = new WCMFilter("", SQL_QUERY_FLOW_USED, "");
            wCMFilter.addSearchValues(baseObj.getWCMType());
            wCMFilter.addSearchValues(baseObj.getId());
            wCMFilter.setMaxRowNumber(1);
            Flows flows = new Flows(ContextHelper.getLoginUser());
            flows.open(wCMFilter);
            return flows;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the employed flows of the specified employer.", exception);
        }
    }

    public Flow getFlow(BaseObj baseObj) throws WCMException {
        return this.getEmployedFlow(baseObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Flow getEmployedFlow(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            return null;
        }
        Flows flows = null;
        try {
            flows = this.getEmployedFlows(baseObj);
            Flow flow = flows.isEmpty() ? null : (Flow)flows.getAt(0);
            return flow;
        }
        finally {
            if (flows != null) {
                flows.clear();
            }
        }
    }

    public FlowEmploys getEmployers(Flow flow, WCMFilter wCMFilter) throws WCMException {
        if (flow == null) {
            throw new WCMException(10, "Valid flow required!");
        }
        try {
            WCMFilter wCMFilter2 = new WCMFilter("", "FLOWID=" + flow.getId(), "");
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            return FlowEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the folders who use the specified flow.", exception);
        }
    }

    public int clearEmploysOfEmployer(BaseObj baseObj) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, "Valid publish element required!");
        }
        return this.clearEmploysOfEmployer(baseObj.getWCMType(), baseObj.getId());
    }

    public int clearEmploysOfEmployer(int n, int n2) throws WCMException {
        User user = ContextHelper.getLoginUser();
        FlowEmploys flowEmploys = new FlowEmploys(user, 1, 1);
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        wCMFilter.setWhere("EMPLOYERID=? AND EMPLOYERTYPE=?");
        wCMFilter.setMaxRowNumber(1);
        wCMFilter.addSearchValues(n2);
        wCMFilter.addSearchValues(n);
        flowEmploys.open(wCMFilter);
        if (flowEmploys.isEmpty()) {
            return 0;
        }
        FlowEmploy flowEmploy = (FlowEmploy)flowEmploys.getAt(0);
        if (flowEmploy != null) {
            return flowEmploy.delete(user);
        }
        return 0;
    }

    public int clearEmploysOfFlow(Flow flow) throws WCMException {
        if (flow == null) {
            throw new WCMException(10, "Valid flow required!");
        }
        return this.clearEmploysOfFlow(flow.getId());
    }

    public int clearEmploysOfFlow(int n) throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMFLOWEMPLOY WHERE FLOWID=?");
            preparedStatement.setInt(1, n);
            int n2 = preparedStatement.executeUpdate();
            return n2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to clear flow employs records!", exception);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public BaseObjs getChannelsUseingFlow(Flow flow, BaseObjs baseObjs, int n, String string, WCMFilter wCMFilter) throws WCMException {
        String string2 = string;
        String string3 = baseObjs.getIdFieldName();
        StringBuffer stringBuffer = new StringBuffer(SQL_QUERY_USEING_FLOW.length() + string2.length() + string3.length() + 3);
        stringBuffer.append(SQL_QUERY_USEING_FLOW + string2 + "." + string3 + ")");
        WCMFilter wCMFilter2 = new WCMFilter(null, stringBuffer.toString(), null);
        wCMFilter2.addSearchValues(flow.getId());
        wCMFilter2.addSearchValues(n);
        wCMFilter2.mergeWith(wCMFilter);
        baseObjs.open(wCMFilter2);
        return baseObjs;
    }

    public void setEmployersOfFlow(User user, int n, int n2, int[] nArray) throws WCMException {
        int n3;
        WCMFilter wCMFilter = new WCMFilter("", "FlowId=? and EmployerType=?", "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        FlowEmploys flowEmploys = FlowEmploys.openWCMObjs(user, wCMFilter);
        flowEmploys.setPageSize(flowEmploys.size());
        for (n3 = flowEmploys.size() - 1; n3 >= 0; --n3) {
            FlowEmploy flowEmploy = (FlowEmploy)flowEmploys.getAt(n3);
            if (flowEmploy == null) continue;
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (flowEmploy.getEmployerId() != nArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            flowEmploys.remove(flowEmploy);
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            this.setFlow(n2, nArray[n3], n);
        }
    }
}

