/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class Flow
extends CMSObj {
    public static final int OBJ_TYPE = 401;
    public static final String DB_TABLE_NAME = "WCMFLOW";
    public static final String DB_ID_NAME = "FLOWID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 401;
    }

    public String getName() {
        return (String)this.getProperty("FLOWNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("FLOWNAME", string);
    }

    public String getStartNodeName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setStartNodeName(String string) throws WCMException {
        return this.setProperty("SNAME", string);
    }

    public FlowNode getStartNode() throws WCMException {
        return FlowNode.findByName(this.getId(), this.getStartNodeName());
    }

    public String getEndNodeName() {
        return (String)this.getProperty("ENAME");
    }

    public boolean setEndNodeName(String string) throws WCMException {
        return this.setProperty("ENAME", string);
    }

    public FlowNode getEndNode() throws WCMException {
        return FlowNode.findByName(this.getId(), this.getEndNodeName());
    }

    public String getDesc() {
        return (String)this.getProperty("FLOWDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("FLOWDESC", string);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public BaseObj getOwner() throws WCMException {
        int n = this.getOwnerType();
        if (n == 1 || n == 0) {
            return new WCMSystemObject(this.getOwnerId());
        }
        return BaseObj.findById(this.getOwnerType(), this.getOwnerId());
    }

    public boolean setOwner(int n, int n2) throws WCMException {
        return this.setOwnerType(n) && this.setOwnerId(n2);
    }

    public boolean setOwnerType(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Flow.class, "Flow.label1", "\u5de5\u4f5c\u6d41\u6240\u5728\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
        }
        return this.setProperty("OWNERTYPE", n);
    }

    public int getOwnerType() {
        return this.getPropertyAsInt("OWNERTYPE", 0);
    }

    public boolean setOwnerId(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Flow.class, "Flow.label1", "\u5de5\u4f5c\u6d41\u6240\u5728\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4fee\u6539\uff01"));
        }
        return this.setProperty("OWNERID", n);
    }

    public int getOwnerId() {
        return this.getPropertyAsInt("OWNERID", 0);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getProperty("FLOWNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Flow.isValid)"));
            }
            if (this.getProperty("SNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label3", "\u5c5e\u6027StartNodeName\u6ca1\u6709\u8bbe\u7f6e\uff08Flow.isValid\uff09"));
            }
            if (this.getProperty("ENAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Flow.class, "Flow.label4", "\u5c5e\u6027EndNodeName\u6ca1\u6709\u8bbe\u7f6e\uff08Flow.isValid\uff09"));
            }
            if (this.getProperty("OWNERTYPE") == null) {
                this.setOwnerType(0);
            }
            if (this.getProperty("OWNERID") == null) {
                this.setOwnerId(0);
            }
        } else {
            string = (String)this.getNewProperty("FLOWNAME");
        }
        if (string != null) {
            String string2 = "(FLOWNAME='" + CMyString.filterForSQL(string) + "' AND OwnerType=" + this.getOwnerType() + " AND OwnerId=" + this.getOwnerId() + ")";
            if (!this.isAddMode()) {
                string2 = string2 + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(Flow.class, "Flow.label5", "\u540d\u79f0[") + string + I18NMessage.get(Flow.class, "Flow.label6", "]\u5df2\u7ecf\u5b58\u5728(Flow.isValid)"));
            }
        }
        return true;
    }

    public int delete(User user) throws WCMException {
        Object object;
        try {
            object = new String[]{"delete  from wcmFlowMonOper where FlowId=" + this.getId()};
            this.getDBManager().sqlExecuteUpdate((String[])object);
        }
        catch (Exception exception) {
            throw new WCMException(40, I18NMessage.get(Flow.class, "Flow.label7", "\u5220\u9664\u76d1\u63a7\u7528\u6237\u548c\u7528\u6237\u7ec4\u5931\u8d25\uff08Flow.delete\uff09"), exception);
        }
        try {
            object = this.getFlowNodes(user);
            ((BaseObjs)object).removeAll();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(Flow.class, "Flow.label8", "\u5220\u9664\u5de5\u4f5c\u6d41\u8282\u70b9\u5931\u8d25\uff08Flow.delete\uff09"), exception);
        }
        object = new String[]{"delete from wcmChnlFlow where FlowId = " + this.getId()};
        this.getDBManager().sqlExecuteUpdate((String[])object);
        return super.delete(user);
    }

    public FlowNodes getFlowNodes(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "FlowId=" + this.getId(), "");
        return FlowNodes.openWCMObjs(user, wCMFilter);
    }

    public Users getMonitorUsers(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("wcmFlowMonOper", "OperType=204 and  FlowId=" + this.getId(), "", "OPERID as USERID");
        return Users.openWCMObjs(user, wCMFilter);
    }

    public Groups getMonitorGroups(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("wcmFlowMonOper", "OperType=201 and  FlowId=" + this.getId(), "", "OPERID as GROUPID");
        return Groups.openWCMObjs(user, wCMFilter);
    }

    public static final Flow findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Flow)BaseObj.findById(Flow.class, n);
    }

    public static final Flow createNewInstance() throws WCMException {
        return (Flow)BaseObj.createNewInstance(Flow.class);
    }

    public static final Flow findByKey(Object object) throws WCMException {
        return (Flow)BaseObj.findByKey(Flow.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Flow.class, "Flow.label10", "[\u5de5\u4f5c\u6d41-") + this.getId() + "]";
    }
}

