/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.Vector;
import org.aton.cache.LRUCacheContainer;

public class RoleUserCacheMgr
implements ICacheMgr {
    private LRUCacheContainer m_lruRolesCache = new LRUCacheContainer();

    public RoleUserCacheMgr() {
        this.m_lruRolesCache.setMaxSize(5000);
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (this.isListening(baseObj)) {
            RoleUser roleUser = (RoleUser)baseObj;
            this.addToCache(roleUser.getUserId(), roleUser.getRoleId(), roleUser.getSiteId());
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj)) {
            RoleUser roleUser = (RoleUser)baseObj;
            this.removeFromCache(roleUser.getUserId(), roleUser.getRoleId(), roleUser.getSiteId());
        }
    }

    public boolean init() throws WCMException {
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        if (this.m_lruRolesCache != null) {
            this.m_lruRolesCache.clear();
            this.m_lruRolesCache = null;
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
    }

    final Roles getRoles(User user) throws WCMException {
        return this.getRoles(user.getId());
    }

    public final Roles getRoles(User user, WebSite webSite) throws WCMException {
        int n = user.getId();
        Roles roles = Roles.createNewInstance(null);
        roles.addElements(this.initCache(n, -1));
        if (webSite != null) {
            int n2 = webSite.getId();
            roles.addElements(this.initCache(n, n2));
            roles.addElements(this.initCache(n, 0));
        }
        roles.addElement(Role.findById(2));
        return roles;
    }

    private void addToCache(int n, int n2, int n3) throws WCMException {
        Roles roles = this.initCache(n, n3);
        if (roles.indexOf(n2) == -1) {
            roles.addElement(n2);
        }
    }

    private void removeFromCache(int n, int n2, int n3) throws WCMException {
        Roles roles = this.initCache(n, n3);
        roles.remove(n2, false);
    }

    private Roles getRoles(int n) throws WCMException {
        Integer n2 = new Integer(n);
        Roles roles = (Roles)this.m_lruRolesCache.get((Object)n2);
        if (roles == null) {
            roles = this.initCache(n);
        }
        return roles;
    }

    private synchronized Roles initCache(int n) throws WCMException {
        Roles roles = this.initCache(n, -1);
        Roles roles2 = this.initCache(n, 0);
        Roles roles3 = Roles.createNewInstance(null);
        roles3.addElements(roles);
        roles3.addElements(roles2);
        return roles3;
    }

    private synchronized Roles initCache(int n, int n2) throws WCMException {
        String string = this.makeKey(n, n2);
        Roles roles = (Roles)this.m_lruRolesCache.get((Object)string);
        if (roles != null) {
            return roles;
        }
        String string2 = "exists(select 1 from WCMRoleUser where UserId=? and SiteId=? and WCMRoleUser.RoleId=WCMRole.RoleId)";
        WCMFilter wCMFilter = new WCMFilter("WCMROLE", string2, "RoleId");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        roles = Roles.openWCMObjs(User.getSystem(), wCMFilter);
        this.m_lruRolesCache.put((Object)string, (Object)roles);
        return roles;
    }

    private String makeKey(int n, int n2) {
        return n + "_" + n2;
    }

    private boolean isListening(BaseObj baseObj) {
        return baseObj != null && baseObj instanceof RoleUser;
    }

    public static void main(String[] stringArray) {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(1));
        System.out.println(vector.size());
        vector.add(new Integer(1));
        System.out.println(vector.size());
    }
}

