/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUser;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.cache.ICacheMgr;
import org.aton.cache.LRUCacheContainer;

public class GroupAdminsCacheMgr
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify,
ICacheMgr {
    protected LRUCacheContainer m_lruGroupsCache = new LRUCacheContainer();

    public GroupAdminsCacheMgr() {
        this.m_lruGroupsCache.setMaxSize(4000);
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        GroupUser groupUser = (GroupUser)baseObj;
        if (groupUser.isAdministrator()) {
            this.addToCache(groupUser);
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        GroupUser groupUser = (GroupUser)baseObj;
        if (groupUser.isAdministrator()) {
            this.removeFromCache(groupUser);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        GroupUser groupUser = (GroupUser)baseObj;
        if (groupUser.isChangeProperty("ISADMINISTRATOR")) {
            int n2 = groupUser.getNewPropertyAsInt("ISADMINISTRATOR", 0);
            if (n2 == 0) {
                this.removeFromCache(groupUser);
            } else {
                this.addToCache(groupUser);
            }
        }
    }

    public Users getAdmins(Group group) throws WCMException {
        this.assertNotNull(group);
        Users users = this.getGroupAdmins(group.getId());
        Users users2 = new Users(User.getSystem());
        users2.addWith(users);
        return users2;
    }

    public boolean init() throws WCMException {
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        if (this.m_lruGroupsCache != null) {
            this.m_lruGroupsCache.clear();
            this.m_lruGroupsCache = null;
        }
    }

    private void assertNotNull(Group group) throws WCMException {
        if (group == null) {
            throw new WCMException(10, I18NMessage.get(GroupAdminsCacheMgr.class, "GroupAdminsCacheMgr.label1", "\u65e0\u6548\u7684\u7528\u6237\u7ec4\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5176\u7ba1\u7406\u5458\u96c6\u5408!"));
        }
    }

    private void addToCache(GroupUser groupUser) throws WCMException {
        int n = groupUser.getUserId();
        Users users = this.getGroupAdmins(groupUser.getGroupId());
        if (users.indexOf(n) == -1) {
            users.addElement(n);
        }
    }

    private void removeFromCache(GroupUser groupUser) throws WCMException {
        Users users = this.getGroupAdmins(groupUser.getGroupId());
        users.remove(groupUser.getUserId(), false);
    }

    private Users getGroupAdmins(int n) throws WCMException {
        Integer n2 = new Integer(n);
        Users users = (Users)this.m_lruGroupsCache.get((Object)n2);
        if (users == null) {
            users = this.initCache(n);
        }
        return users;
    }

    protected synchronized Users initCache(int n) throws WCMException {
        Integer n2 = new Integer(n);
        Users users = (Users)this.m_lruGroupsCache.get((Object)n2);
        if (users != null) {
            return users;
        }
        String string = "GroupId=? AND IsAdministrator=1";
        WCMFilter wCMFilter = new WCMFilter("WCMGrpUser", string, "", "UserId");
        wCMFilter.addSearchValues(n);
        users = Users.openWCMObjs(null, wCMFilter);
        this.m_lruGroupsCache.put((Object)n2, (Object)users);
        return users;
    }
}

