/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.IAdministratorCacheMgr;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class AdministratorCacheMgr
implements IAdministratorCacheMgr {
    private static Logger s_logger = Logger.getLogger(AdministratorCacheMgr.class);
    private Users m_oAdminUsers;

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        RoleUser roleUser = (RoleUser)baseObj;
        if (roleUser.getRoleId() == 1) {
            this.addAdminToAdminUsers(User.findById(roleUser.getUserId()));
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        RoleUser roleUser = (RoleUser)baseObj;
        if (roleUser.getRoleId() == 1) {
            this.removeAdminFromAdminUsers(User.findById(roleUser.getUserId()));
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
    }

    public Users getAdminUsers() throws WCMException {
        if (this.m_oAdminUsers == null) {
            this.initAdminUsers();
        }
        return this.m_oAdminUsers;
    }

    public boolean init() throws WCMException {
        this.initAdminUsers();
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public void clear() {
        this.clearAdminUsers();
    }

    protected void initAdminUsers() throws WCMException {
        if (this.m_oAdminUsers != null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label1", "\u6b63\u5728\u521d\u59cb\u5316\u7ba1\u7406\u5458\u7f13\u51b2..."));
        WCMFilter wCMFilter = new WCMFilter("WCMRoleUser", "RoleId=1", "", "UserId");
        this.m_oAdminUsers = Users.openWCMObjs(User.getSystem(), wCMFilter);
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label2", "\u521d\u59cb\u5316\u7ba1\u7406\u5458\u7f13\u51b2\u5b8c\u6210\uff01"));
    }

    protected void clearAdminUsers() {
        if (this.m_oAdminUsers == null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label3", "\u6b63\u5728\u6e05\u7a7a\u7ba1\u7406\u5458\u7f13\u51b2..."));
        this.m_oAdminUsers.clear();
        this.m_oAdminUsers = null;
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label4", "\u6e05\u7a7a\u7ba1\u7406\u5458\u7f13\u51b2\u5b8c\u6210!"));
    }

    protected void removeAdminFromAdminUsers(User user) throws WCMException {
        if (user == null) {
            return;
        }
        this.getAdminUsers().remove(user, false);
    }

    protected void addAdminToAdminUsers(User user) throws WCMException {
        if (user == null) {
            return;
        }
        if (this.getAdminUsers().indexOf(user) != -1) {
            return;
        }
        this.getAdminUsers().addElement(user);
    }
}

