/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.GroupAuthServer;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.domain.RightObjectFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class AuthServer {
    private static Logger logger = Logger.getLogger(AuthServer.class);
    private static RightConfigServer s_oRightConfigServer;
    private static RoleUserCacheMgr roleUserCacheMgr;

    public static boolean hasRight(User user, CMSObj cMSObj, int n) throws WCMException {
        if (cMSObj instanceof WCMSystemObject) {
            return user.isAdministrator();
        }
        return AuthServer.hasRight(user, cMSObj, n, false);
    }

    public static boolean hasRightInObjects(User user, CMSBaseObjs cMSBaseObjs, int n) throws WCMException {
        int n2 = cMSBaseObjs.size();
        for (int i = 0; i < n2; ++i) {
            CMSObj cMSObj = (CMSObj)cMSBaseObjs.getAt(i);
            if (cMSObj == null || AuthServer.hasRight(user, cMSObj, n)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasRight(User user, CMSObj cMSObj, int n, boolean bl) throws WCMException {
        IRightObj iRightObj;
        if (cMSObj instanceof Document) {
            Document document = (Document)cMSObj;
            if (document == null) {
                return false;
            }
            return DocumentAuthServer.hasRight(user, (BaseChannel)document.getChannel(), document, n);
        }
        if (cMSObj instanceof ChnlDoc) {
            ChnlDoc chnlDoc = (ChnlDoc)cMSObj;
            if (chnlDoc == null) {
                return false;
            }
            return DocumentAuthServer.hasRight(user, chnlDoc, n);
        }
        if (cMSObj instanceof Group) {
            return GroupAuthServer.hasRight(user, (Group)cMSObj, n);
        }
        if (n == -1) {
            return true;
        }
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isSystem()) {
            logger.warn((Object)I18NMessage.get(AuthServer.class, "AuthServer.label2", "\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!"));
            return false;
        }
        if (cMSObj == null) {
            return AuthServer.hasAttributeRight(user, n);
        }
        if (!bl && (iRightObj = RightObjectFactory.makeRightObjectFrom(cMSObj)) != null) {
            return iRightObj.hasRight(user, n);
        }
        return AuthServer.hasRightOnSelf(user, cMSObj, n);
    }

    private static boolean hasAttributeRight(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        int n2 = WCMRightTypes.getExtMaxIndex();
        int n3 = WCMRightTypes.getSysMinIndex();
        if (n < n3 || n > n2) {
            return false;
        }
        int n4 = WCMRightTypes.getSysMaxIndex();
        RightValue rightValue = new RightValue();
        rightValue.load(user, 1, n <= n4 ? 1 : 2);
        return rightValue.isHasRight(n);
    }

    private static boolean hasStatisticAttributeRight(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        int n2 = WCMRightTypes.getStatisticMaxIndex();
        int n3 = WCMRightTypes.getSysMinIndex();
        if (n < n3 || n > n2) {
            return false;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(user, 1, 3);
        return rightValue.isHasRight(n);
    }

    public static boolean hasAttributeRight(User user) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        int n = WCMRightTypes.getSysMinIndex();
        int n2 = WCMRightTypes.getSysMaxIndex();
        for (int i = n; i <= n2; ++i) {
            if (!AuthServer.hasAttributeRight(user, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtendedRight(User user) throws WCMException {
        int n;
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        int n2 = WCMRightTypes.getExtMaxIndex();
        for (int i = n = WCMRightTypes.getExtMinIndex(); i <= n2; ++i) {
            if (!AuthServer.hasAttributeRight(user, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtendedRight(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        if (n < 53 || n > 60) {
            return false;
        }
        return AuthServer.hasAttributeRight(user, n);
    }

    public static boolean hasStatisticRight(User user) throws WCMException {
        int n;
        if (user == null) {
            throw new WCMException("");
        }
        if (user.isAdministrator()) {
            return true;
        }
        int n2 = WCMRightTypes.getStatisticMaxIndex();
        for (int i = n = WCMRightTypes.getStatisticMinIndex(); i <= n2; ++i) {
            if (!AuthServer.hasStatisticAttributeRight(user, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStatisticRight(User user, int n) throws WCMException {
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        if (n < 60 || n > 60) {
            return false;
        }
        return AuthServer.hasStatisticAttributeRight(user, n);
    }

    public static boolean hasRightOnSelf(User user, int n, int n2, int n3) throws WCMException {
        if (user == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01");
        }
        if (user.isAdministrator()) {
            return true;
        }
        RightValue rightValue = new RightValue();
        rightValue.load(user, n, n2);
        return rightValue.isHasRight(n3);
    }

    public static boolean hasRightOnSelf(User user, CMSObj cMSObj, int n) throws WCMException {
        if (n == -1) {
            return true;
        }
        if (user == null) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label1", "\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01"));
        }
        if (user.isSystem()) {
            logger.warn((Object)I18NMessage.get(AuthServer.class, "AuthServer.label2", "\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!"));
            return false;
        }
        if (cMSObj == null) {
            return user.isAdministrator();
        }
        if (AuthServer.hasSuperRight(user, cMSObj)) {
            return true;
        }
        BaseObjs baseObjs = null;
        BaseObjs baseObjs2 = null;
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        try {
            CMSObj cMSObj2;
            int n2;
            long l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 204, user.getId(), -1L);
            if (l != -1L) {
                boolean bl = AuthServer.hasRight(l, n);
                return bl;
            }
            baseObjs = user.getRoles();
            for (n2 = 0; n2 < baseObjs.size(); ++n2) {
                cMSObj2 = (Role)baseObjs.getAt(n2);
                if (cMSObj2 == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + baseObjs.getIdAt(n2) + "] of user[" + user.getName() + "] not exists!"));
                    continue;
                }
                if (((Role)cMSObj2).isSystemRole() || (l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 203, baseObjs.getIdAt(n2), -1L)) == -1L || !AuthServer.hasRight(l, n)) continue;
                boolean bl = true;
                return bl;
            }
            baseObjs = roleUserCacheMgr.getRoles(user, RightValue.getSite(cMSObj.getWCMType(), cMSObj.getId()));
            for (n2 = 0; n2 < baseObjs.size(); ++n2) {
                cMSObj2 = (Role)baseObjs.getAt(n2);
                if (cMSObj2 == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + baseObjs.getIdAt(n2) + "] of user[" + user.getName() + "] not exists!"));
                    continue;
                }
                l = ((Role)cMSObj2).isSystemRole() ? ((Role)cMSObj2).getRightValue() : rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 203, baseObjs.getIdAt(n2), -1L);
                if (l == -1L || !AuthServer.hasRight(l, n)) continue;
                boolean bl = true;
                return bl;
            }
            baseObjs2 = user.getGroups();
            block13: for (n2 = 0; n2 < baseObjs2.size(); ++n2) {
                cMSObj2 = (Group)baseObjs2.getAt(n2);
                if (cMSObj2 == null) continue;
                l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 201, baseObjs2.getIdAt(n2), -1L);
                if (l == -1L) {
                    for (Group group = ((Group)cMSObj2).getParent(); group != null && baseObjs2.indexOf(group.getId()) < 0; group = group.getParent()) {
                        l = rightCacheMgr.getRightValue(cMSObj.getWCMType(), cMSObj.getId(), 201, group.getId(), -1L);
                        if (l == -1L) continue;
                        if (!AuthServer.hasRight(l, n)) continue block13;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
                if (!AuthServer.hasRight(l, n)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(AuthServer.class, "AuthServer.label3", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), wCMException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(AuthServer.class, "AuthServer.label3", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), exception);
        }
        finally {
            if (baseObjs != null) {
                baseObjs.clear();
            }
            if (baseObjs2 != null) {
                baseObjs2.clear();
            }
        }
        return false;
    }

    public static boolean hasRight(CMSObj cMSObj, CMSObj cMSObj2, int n) throws WCMException {
        if (cMSObj instanceof User) {
            return AuthServer.hasRight((User)cMSObj, cMSObj2, n);
        }
        RightValue rightValue = AuthServer.getRightMgr().getRightValue(cMSObj2, cMSObj);
        return AuthServer.hasRight(rightValue, n);
    }

    public static boolean hasRight(RightValue rightValue, int n) throws WCMException {
        if (rightValue == null) {
            throw new WCMException(20, I18NMessage.get(AuthServer.class, "AuthServer.label4", "\u6743\u9650\u503c\u5f02\u5e38\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u6743\u9650\uff01"));
        }
        if (n == 64 && rightValue.getValue() > 0L) {
            return true;
        }
        if (rightValue.isHasRight(n)) {
            return true;
        }
        return AuthServer.hasSimlarRight(rightValue, n);
    }

    public static boolean hasRight(long l, int n) {
        if (n == 64 && l > 0L) {
            return true;
        }
        CMyBitsValue cMyBitsValue = new CMyBitsValue(l);
        if (cMyBitsValue.getBit(n)) {
            return true;
        }
        return AuthServer.hasSimlarRight(cMyBitsValue, n);
    }

    private static boolean hasSimlarRight(CMyBitsValue cMyBitsValue, int n) {
        int[] nArray = AuthServer.getRightConfigServer().getSimilarIndexs(n);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) {
                return false;
            }
            if (!cMyBitsValue.getBit(n2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRight(User user, CMSObj cMSObj) throws WCMException {
        return AuthServer.hasRight(user, cMSObj, 64);
    }

    public static boolean hasSuperRight(User user, CMSObj cMSObj) throws WCMException {
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(AuthServer.class, "AuthServer.label5", "\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u6821\u9a8c\u6743\u9650!"));
        }
        if (user.isAdministrator()) {
            return true;
        }
        return cMSObj != null && user.getName().equalsIgnoreCase(cMSObj.getCrUserName());
    }

    public static boolean setSystemMgrRights(int n, List list) throws WCMException {
        if (!ContextHelper.getLoginUser().isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(AuthServer.class, "AuthServer.label6", "\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\u7cfb\u7edf\u5c5e\u6027\u7684\u6743\u9650\uff01"));
        }
        AuthServer.deleteAttributeRights(WCMObjHelper.toIdsString(list), n);
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Right right = (Right)list.get(i);
            if (right == null) {
                logger.error((Object)I18NMessage.get(AuthServer.class, "AuthServer.label7", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (AuthServer.saveAttributeRight(right, n)) continue;
            logger.error((Object)I18NMessage.get(AuthServer.class, "AuthServer.label8", "\u4ece\u6743\u9650\u96c6\u5408\u4e2d\u4fdd\u5b58\u4e00\u4e2a\u6743\u9650\u65f6\u53d1\u751f\u9519\u8bef"));
        }
        return true;
    }

    public static IRightHost makeRightHost(int n, int n2) throws WCMException {
        IRightHost iRightHost = null;
        try {
            iRightHost = (IRightHost)((Object)BaseObj.findById(n, n2));
        }
        catch (ClassCastException classCastException) {
            throw new WCMException(I18NMessage.get(AuthServer.class, "AuthServer.label9", "\u6307\u5b9a\u7684\u5143\u7d20\u5bf9\u8c61[HostType=") + n + ",HostId=" + n2 + I18NMessage.get(AuthServer.class, "AuthServer.label10", "]\u4e0d\u662fIRightHost\u7684\u5b9e\u73b0\uff01"));
        }
        return iRightHost;
    }

    private static boolean deleteAttributeRights(String string, int n) throws WCMException {
        String string2 = "OBJTYPE=1 and OBJID= " + n;
        if (string.length() > 0) {
            string2 = string2 + " and RIGHTID not in (" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        Rights rights = Rights.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        rights.removeAll(true);
        return true;
    }

    private static IRightMgr getRightMgr() throws WCMException {
        IRightMgr iRightMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (iRightMgr == null) {
            throw new WCMException(1400, I18NMessage.get(AuthServer.class, "AuthServer.label11", "IRightMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        return iRightMgr;
    }

    private static boolean saveAttributeRight(Right right, int n) throws WCMException {
        if (right == null) {
            return false;
        }
        if (right.getObjType() == 0) {
            right.setObject(1, n);
        }
        right.save(ContextHelper.getLoginUser());
        return true;
    }

    public static RightValue getRightValue(CMSObj cMSObj, User user) throws WCMException {
        return AuthServer.getRightMgr().getRightValue(cMSObj, user);
    }

    public static RightValue getRightValue(CMSObj cMSObj, CMSObj cMSObj2) throws WCMException {
        return AuthServer.getRightMgr().getRightValue(cMSObj, cMSObj2);
    }

    public static String getLogicalRightValue(CMSObj cMSObj, User user, int[] nArray) throws WCMException {
        int n;
        if (nArray == null || nArray.length <= 0) {
            return "0";
        }
        if (user != null && (user.isAdministrator() || user.equals(cMSObj.getCrUser())) && cMSObj.getWCMType() != 605) {
            return "1";
        }
        Arrays.sort(nArray);
        int n2 = nArray[nArray.length - 1] + 1;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.setLength(n2);
        for (n = 0; n < n2; ++n) {
            stringBuffer.setCharAt(n, '0');
        }
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n];
            if (n3 < 0) continue;
            stringBuffer.setCharAt(n3, AuthServer.hasRight(user, cMSObj, n3) ? (char)'1' : '0');
        }
        stringBuffer = stringBuffer.reverse();
        return stringBuffer.toString();
    }

    private static RightConfigServer getRightConfigServer() {
        if (s_oRightConfigServer == null) {
            s_oRightConfigServer = RightConfigServer.getInstance();
        }
        return s_oRightConfigServer;
    }

    public static boolean isManagerOfUser(User user, User user2) throws WCMException {
        if (user.isAdministrator() || user.getName().equalsIgnoreCase(user2.getCrUserName())) {
            return true;
        }
        User user3 = user2.getCrUser();
        if (user3 == null) {
            return false;
        }
        if (user3.isAdministrator()) {
            return false;
        }
        String string = "select GroupId from WCMGrpUser where UserId=? and IsAdministrator=1 and GroupId in(select GroupId from WCMGrpUser where UserId=? and IsAdministrator=1)";
        int[] nArray = new int[]{user.getId(), user3.getId()};
        int n = DBManager.getDBManager().sqlExecuteIntQuery(string, nArray);
        return n > 0;
    }

    public static boolean hasMgrDocSourceRight(User user) throws WCMException {
        WebSites webSites = WebSites.openWCMObjs(user, null);
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || !(bl = AuthServer.hasRight(user, (CMSObj)webSite, 1))) continue;
            return true;
        }
        return false;
    }

    static {
        roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
    }
}

