/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.FileMsgProcessor;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.Member;
import com.trs.infra.support.config.ConfigServer;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class TRSClusterExtensionImpl
implements Extension {
    private static Logger logger = Logger.getLogger(TRSClusterExtensionImpl.class);
    private String m_sExtensionId = null;
    private IClusterMsgCenter m_oWCMClusterMsgCenter = null;
    private int m_nRetryTimes = 5;
    private int m_nRetryInterval = 0;

    public TRSClusterExtensionImpl(String string) {
        this.m_sExtensionId = string;
    }

    public Object callByCluster(Object object, Member member) {
        return this.callByClusterWithRetry(object, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callByClusterWithRetry(Object object, Member member) {
        if (this.m_oWCMClusterMsgCenter == null) {
            this.m_oWCMClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            ConfigServer configServer = ConfigServer.getServer();
            try {
                this.m_nRetryTimes = Integer.parseInt(configServer.getSysConfigValue("cluster.retrytimes", "5"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_nRetryInterval = Integer.parseInt(configServer.getSysConfigValue("cluster.retryinterval", "300"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.m_oWCMClusterMsgCenter.isStarted()) {
            return null;
        }
        ContextHelper.initContext(User.getSystem());
        boolean bl = false;
        boolean bl2 = this.m_nRetryInterval > 0;
        try {
            for (int i = 1; i <= this.m_nRetryTimes && !bl; ++i) {
                bl = this.callByCluster0(object, member, i);
                if (!bl2 || bl) continue;
                try {
                    Thread.sleep(this.m_nRetryInterval);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            ContextHelper.clear();
        }
        return null;
    }

    private boolean callByCluster0(Object object, Member member, int n) {
        try {
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                if (nArray.length < 3) {
                    logger.error((Object)("The message that the cluster[" + member + "] sended" + " is valid!" + "The length of int array is small!" + "Need: 3,actal: " + nArray.length + "."));
                    return true;
                }
                this.m_oWCMClusterMsgCenter.receive(nArray[0], nArray[1], nArray[2]);
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                if (stringArray.length < 2) {
                    logger.error((Object)("The message that the cluster[" + member + "] sended" + " is valid!" + "The length of int array is small!" + "Need: 2,actal: " + stringArray.length + "."));
                    return true;
                }
                String string = stringArray[0];
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                this.m_oWCMClusterMsgCenter.receive(string, stringArray2);
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length < 4) {
                    if (objectArray.length == 3 && "FILE.UPD".equals(objectArray[0])) {
                        FileMsgProcessor.receive(objectArray);
                        return true;
                    }
                    logger.error((Object)("The message that the cluster[" + member + "] sended" + " is valid!" + "The length of int array is small!" + "Need: 4,actal: " + objectArray.length + "."));
                    return true;
                }
                int n2 = (Integer)objectArray[0];
                int n3 = (Integer)objectArray[1];
                int n4 = (Integer)objectArray[2];
                Hashtable hashtable = (Hashtable)objectArray[3];
                this.m_oWCMClusterMsgCenter.receive(n2, n3, n4, hashtable);
            } else {
                logger.error((Object)("The message that the cluster[" + member + "] sended" + " is valid!" + "Unkown the type of message!"));
            }
            return true;
        }
        catch (Exception exception) {
            if (n == this.m_nRetryTimes) {
                logger.error((Object)("Failed to process the msg from " + member), (Throwable)exception);
            } else if (logger.isDebugEnabled()) {
                logger.error((Object)(n + " try process the msg from " + member), (Throwable)exception);
            }
            return false;
        }
    }

    public String getExtensionId() {
        return this.m_sExtensionId;
    }
}

