/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class FileMsgProcessor {
    private static Logger logger = Logger.getLogger(FileMsgProcessor.class);
    private static TRSWCMClusterServer m_oClusterServer = null;
    private static boolean m_bClsutered = false;
    private static boolean m_bInited = false;
    private static String m_sLocalWcmPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String string) {
        Object object;
        FileMsgProcessor.initIfNeed();
        if (!m_bClsutered) {
            return;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = "FILE.UPD";
        objectArray[1] = FileMsgProcessor.resolveFileName(string, true);
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            object = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            int n = 0;
            while ((n = fileInputStream.read((byte[])object)) > 0) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            byteArrayOutputStream.flush();
            objectArray[2] = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to read file. No message sended.", (Throwable)exception);
            return;
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (logger.isDebugEnabled()) {
            object = new StringBuffer(128);
            ((StringBuffer)object).append("Cluster Msg Send: MsgType=");
            ((StringBuffer)object).append(objectArray[0]);
            ((StringBuffer)object).append(", FileName=");
            ((StringBuffer)object).append(objectArray[1]);
            logger.debug((Object)((StringBuffer)object).toString(), (Throwable)new Exception("For call stack inspect."));
        }
        m_oClusterServer.sendMsg((Serializable)objectArray, true);
    }

    private static String resolveFileName(String string, boolean bl) {
        String string2 = null;
        string2 = bl ? string.substring(m_sLocalWcmPath.length()) : m_sLocalWcmPath + string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Message about file: " + string2));
        }
        logger.fatal((Object)("Message about file: " + string2));
        return string2;
    }

    private static boolean initIfNeed() {
        if (m_bInited) {
            return m_bClsutered;
        }
        m_oClusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        m_bInited = true;
        if (m_oClusterServer == null || m_oClusterServer.getContext() == null) {
            m_bClsutered = false;
            return false;
        }
        m_bClsutered = m_oClusterServer.getContext().getConfig().isEnabled();
        m_sLocalWcmPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        logger.fatal((Object)m_sLocalWcmPath);
        m_sLocalWcmPath = CMyString.setStrEndWith(m_sLocalWcmPath, File.separatorChar);
        logger.fatal((Object)m_sLocalWcmPath);
        return m_bClsutered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void receive(Object[] objectArray) {
        Comparable<StringBuffer> comparable;
        FileMsgProcessor.initIfNeed();
        String string = FileMsgProcessor.resolveFileName((String)objectArray[1], false);
        byte[] byArray = (byte[])objectArray[2];
        if (logger.isDebugEnabled()) {
            comparable = new StringBuffer(128);
            ((StringBuffer)comparable).append("Cluster Msg Received: MsgType=");
            ((StringBuffer)comparable).append(objectArray[0]);
            ((StringBuffer)comparable).append(", FileName=");
            ((StringBuffer)comparable).append(string);
            if (byArray.length > 0) {
                ((StringBuffer)comparable).append(", Content(ISO8859)=");
                try {
                    ((StringBuffer)comparable).append(new String(byArray, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                ((StringBuffer)comparable).append("Content=Empty");
            }
            logger.debug((Object)((StringBuffer)comparable).toString());
        }
        if (((File)(comparable = new File(string))).isDirectory()) {
            logger.error((Object)(string + " is a directory."));
        } else {
            String string2 = string + "." + CMyDateTime.now().toString("yyyyMMddHHmmss");
            FileOutputStream fileOutputStream = null;
            File file = new File(string2);
            boolean bl = false;
            Exception exception = null;
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                if (((File)comparable).exists()) {
                    ((File)comparable).delete();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cluster add new file: " + string));
                }
                bl = file.renameTo((File)comparable);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception3) {}
                }
            }
            if (!bl) {
                logger.error((Object)("Failed to process file: " + string), (Throwable)exception);
            }
        }
    }
}

