/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class ChannelToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ChannelToXML.class);
    private static final int PARENT_ID = 1;
    private static final int CHNL_TYPE = 2;
    private static final int CHNL_PROP = 3;
    private static final int SITE_ID = 4;
    private static int[] RIGHTS_FORBID_TOPPIC = new int[]{11, 19, 15, 16, 17, 53};

    protected String[][] getSpecialProperty(MethodContext methodContext, BaseObj baseObj, int n, Object object) throws ConvertException {
        Channel channel = (Channel)baseObj;
        switch (n) {
            case 1: {
                return this.makeChannelHostInfo(object, channel, methodContext.getValue("NeedChannelPath", false));
            }
            case 2: {
                return this.makeChannelTypeInfo(object, channel);
            }
            case 3: {
                return this.makeChannelProInfo(channel);
            }
            case 4: {
                return this.makeChannelSiteInfo(object, channel);
            }
        }
        return null;
    }

    private String[][] makeChannelHostInfo(Object object, Channel channel, boolean bl) throws ConvertException {
        try {
            BaseChannel baseChannel = channel.getHost();
            if (baseChannel == null) {
                throw new ConvertException(channel + CMyString.format(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label1", "{0}\u7684\u7236\u7ed3\u70b9[Id={1}]\u4e0d\u5b58\u5728\uff01"), new String[]{channel.toString(), object.toString()}));
            }
            return new String[][]{{"Id", baseChannel.isSite() ? "0" : String.valueOf(baseChannel.getId())}, {"Type", baseChannel.isSite() ? "Site" : "Channel"}, {"Name", baseChannel.getDispDesc()}, {"Path", bl ? "" : this.getAdaptedPath(baseChannel)}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label3", "\u6784\u9020\u680f\u76ee\u7684\u7236\u7ed3\u70b9\u4fe1\u606f\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff01"), wCMException);
        }
    }

    private String getAdaptedPath(BaseChannel baseChannel) {
        String string = baseChannel.getInfo();
        try {
            if (baseChannel != null && baseChannel instanceof Channel) {
                Channel channel = (Channel)baseChannel;
                StringBuffer stringBuffer = new StringBuffer(channel.getDesc() + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label4", "[\u680f\u76ee-") + channel.getId() + "]");
                for (Channel channel2 = channel.getParent(); channel2 != null && channel2 != null; channel2 = channel2.getParent()) {
                    stringBuffer.insert(0, " > ");
                    stringBuffer.insert(0, channel2.getDesc() + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label4", "[\u680f\u76ee-") + channel2.getId() + "]");
                }
                string = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
        }
        catch (WCMException wCMException) {
            logger.warn((Object)"failed to get the path of channel!", (Throwable)wCMException);
        }
        return string;
    }

    private String[][] makeChannelSiteInfo(Object object, Channel channel) throws ConvertException {
        try {
            User user = ContextHelper.getLoginUser();
            WebSite webSite = channel.getSite();
            if (webSite == null) {
                throw new ConvertException(channel + CMyString.format(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label5", "{0}\u7684\u7ad9\u70b9[Id={1}]\u4e0d\u5b58\u5728\uff01"), new String[]{channel.toString(), object.toString()}));
            }
            RightValue rightValue = null;
            rightValue = user.isAdministrator() ? RightValue.getAdministratorRightValue() : AuthServer.getRightValue((CMSObj)webSite, ContextHelper.getLoginUser());
            return new String[][]{{"Id", object.toString()}, {"Name", webSite.getDispDesc()}, {"SiteType", String.valueOf(webSite.getPropertyAsInt("SiteType", 0))}, {"Right", rightValue.toString()}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label6", "\u6784\u9020\u680f\u76ee\u7684\u6240\u5c5e\u7ad9\u70b9\u4fe1\u606f\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff01"), wCMException);
        }
    }

    private String[][] makeChannelTypeInfo(Object object, Channel channel) {
        return new String[][]{{"Id", object.toString()}, {"Name", channel.getTypeDesc()}};
    }

    private String[][] makeChannelProInfo(Channel channel) {
        return new String[][]{{"OnlyManager", String.valueOf(channel.isOnlyManager())}, {"OnlySearch", String.valueOf(channel.isOnlySearch())}, {"CanPub", String.valueOf(channel.isCanPub())}, {"DoDeptFilter", String.valueOf(channel.isDoDeptFilter())}};
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObjs baseObjs) {
        return null;
    }

    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("ParentId", 1, "Parent");
        this.registerHostSpecialProperty("ChnlType", 2);
        this.registerHostSpecialProperty("ChnlProp", 3);
        this.registerHostSpecialProperty("SiteId", 4, "Site");
    }

    public String[] registerTargetClassName() {
        return new String[]{Channel.class.getName(), Channels.class.getName()};
    }

    protected String[][] getSpecialRootAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        Channel channel = (Channel)baseObj;
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)channel, 13))}};
        }
        catch (WCMException wCMException) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label7", "\u6784\u9020\u680f\u76ee\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), wCMException);
        }
    }

    protected String[][] getSpecialElementAttributes(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        Channel channel = (Channel)baseObj;
        String[] stringArray = null;
        try {
            stringArray = new String[]{"HasChildren", channel.getChildrenSize(null) > 0 ? "true" : "false"};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String[] stringArray2 = new String[]{"IsVirtual", String.valueOf(channel.isVirtual())};
        if (methodContext.getValue("ContainsRight", false)) {
            try {
                User user = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                rightValue = user.isAdministrator() || user.getName().equalsIgnoreCase(channel.getCrUserName()) ? new RightValue(RightValue.VALUE_ADMINISTRATOR) : AuthServer.getRightValue((CMSObj)channel, ContextHelper.getLoginUser());
                ChannelToXML.doFilterRight(rightValue, channel);
                return new String[][]{{"Right", rightValue.toString()}, stringArray, stringArray2};
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label8", "\u6784\u9020[") + channel + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label9", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        return new String[][]{stringArray, stringArray2};
    }

    public static void doFilterRight(RightValue rightValue, Channel channel) {
        if (channel.getType() == 2 || channel.getType() == 1 || channel.getType() == 11) {
            for (int i = 0; i < RIGHTS_FORBID_TOPPIC.length; ++i) {
                rightValue.setHasRight(RIGHTS_FORBID_TOPPIC[i], false);
            }
        }
        if (channel.getType() == 13) {
            rightValue.setHasRight(11, false);
        }
    }
}

