/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseWCMObjectToXML
implements IXMLConvertor {
    private String m_sPrefix = this.getClass().getName() + ".";
    private NamesRegister m_oSpecialPropertiesRegister = new NamesRegister();
    private HashMap m_hmNewTagNames = new HashMap(1);
    protected boolean m_bToXMLDependsOnSelectFields = true;

    public String toXmlString(MethodContext methodContext, Object object) throws ConvertException {
        if (object instanceof BaseObjs) {
            return this.toXMLString(methodContext, (BaseObjs)object);
        }
        if (object instanceof BaseObj) {
            return this.toXMLString(methodContext, (BaseObj)object);
        }
        throw new ConvertException(I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label1", "\u7c7b\u578b[") + object.getClass().getName() + I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label2", "]\u4e0d\u5339\u914d\uff01"));
    }

    private String toXMLString(MethodContext methodContext, BaseObjs baseObjs) throws ConvertException {
        if (methodContext != null && methodContext.getValue("OnlyReturnIds", false)) {
            String string;
            int n = methodContext.getValue("IdsValueType", 0);
            switch (n) {
                case 0: {
                    string = baseObjs.getIdListAsString(',');
                    methodContext.setReturnHTML(true);
                    break;
                }
                case 1: {
                    string = "{Ids:\"" + baseObjs.getIdListAsString(',') + "\"}";
                    methodContext.setReturnJSON(true);
                    break;
                }
                default: {
                    string = "<Ids>" + baseObjs.getIdListAsString(',') + "</Ids>";
                }
            }
            return string;
        }
        String string = this.makeTagName(baseObjs.getClass());
        String string2 = this.makeTagName(baseObjs.getElementClass());
        int n = -1;
        int n2 = 1;
        if (methodContext != null) {
            n = methodContext.getPageSize();
            n2 = methodContext.getPageIndex();
        }
        CPager cPager = new CPager(n);
        cPager.setCurrentPageIndex(n2);
        cPager.setItemCount(baseObjs.size());
        Element element = DocumentHelper.createElement((String)string);
        this.setPageAttributes(cPager, element);
        this.setRootAttributes(methodContext, baseObjs, element);
        String[] stringArray = this.makeSelectFields(methodContext);
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equalsIgnoreCase(baseObjs.getIdFieldName())) {
            String string3 = baseObjs.getIdFieldName();
            for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
                Element element2 = element.addElement(string2);
                element2.addElement(string3).addText(String.valueOf(baseObjs.getIdAt(i - 1)));
            }
        } else {
            boolean bl = methodContext != null && methodContext.getValue("_loadtext_", false);
            for (int i = cPager.getFirstItemIndex(); i <= cPager.getLastItemIndex(); ++i) {
                BaseObj baseObj = baseObjs.getAt(i - 1);
                if (baseObj == null) continue;
                Element element3 = this.makeElementFromBaseObj(methodContext, string2, baseObj, bl, stringArray);
                element.add(element3);
            }
        }
        return element.asXML();
    }

    private String[] makeSelectFields(MethodContext methodContext) {
        if (methodContext == null) {
            return null;
        }
        String[] stringArray = null;
        String string = methodContext.getValue("SelectFields");
        if (string != null && string.length() > 0 && !string.equals("*")) {
            stringArray = CMyString.split(string, ",");
        }
        return stringArray;
    }

    private void setRootAttributes(MethodContext methodContext, BaseObjs baseObjs, Element element) throws ConvertException {
        String[][] stringArray = this.getSpecialRootAttributes(methodContext, baseObjs);
        this.setElementAttributes(element, stringArray);
    }

    private void setElementAttributes(Element element, String[][] stringArray) throws ConvertException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].length < 2) {
                throw new ConvertException(I18NMessage.get(BaseWCMObjectToXML.class, "BaseWCMObjectToXML.label3", "getSpecialRootAttributes\u7684\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u89c4\u8303\uff01"));
            }
            element.addAttribute(stringArray[i][0], stringArray[i][1]);
        }
    }

    protected abstract String[][] getSpecialElementAttributes(MethodContext var1, BaseObj var2) throws ConvertException;

    protected abstract String[][] getSpecialRootAttributes(MethodContext var1, BaseObjs var2) throws ConvertException;

    protected abstract String[][] getSpecialRootAttributes(MethodContext var1, BaseObj var2) throws ConvertException;

    private String toXMLString(MethodContext methodContext, BaseObj baseObj) throws ConvertException {
        String[] stringArray = this.makeSelectFields(methodContext);
        String string = this.makeTagName(baseObj.getClass());
        Element element = this.makeElementFromBaseObj(methodContext, string, baseObj, true, stringArray);
        String[][] stringArray2 = this.getSpecialRootAttributes(methodContext, baseObj);
        this.setElementAttributes(element, stringArray2);
        return element.asXML();
    }

    private void setPageAttributes(CPager cPager, Element element) {
        element.addAttribute("Num", String.valueOf(cPager.getItemCount()));
        if (cPager.getPageSize() <= 0) {
            return;
        }
        element.addAttribute("PageSize", String.valueOf(cPager.getPageSize()));
        element.addAttribute("PageCount", String.valueOf(cPager.getPageCount()));
        element.addAttribute("CurrPageIndex", String.valueOf(cPager.getCurrentPageIndex()));
    }

    protected boolean isToHTML(MethodContext methodContext, String string) {
        if (methodContext == null) {
            return false;
        }
        String string2 = methodContext.getValue("FieldsToHTML");
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return ("," + string2 + ",").toUpperCase().indexOf("," + string.toUpperCase() + ",") >= 0;
    }

    protected Element makeElementFromBaseObj(MethodContext methodContext, String string, BaseObj baseObj, boolean bl, String[] stringArray) throws ConvertException {
        Hashtable[] hashtableArray = this.getPropertiesArray(baseObj, bl);
        Element element = DocumentHelper.createElement((String)string);
        for (Hashtable hashtable : hashtableArray) {
            if (hashtable == null) continue;
            Object[] objectArray = null;
            objectArray = this.m_bToXMLDependsOnSelectFields && stringArray != null && stringArray.length > 0 ? stringArray : hashtable.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String[][] stringArray2;
                Object object;
                String string2 = ((String)objectArray[i]).toUpperCase();
                Element element2 = element.addElement(string2);
                Object v = hashtable.get(string2);
                if (string2.equals("ATTRIBUTE") && v != null) {
                    object = new AttributesString(v.toString());
                    List list = ((AttributesString)object).getNameList();
                    int n = list.size();
                    for (int j = 0; j < n; ++j) {
                        String string3 = (String)list.get(j);
                        element2.addAttribute(string3, ((AttributesString)object).getAttributeValue(string3));
                    }
                    continue;
                }
                object = null;
                int n = this.lookupHostSpecialPropertyId(string2);
                if (n > 0 && (stringArray2 = this.getSpecialProperty(methodContext, baseObj, n, v)) != null) {
                    int n2;
                    String string4 = (String)this.m_hmNewTagNames.get(string2);
                    if (string4 != null) {
                        element2.setName(string4);
                    }
                    if (stringArray2.length == 1 && stringArray2[0].length == 1) {
                        object = stringArray2[0][0];
                    } else if (stringArray2.length == 1 && stringArray2[0].length == 2) {
                        n2 = this.isToHTML(methodContext, (string4 != null ? string4 : string2) + "." + stringArray2[0][0]) ? 1 : 0;
                        element2.addAttribute(stringArray2[0][0], n2 != 0 ? CMyString.transDisplay(stringArray2[0][1], false) : stringArray2[0][1]);
                    } else {
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            boolean bl2 = this.isToHTML(methodContext, (string4 != null ? string4 : string2) + "." + stringArray2[n2][0]);
                            element2.addAttribute(stringArray2[n2][0], bl2 ? CMyString.transDisplay(stringArray2[n2][1], false) : stringArray2[n2][1]);
                        }
                        continue;
                    }
                }
                if (this.isCData(v)) {
                    if (object == null) {
                        object = v == null || v instanceof NullValue ? "" : v.toString();
                    }
                    if (object == null || ((String)object).length() <= 0) continue;
                    if (this.isToHTML(methodContext, string2)) {
                        object = CMyString.transDisplay((String)object, false);
                    }
                    if (((String)object).matches("(?ism).*<!\\[CDATA\\[.*|.*\\]\\]>.*")) {
                        element2.setText((String)object);
                        continue;
                    }
                    element2.addCDATA((String)object);
                    continue;
                }
                if (object != null) {
                    element2.setText((String)object);
                    continue;
                }
                if (v instanceof CMyDateTime) {
                    CMyDateTime cMyDateTime = (CMyDateTime)v;
                    if (cMyDateTime.isNull()) continue;
                    element2.setText(this.convertDateTimeValueToString(methodContext, cMyDateTime));
                    continue;
                }
                if (object == null) {
                    object = v == null || v instanceof NullValue ? "" : v.toString();
                }
                if (object == null || ((String)object).length() <= 0) continue;
                element2.setText((String)object);
            }
            this.setElementAttributes(element, this.getSpecialElementAttributes(methodContext, baseObj));
        }
        return element;
    }

    protected Hashtable[] getPropertiesArray(BaseObj baseObj, boolean bl) {
        Hashtable hashtable = bl ? baseObj.getAllProperty() : baseObj.getProperties();
        return new Hashtable[]{hashtable};
    }

    protected String convertDateTimeValueToString(MethodContext methodContext, CMyDateTime cMyDateTime) {
        String string = "yyyy-MM-dd HH:mm:ss";
        if (methodContext != null && (string = methodContext.getValue("DateTimeFormat")) == null) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        String string2 = cMyDateTime.toString(string);
        return string2;
    }

    private boolean isCData(Object object) {
        if (object instanceof CDBText) {
            return true;
        }
        return object instanceof String && ((String)object).length() > 0;
    }

    private String makeTagName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    protected abstract void registerHostSpecialProperties();

    protected abstract String[][] getSpecialProperty(MethodContext var1, BaseObj var2, int var3, Object var4) throws ConvertException;

    protected void registerHostSpecialProperty(String string, int n) {
        this.registerHostSpecialProperty(string, n, null);
    }

    protected void registerHostSpecialProperty(String string, int n, String string2) {
        this.m_oSpecialPropertiesRegister.register(this.m_sPrefix + string.toUpperCase(), n);
        if (string2 != null) {
            this.m_hmNewTagNames.put(string.toUpperCase(), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String string) {
        if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
            NamesRegister namesRegister = this.m_oSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!this.m_oSpecialPropertiesRegister.contains(this.m_sPrefix)) {
                    this.registerHostSpecialProperties();
                    this.m_oSpecialPropertiesRegister.register(this.m_sPrefix, 0);
                }
            }
        }
        return this.m_oSpecialPropertiesRegister.lookup(this.m_sPrefix + string.toUpperCase(), -1);
    }
}

