/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.MyPlugin;
import com.trs.components.wcm.channel.IVChannelParser;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.channel.VChannelManager;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.intelligence.IIntellMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WebSiteServiceProvider
implements IGlueServiceProvider {
    private ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WebSites webSites = WebSites.findByIds(user, methodContext.getObjectIds());
        boolean bl = methodContext.getValue("Drop", false);
        int n = 2;
        if (!AuthServer.hasRightInObjects(user, webSites, n)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd9\u4e9b\u680f\u76ee[ID=") + webSites.getIdListAsString() + "].");
        }
        int n2 = webSites.size();
        for (int i = 0; i < n2; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            this.m_oChannelMgr.delete(webSite, bl);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        Cloneable cloneable;
        User user = this.getLoginUser();
        int n = methodContext.getValue("SiteType", 0);
        int n2 = methodContext.getValue("SiblingSiteId", 0);
        if (n2 > 0) {
            cloneable = this.findSiteById(n2);
            n = cloneable.getPropertyAsInt("SiteType", 0);
        }
        this.validatePluginRight(n);
        cloneable = methodContext.getExtraWCMFilter();
        boolean bl = methodContext.getValue("forIndividual", true);
        HttpServletRequest httpServletRequest = methodContext.getServiceContext().getRequest();
        Hashtable hashtable = httpServletRequest != null ? (Hashtable)httpServletRequest.getSession().getAttribute("customSite") : new Hashtable();
        return WebSiteHelper.getWebSitesByTypeWithIndividual(user, n, (WCMFilter)cloneable, hashtable, bl);
    }

    private void validatePluginRight(int n) throws Exception {
        switch (n) {
            case 1: {
                if (PluginConfig.isStartPhoto()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 2: {
                if (PluginConfig.isStartVideo()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 4: {
                CMyBitsValue cMyBitsValue = new CMyBitsValue(MyPlugin.getPluginCode());
                if (cMyBitsValue.getBit(2)) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label3", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u5143\u6570\u636e\u7ba1\u7406\u9009\u4ef6\uff01"));
            }
        }
    }

    public int save(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WebSite webSite = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            webSite = new WebSite();
            if (!user.isAdministrator()) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label4", "\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
            }
        } else {
            webSite = WebSite.findById(n);
            if (webSite == null) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label5", "\u6307\u5b9a\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
            }
            int n2 = 1;
            if (!AuthServer.hasRight(user, (CMSObj)webSite, n2)) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label6", "\u60a8\u6ca1\u6709\u4fee\u6539\u7ad9\u70b9![") + webSite + "]");
            }
            webSite.validCanEditAndLock(user);
        }
        String[] stringArray = new String[]{"ObjectId"};
        webSite = (WebSite)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, webSite, stringArray);
        this.validatePluginRight(webSite.getType());
        this.m_oChannelMgr.save(webSite);
        return webSite.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        if (methodContext.getObjectId() == 0) {
            WebSite webSite = new WebSite();
            return webSite;
        }
        WebSite webSite = WebSite.findById(methodContext.getObjectId());
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(methodContext.getObjectId()), WCMTypes.getLowerObjName(103)}));
        }
        int n = 64;
        if (!AuthServer.hasRight(user, (CMSObj)webSite, n)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label21", "\u60a8[") + user.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label32", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7ad9\u70b9[Id=") + webSite.getId() + "]!");
        }
        return webSite;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return WebSites.findByIds(this.getLoginUser(), methodContext.getObjectIds());
    }

    public PageOperators getOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            WebSite webSite = this.findSiteById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "website", webSite);
        }
        String string = methodContext.getObjectIds();
        if (string != null && string.length() > 0) {
            WebSites webSites = WebSites.findByIds(user, string);
            if (webSites.isEmpty()) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label7", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ObjectIds=") + string + "].");
            }
            if (webSites.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "website", (CMSObj)webSites.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(user, "websites", webSites);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getDocumentOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            WebSite webSite = this.findSiteById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "documentInWebsite", webSite);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInSite(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            WebSite webSite = this.findSiteById(n);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "WebSiteHost", webSite);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInSiteRoot() throws Throwable {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            return new PageOperators(null);
        }
        return PageOperatorsForServiceHelper.makeCMSObjOpertators(user, "WebSiteRoot", null);
    }

    public String findSiteTypeDesc(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string = null;
        string = user.isAdministrator() ? RightValue.getAdministratorValues() : "0";
        hashMap.put("right", string);
        hashMap.put("desc", WebSiteServiceProvider.findSiteTypeDesc(methodContext.getObjectId()));
        methodContext.setReturnJSON(true);
        return "{\nWEBSITEROOT:" + JSONHelper.toSimpleJSON(hashMap, 1) + "\n}";
    }

    public static String findSiteTypeDesc(int n) throws Throwable {
        switch (n) {
            case 0: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label9", "\u6587\u5b57\u5e93");
            }
            case 1: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label10", "\u56fe\u7247\u5e93");
            }
            case 2: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label11", "\u89c6\u9891\u5e93");
            }
            case 4: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label12", "\u8d44\u6e90\u5e93");
            }
        }
        return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label9", "\u6587\u5b57\u5e93");
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        WebSites webSites = WebSites.findByIds(user, methodContext.getObjectIds());
        boolean bl = methodContext.getValue("ContainsChildren", true);
        boolean bl2 = methodContext.getValue("ContainsRelated", true);
        this.removeNoRightSite(user, webSites, 1);
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        methodContext.setContentTypeIsHTML();
        return channelExporter.export(webSites, bl, bl2);
    }

    public String importSites(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ImportFile");
        WCMAJAXServiceHelper.validateFile(string);
        String string2 = methodContext.getValue("ImportXSLFile");
        WCMAJAXServiceHelper.validateFile(string2);
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label14", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u5165\u7ad9\u70b9\uff01"));
        }
        ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        try {
            return channelImporter.importFromFile(string, string2, null).toJSONXML();
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label15", "\u5bfc\u5165\u7ad9\u70b9\u5931\u8d25!"), wCMException);
        }
    }

    public String createFrom(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcSiteId", 0);
        boolean bl = methodContext.getValue("ContainsRelated", true);
        WebSite webSite = this.findSiteById(n);
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label16", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        ChannelExporter channelExporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        ChannelImporter channelImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        Reports reports = new Reports("");
        try {
            String string = channelExporter.export(webSite, true, bl);
            reports = channelImporter.importFromFile(string, null, null);
            reports.setTitle(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label17", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"));
            int[] nArray = reports.getResultIds();
            Report report = null;
            List list = reports.getSucessedReporter();
            if (!list.isEmpty()) {
                report = (Report)list.get(0);
                report.setRportTitle(CMyString.format(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label18", "\u6210\u529f\u521b\u5efa\u7ad9\u70b9[{0}]!"), new Object[]{WebSite.findById(nArray[0])}));
            } else {
                report = reports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label19", "\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"));
            }
            return reports.toJSONXML();
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label20", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee\u5931\u8d25!"), wCMException);
        }
    }

    public int autoCreate(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("SiteKind");
        String string2 = methodContext.getValue("SiteStyle");
        String string3 = methodContext.getValue("SiteName");
        String string4 = methodContext.getValue("SiteDesc");
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label21", "\u60a8[") + user.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label22", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        IIntellMgr iIntellMgr = (IIntellMgr)DreamFactory.createObjectById("IIntellMgr");
        Reports reports = iIntellMgr.createNewSiteFrom(string, string2, string3, string4);
        int[] nArray = reports.getResultIds();
        if (nArray == null || nArray.length == 0) {
            throw new Error(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label23", "\u65b0\u5efa\u7ad9\u70b9\u8d85\u51fa\u5f53\u524d\u6ce8\u518c\u7801\u9650\u5236\uff0c\u5982\u9700\u589e\u52a0\uff0c\u8bf7\u4e0eTRS\u516c\u53f8\u8054\u7cfb\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01"));
        }
        return nArray[0];
    }

    public void changeOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SrcSiteId", 0);
        WebSite webSite = this.findSiteById(n);
        int n2 = methodContext.getValue("DstSiteId", 0);
        WebSite webSite2 = null;
        if (n2 > 0) {
            webSite2 = this.findSiteById(n2);
        }
        if (!AuthServer.hasRight(user, (CMSObj)webSite, 1)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label24", "]\u6ca1\u6709\u6743\u9650\u6539\u53d8\u680f\u76ee[") + webSite.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label25", "]\u7684\u987a\u5e8f\uff01"));
        }
        if (!webSite.canEdit(user)) {
            throw new WCMException(webSite + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label26", "\u5df2\u7ecf\u88ab[") + webSite.getLockerUserName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label27", "]\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u505a\u4efb\u4f55\u79fb\u52a8\u64cd\u4f5c\uff01"));
        }
        int n3 = webSite2 == null ? -1 : webSite2.getOrder();
        webSite.setOrder(n3);
        this.m_oChannelMgr.save(webSite);
    }

    public WebSites getRecycleSites(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        if (wCMFilter == null) {
            wCMFilter = new WCMFilter();
        }
        if ((n = methodContext.getValue("SiteType", -1)) >= 0) {
            wCMFilter.mergeWith(new WCMFilter(null, "SiteType=" + n, null));
        }
        WebSites webSites = this.m_oChannelMgr.getRecycleSites(wCMFilter);
        if (user.isAdministrator()) {
            return webSites;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite != null && AuthServer.hasRight(user, (CMSObj)webSite, 2)) continue;
            webSites.removeAt(i, false);
        }
        return webSites;
    }

    public void restoreSites(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("RestoreAll", false);
        WebSites webSites = null;
        if (bl) {
            WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
            webSites = this.m_oChannelMgr.getRecycleSites(wCMFilter);
        } else {
            webSites = WebSites.findByIds(user, methodContext.getObjectIds());
        }
        if (webSites.size() == 0) {
            throw new WCMException(200006, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label29", "\u7ad9\u70b9\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u8fd8\u539f\u7684\u7ad9\u70b9\uff01"));
        }
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || !AuthServer.hasRight(user, (CMSObj)webSite, 2)) continue;
            this.m_oChannelMgr.restore(webSite);
        }
    }

    public void clearRecycle() throws Throwable {
        User user = this.getLoginUser();
        WebSites webSites = this.m_oChannelMgr.getRecycleSites(null);
        if (webSites.size() == 0) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label30", "\u7ad9\u70b9\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u5220\u9664\u7684\u7ad9\u70b9\uff01"));
        }
        int n = webSites.size();
        for (int i = 0; i < n; ++i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || !AuthServer.hasRight(user, (CMSObj)webSite, 2)) continue;
            this.m_oChannelMgr.delete(webSite, true);
        }
    }

    public boolean existsSimilarName(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("WCMWEBSITE", "SiteName=? and SiteId<>?", "", "SiteId");
        wCMFilter.addSearchValues(0, methodContext.getValue("SiteName"));
        wCMFilter.addSearchValues(1, methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    public Object existsSimilarDataPath(MethodContext methodContext) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("WCMWEBSITE", "SiteId<>?and exists(select FolderId from WCMFolderPublishConfig where FolderType=103 and FolderId=WCMWebSite.SiteId and DataPath=?)", "", "SiteId");
        wCMFilter.addSearchValues(methodContext.getObjectId());
        wCMFilter.addSearchValues(methodContext.getValue("DataPath"));
        int n = DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter);
        if (n > 0) {
            WebSite webSite = WebSite.findById(n);
            if (webSite == null) {
                return "";
            }
            return webSite.getDesc() + "-" + webSite.getId();
        }
        return "";
    }

    private WebSite findSiteById(int n) throws WCMException {
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(103)}));
        }
        return webSite;
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }

    private void removeNoRightSite(User user, WebSites webSites, int n) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || AuthServer.hasRight(user, (CMSObj)webSite, n)) continue;
            webSites.removeAt(i, false);
        }
    }

    public void createFromFile(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        if (!user.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label4", "\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        int n = methodContext.getValue("SiteType", 0);
        this.validatePluginRight(n);
        String string = methodContext.getValue("ImportFile");
        string = FilesMan.getFilesMan().mapFilePath(string, 0) + string;
        WCMSystemObject wCMSystemObject = new WCMSystemObject(n);
        IVChannelParser iVChannelParser = (IVChannelParser)DreamFactory.createObjectById("IVChannelParser");
        VChannel vChannel = iVChannelParser.parse(string);
        VChannelManager vChannelManager = (VChannelManager)DreamFactory.createObjectById("VChannelManager");
        StringBuffer stringBuffer = methodContext.getServiceContext().getRequest().getRequestURL();
        String string2 = methodContext.getServiceContext().getRequest().getRequestURI();
        stringBuffer.replace(stringBuffer.indexOf(string2), stringBuffer.length(), "");
        ContextParameters.set1(stringBuffer.toString());
        vChannelManager.save(wCMSystemObject, vChannel);
        ContextParameters.get1();
    }

    public WebSites getSitesForCurrUser(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("RightIndex", 7);
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        WCMFilter wCMFilter2 = new WCMFilter("", "Status>=0", "");
        wCMFilter2.mergeWith(wCMFilter);
        boolean bl = methodContext.getValue("forIndividual", false);
        Hashtable hashtable = (Hashtable)methodContext.getServiceContext().getRequest().getSession().getAttribute("customSite");
        return WebSiteHelper.getWebSitesByRightIndex(user, n, wCMFilter2, hashtable, bl);
    }
}

