/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class WebSiteHelper {
    private static Logger logger = Logger.getLogger(WebSiteHelper.class);

    public static WebSites getWebSitesByType(User user, int n, WCMFilter wCMFilter) throws WCMException {
        String string = "Status>=0 and SiteType=?";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.addSearchValues(0, n);
        wCMFilter2.mergeWith(wCMFilter);
        WebSites webSites = WebSites.openWCMObjs(user, wCMFilter2);
        if (user.isAdministrator()) {
            return webSites;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null || WebSiteHelper.isVisible(user, webSite)) continue;
            webSites.removeAt(i, false);
        }
        return webSites;
    }

    public static WebSites getWebSitesByTypeWithIndividual(User user, int n, WCMFilter wCMFilter, Hashtable hashtable, boolean bl) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        String string = "Status>=0 and SiteType=?";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.addSearchValues(0, n);
        wCMFilter2.mergeWith(wCMFilter);
        WebSites webSites = WebSites.openWCMObjs(user, wCMFilter2);
        if (user.isAdministrator() && !bl) {
            debugTimer.stop();
            logger.debug((Object)("get sites of [" + user + "] use [" + debugTimer.getTime() + "]ms!"));
            return webSites;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            if (!WebSiteHelper.isVisible(user, webSite)) {
                webSites.removeAt(i, false);
                continue;
            }
            if (!bl || hashtable == null || hashtable.size() <= 0 || hashtable.get(String.valueOf(webSite.getId())) != null) continue;
            webSites.removeAt(i, false);
        }
        debugTimer.stop();
        logger.debug((Object)("get sites of [" + user + "] use [" + debugTimer.getTime() + "]ms!"));
        return webSites;
    }

    public static boolean isVisible(User user, WebSite webSite) throws WCMException {
        return AuthServer.hasRight(user, (CMSObj)webSite, 64);
    }

    public static WebSites getWebSitesByRightIndex(User user, int n, WCMFilter wCMFilter, Hashtable hashtable, boolean bl) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        WebSites webSites = WebSites.openWCMObjs(user, wCMFilter);
        if (user.isAdministrator() && !bl) {
            debugTimer.stop();
            logger.debug((Object)("get sites of [" + user + "] use [" + debugTimer.getTime() + "]ms!"));
            return webSites;
        }
        for (int i = webSites.size() - 1; i >= 0; --i) {
            WebSite webSite = (WebSite)webSites.getAt(i);
            if (webSite == null) continue;
            if (!AuthServer.hasRight(user, (CMSObj)webSite, n)) {
                webSites.removeAt(i, false);
                continue;
            }
            if (!bl || hashtable == null || hashtable.size() <= 0 || hashtable.get(String.valueOf(webSite.getId())) != null) continue;
            webSites.removeAt(i, false);
        }
        debugTimer.stop();
        logger.debug((Object)("get sites of [" + user + "] use [" + debugTimer.getTime() + "]ms!"));
        return webSites;
    }
}

