/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.Watermark;
import com.trs.wcm.photo.Watermarks;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class WatermarkServiceProvider
implements IGlueServiceProvider {
    public void delete(MethodContext methodContext) throws Throwable {
        String string = methodContext.getObjectIds();
        if (CMyString.isEmpty(string)) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("LibId", 0);
        WebSite webSite = WebSite.findById(n);
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label1", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label2", "]\u7684\u56fe\u5e93!"));
        }
        if (webSite.isDeleted()) {
            throw new WCMException(200006, "[Id=" + n + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label3", "]\u7684\u56fe\u5e93\u5df2\u88ab\u5220\u9664!"));
        }
        if (!AuthServer.hasRight(user, (CMSObj)webSite, 32)) {
            throw new WCMException(1002, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label4", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u56fe\u5e93\u7684\u6c34\u5370!"));
        }
        WCMFilter wCMFilter = new WCMFilter("", "LibId=? AND WaterMarkId IN(" + string + ")", "");
        wCMFilter.addSearchValues(0, n);
        Watermarks watermarks = new Watermarks(user);
        watermarks.open(wCMFilter);
        watermarks.deleteAll(true);
    }

    public Object query(MethodContext methodContext) throws Throwable {
        int n;
        Object object;
        int n2 = methodContext.getValue("LibId", 0);
        if (n2 == 0 && (object = Channel.findById(n = methodContext.getValue("ChannelId", 0))) != null) {
            n2 = ((Channel)object).getSiteId();
        }
        WCMFilter wCMFilter = new WCMFilter("", "LibId=?", "");
        wCMFilter.addSearchValues(0, n2);
        object = methodContext.getValue("OrderBy");
        object = CMyString.isEmpty((String)object) ? "CrTime desc" : (String)object + ",WatermarkId desc";
        wCMFilter.setOrder((String)object);
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        Watermarks watermarks = new Watermarks(null);
        watermarks.open(wCMFilter);
        return watermarks;
    }

    public int save(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        User user = ContextHelper.getLoginUser();
        Watermark watermark = null;
        if (n > 0) {
            watermark = Watermark.findById(n);
            if (!watermark.canEdit(user)) {
                throw new WCMException(1012, watermark + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label5", "\u88ab[") + watermark.getLockerUserName() + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label6", "]\u9501\u5b9a,\u60a8\u6682\u65f6\u65e0\u6cd5\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u7f16\u8f91!"));
            }
        } else {
            watermark = new Watermark();
        }
        watermark.setWMName(methodContext.getValue("WMName"));
        if (methodContext.getValue("NOTQUICKEDIT", false)) {
            watermark.setLibId(methodContext.getValue("LibId", 0));
            watermark.setWMPicture(methodContext.getValue("WMPicture"));
        }
        watermark.save(user);
        return watermark.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("ObjectId");
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Watermark watermark = Watermark.findById(n);
        if (watermark == null) {
            throw new WCMException(200006, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label1", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label7", "]\u7684\u6c34\u5370\uff01"));
        }
        return watermark;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("ObjectIds");
        User user = ContextHelper.getLoginUser();
        return Watermarks.findByIds(user, string);
    }
}

