/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.db.InfoViewDBStoreServer;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewEmploy;
import com.trs.components.infoview.persistent.InfoViewEmploys;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewService;
import com.trs.service.ServiceHelper;
import com.trs.service.impl.InfoViewService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import org.apache.log4j.Logger;

public class InfoviewDataToolService
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(InfoviewDataToolService.class);
    IInfoViewService m_oInfoviewService = new InfoViewService();
    private InfoViewDBStoreServer m_oInfoViewDBStoreServer = null;

    public void adapterHistory(MethodContext methodContext) throws WCMException {
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label1", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e00\u6b65\u5f00\u59cb."));
        this.rebuildAllInfoViews(methodContext);
        this.renderAllInfoViewSearchOutlineFields(methodContext);
        this.renderAllChannelOutlineFields(methodContext);
        this.syncChnlDocFlag(methodContext);
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label2", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e00\u6b65\u6210\u529f."));
    }

    public void syncChnlDocFlag(MethodContext methodContext) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label3", "\u540c\u6b65\u6587\u6863\u7684DocFlag\u5230ChnlDoc\u8868\u4e2d."));
        String string = "update WCMChnlDoc set DocFlag=(select DocFlag from WCMDocument where DocFlag>0  and DocId=WCMChnlDoc.DocId)";
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{string});
    }

    public void autoCreateHistoryDocs(MethodContext methodContext) throws WCMException {
        CMSBaseObjs cMSBaseObjs;
        System.out.println(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label4", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e8c\u6b65\u5f00\u59cb."));
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label5", "\u904d\u5386docflag>0\u7684\u6587\u6863\u5217\u8868\uff0c\u4fdd\u5b58\u76f8\u5173\u7684\u5b57\u6bb5\uff0c\u751f\u6210\u65b0\u7684\u8868\u5355\u6570\u636e."));
        User user = this.getLoginUser();
        WCMFilter wCMFilter = new WCMFilter();
        String string = CMyString.showNull(methodContext.getValue("ChannelIds"), methodContext.getValue("ChannelId"));
        String string2 = CMyString.showNull(methodContext.getValue("SiteIds"), methodContext.getValue("SiteId"));
        if (string == null || string.length() <= 0) {
            if (string2 != null && string2.length() > 0) {
                cMSBaseObjs = new Channels(user);
                cMSBaseObjs.open(new WCMFilter("", "siteid in(" + string2 + ")", "", "CHANNELID"));
                string = cMSBaseObjs.getIdListAsString();
            } else {
                int n = methodContext.getValue("InfoViewId", 0);
                if (n != 0) {
                    InfoViewEmploys infoViewEmploys = new InfoViewEmploys(user);
                    infoViewEmploys.open(new WCMFilter("", "InfoViewID=" + n + " and EmployerType=101", "", "EmployerID"));
                    string = infoViewEmploys.getIdListAsString();
                }
            }
        }
        if (!CMyString.isEmpty(string)) {
            wCMFilter.setWhere("docchannel in(" + string + ")");
        }
        wCMFilter.mergeWith(new WCMFilter("", "docflag>0", ""));
        cMSBaseObjs = new Documents(user);
        cMSBaseObjs.open(wCMFilter);
        for (int i = 0; i < ((Documents)cMSBaseObjs).size(); ++i) {
            int n = 0;
            try {
                Document document = (Document)((Documents)cMSBaseObjs).getAt(i);
                if (document == null) continue;
                n = document.getId();
                this.getInfoViewDBStoreServer().saveInfoViewData(document.getFlag(), document);
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label6", "\u6210\u529f\u4e3a\u6587\u6863[") + document + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label7", "]\u521b\u5efa/\u66f4\u65b0\u5143\u6570\u636e.")));
                continue;
            }
            catch (WCMException wCMException) {
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label8", "\u4e3a\u6587\u6863[") + n + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label9", "]\u521b\u5efa/\u66f4\u65b0\u5143\u6570\u636e\u51fa\u9519.")), (Throwable)wCMException);
            }
        }
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label10", "\u8868\u5355\u5347\u7ea7\u64cd\u4f5c\u7b2c\u4e8c\u6b65\u6210\u529f."));
    }

    private InfoViewDBStoreServer getInfoViewDBStoreServer() throws WCMException {
        if (this.m_oInfoViewDBStoreServer == null) {
            this.m_oInfoViewDBStoreServer = (InfoViewDBStoreServer)DreamFactory.createObjectById("InfoViewDBStoreServer");
        }
        if (this.m_oInfoViewDBStoreServer == null) {
            throw new WCMException(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label11", "\u5bf9\u4e0d\u8d77\uff0c\u65e0\u6cd5\u627e\u5230\u7a00\u758f\u6570\u636e\u5e94\u7528\uff01\u8bf7\u68c0\u67e5\u60a8\u7684WCM\uff01"));
        }
        return this.m_oInfoViewDBStoreServer;
    }

    public void renderAllChannelOutlineFields(MethodContext methodContext) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label12", "\u66ff\u6362\u680f\u76ee\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u81ea\u52a8\u751f\u6210\u76f8\u5e94\u7684DB\u5b57\u6bb5."));
        InfoViewEmploys infoViewEmploys = new InfoViewEmploys(this.getLoginUser());
        infoViewEmploys.open(null);
        for (int i = 0; i < infoViewEmploys.size(); ++i) {
            int n = 0;
            try {
                InfoViewEmploy infoViewEmploy = (InfoViewEmploy)infoViewEmploys.getAt(i);
                CMSObj cMSObj = infoViewEmploy.getEmployer();
                InfoView infoView = infoViewEmploy.getInfoView();
                if (infoView == null || !(cMSObj instanceof Channel)) continue;
                Channel channel = (Channel)cMSObj;
                n = channel.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label13", "\u66ff\u6362\u680f\u76ee\u7684\u6982\u89c8\u5b57\u6bb5[channelid=") + n + "]."));
                String string = channel.getOutlineFields();
                if (CMyString.isEmpty(string)) continue;
                Object[] objectArray = string.split(",");
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                        objectArray[j] = "DOCNO";
                    }
                    if (!((String)objectArray[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                    objectArray[j] = "RANDOMSERIAL";
                }
                string = CMyString.join(objectArray, ",");
                channel.setOutlineFields(string);
                channel.setProperty("OutlineDBFields", InfoViewHelper.getDBFieldsByFields(infoView, string, true));
                ServiceHelper.createChannelService().save(channel);
                continue;
            }
            catch (WCMException wCMException) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label13", "\u66ff\u6362\u680f\u76ee\u7684\u6982\u89c8\u5b57\u6bb5[channelid=") + n + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label14", "]\u65f6\u51fa\u9519")), (Throwable)wCMException);
            }
        }
    }

    public void renderAllInfoViewSearchOutlineFields(MethodContext methodContext) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label15", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5\uff0c\u81ea\u52a8\u751f\u6210\u76f8\u5e94\u7684DB\u5b57\u6bb5."));
        InfoViews infoViews = new InfoViews(this.getLoginUser());
        infoViews.open(null);
        for (int i = 0; i < infoViews.size(); ++i) {
            int n = 0;
            try {
                Object object;
                InfoView infoView = (InfoView)infoViews.getAt(i);
                if (infoView == null) continue;
                n = infoView.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label16", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5[infoviewid=") + n + "]."));
                boolean bl = false;
                String string = infoView.getOutlineFields();
                if (!CMyString.isEmpty(string)) {
                    bl = true;
                    object = string.split(",");
                    for (int j = 0; j < ((String[])object).length; ++j) {
                        if (object[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                            object[j] = "DOCNO";
                        }
                        if (!((String)object[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                        object[j] = "RANDOMSERIAL";
                    }
                    string = CMyString.join(object, ",");
                    infoView.setOutlineFields(string);
                }
                if (!CMyString.isEmpty((String)(object = infoView.getSearchFields()))) {
                    bl = true;
                    Object[] objectArray = object.split(",");
                    for (int j = 0; j < objectArray.length; ++j) {
                        if (objectArray[j].trim().equalsIgnoreCase("ARCHIVESERIAL")) {
                            objectArray[j] = "DOCNO";
                        }
                        if (!((String)objectArray[j]).trim().equalsIgnoreCase("POSITIONCODE")) continue;
                        objectArray[j] = "RANDOMSERIAL";
                    }
                    object = CMyString.join(objectArray, ",");
                    infoView.setSearchFields((String)object);
                }
                if (!bl) continue;
                infoView.save();
                continue;
            }
            catch (WCMException wCMException) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label16", "\u66ff\u6362\u89c6\u56fe\u7684\u68c0\u7d22\u5b57\u6bb5\uff0c\u6982\u89c8\u5b57\u6bb5[infoviewid=") + n + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label14", "]\u65f6\u51fa\u9519")), (Throwable)wCMException);
            }
        }
    }

    public void rebuildAllInfoViews(MethodContext methodContext) throws WCMException {
        logger.info((Object)I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label17", "\u51c6\u5907\u4e3a\u7cfb\u7edf\u6240\u6709\u89c6\u56fe\u521b\u5efa\u8868\u7ed3\u6784."));
        InfoViews infoViews = new InfoViews(this.getLoginUser());
        infoViews.open(null);
        for (int i = 0; i < infoViews.size(); ++i) {
            int n = 0;
            try {
                InfoView infoView = (InfoView)infoViews.getAt(i);
                n = infoView.getId();
                logger.info((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label18", "\u91cd\u65b0\u6574\u7406\u8868\u5355[infoviewid=") + n + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label19", "]\u6587\u4ef6\u4ee5\u751f\u6210DB\u7ed3\u6784.")));
                this.m_oInfoviewService.save(infoView);
                continue;
            }
            catch (WCMException wCMException) {
                logger.error((Object)(I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label18", "\u91cd\u65b0\u6574\u7406\u8868\u5355[infoviewid=") + n + I18NMessage.get(InfoviewDataToolService.class, "InfoviewDataToolService.label20", "]\u6587\u4ef6\u4ee5\u751f\u6210DB\u7ed3\u6784\u65f6\u51fa\u9519")), (Throwable)wCMException);
            }
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

