/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ProcessService;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.infoview.mad.InfoViewQueryHelper;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DiscoveryFactoryBuddy;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowingDocQueryService
implements ISelfDefinedServiceProvider {
    protected static Logger logger = Logger.getLogger(ProcessService.class);
    private ProcessService m_oProcessService = new ProcessService();

    public String getFlowingDocBySNO(MethodContext methodContext) throws Throwable {
        int n = this.getInfoViewQueryHelper().findCurrDocIdBySNO(methodContext);
        if (n == 0) {
            return null;
        }
        String string = methodContext.getValue("SNO");
        methodContext.setValue("ContentType", 605);
        methodContext.setValue("ContentId", n);
        FlowDocs flowDocs = this.m_oProcessService.getFlowDocsOfContent(methodContext);
        FlowDoc flowDoc = null;
        if (flowDocs == null || flowDocs.size() <= 0 || (flowDoc = (FlowDoc)flowDocs.getAt(0)) == null) {
            return null;
        }
        Document document = (Document)flowDoc.getFlowContent().getSubstance();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("SNO", string));
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("FlowDocId", String.valueOf(flowDoc.getId())));
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("DocTitle", document.getTitle() + "[ID=" + document.getId() + "]"));
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("DocId", String.valueOf(document.getId())));
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("Channel", document.getChannel().getDesc() + "[ID=" + document.getChannelId() + "]"));
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("PostUser", document.getPropertyAsString("PostUser")));
        CMyDateTime cMyDateTime = document.getCrTime();
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("PostTime", cMyDateTime.toString()));
        CMyDateTime cMyDateTime2 = flowDoc.getCrTime();
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("LastProcessTime", cMyDateTime2.toString()));
        long l = cMyDateTime2.dateDiff(3, cMyDateTime);
        if (l == 0L) {
            l = cMyDateTime2.dateDiff(4, cMyDateTime);
            stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("TotleTime", l + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label1", "\u5c0f\u65f6")));
        } else {
            stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("TotleTime", l + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label2", "\u5929")));
        }
        String string2 = document.getPropertyAsString("FLOWOPERATIONMARK");
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("ProcessStatus", string2));
        String string3 = document.getPropertyAsString("FLOWOPERATIONMASKENUM");
        stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("ProcessStages", string3));
        String string4 = WCMProcessServiceHelper.makeXMLNode("FlowingDocInfo", stringBuffer.toString(), false);
        stringBuffer.setLength(0);
        return string4;
    }

    public String getFlowingStatByChnl(MethodContext methodContext) throws Throwable {
        try {
            int n = methodContext.getValue("ChannelId", 0);
            Channel channel = Channel.findById(n);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label3", "ID\u4e3a[") + n + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label4", "]\u7684\u9891\u9053\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
            }
            FlowEmployMgr flowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
            Flow flow = flowEmployMgr.getFlow(channel);
            if (flow == null) {
                throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label3", "ID\u4e3a[") + n + I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label5", "]\u7684\u9891\u9053\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff01\uff01"));
            }
            Map map = this.parseFlowingPath(flow.getPropertyAsString("OperationMarkEnum"));
            if (map == null || map.isEmpty()) {
                return null;
            }
            this.fillFromRecords(map, channel, methodContext);
            StringBuffer stringBuffer = new StringBuffer();
            for (Map.Entry object2 : map.entrySet()) {
                Object k = object2.getKey();
                Integer n2 = (Integer)object2.getValue();
                if (k == null || n2 == null) continue;
                String string = WCMProcessServiceHelper.makeXMLNode("StageName", k.toString());
                string = string + WCMProcessServiceHelper.makeXMLNode("StageCounter", String.valueOf(n2));
                stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("Stage", string, false));
            }
            String string = WCMProcessServiceHelper.makeXMLNode("Stages", stringBuffer.toString(), false);
            stringBuffer.setLength(0);
            return string;
        }
        catch (WCMException wCMException) {
            return WCMProcessServiceHelper.makeXMLNode("errmsg", wCMException.getMessage());
        }
    }

    private Map fillFromRecords(Map map, Channel channel, MethodContext methodContext) throws Throwable {
        Documents documents = null;
        documents = channel.getType() == 13 ? this.getInfoViewQueryHelper().getDocuments(channel, methodContext) : this.getDocuments(channel, methodContext);
        if (documents == null || documents.size() <= 0) {
            return null;
        }
        Document document = null;
        CPager cPager = new CPager(-1);
        int n = documents.size();
        cPager.setItemCount(n);
        for (int i = cPager.getFirstItemIndex() - 1; i < cPager.getLastItemIndex(); ++i) {
            String string;
            document = (Document)documents.getAt(i);
            if (document == null || CMyString.isEmpty(string = document.getPropertyAsString("FLOWOPERATIONMARK"))) continue;
            Integer n2 = (Integer)map.get(string);
            if (n2 == null) {
                n2 = new Integer(0);
            }
            map.put(string, new Integer(n2 + 1));
        }
        return map;
    }

    private Documents getDocuments(Channel channel, MethodContext methodContext) throws WCMException {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Documents documents = documentMgr.getAllDocuments(channel, null);
        return documents;
    }

    public Map parseFlowingPath(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        String string2 = string;
        if (CMyString.isEmpty(string2)) {
            return hashMap;
        }
        String[] stringArray = (string2 = string2.replaceAll("(\\{|\\}|\\[|\\])", "")).split(",");
        if (stringArray.length <= 2) {
            return hashMap;
        }
        for (int i = 1; i < stringArray.length - 1; ++i) {
            String string3 = stringArray[i];
            if (CMyString.isEmpty(string3)) continue;
            hashMap.put(string3, null);
        }
        return hashMap;
    }

    private InfoViewQueryHelper getInfoViewQueryHelper() throws WCMException {
        InfoViewQueryHelper infoViewQueryHelper = (InfoViewQueryHelper)DiscoveryFactoryBuddy.getImplementor(InfoViewQueryHelper.class);
        if (infoViewQueryHelper == null) {
            throw new WCMException(I18NMessage.get(FlowingDocQueryService.class, "FlowingDocQueryService.label6", "\u6ca1\u6709\u5b89\u88c5\u8868\u5355\u9009\u4ef6\uff01\u8bf7\u6b63\u786e\u5b89\u88c5\u540e\u518d\u4f7f\u7528\u8be5\u9009\u9879\u529f\u80fd\uff01"));
        }
        return infoViewQueryHelper;
    }
}

