/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.trsserver.DatasFromTRSServer;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.Reports;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.config.PageOperator;
import com.trs.wcm.config.PageOperators;
import com.trs.wcm.customize.ICustomizeMgr;
import com.trs.wcm.photo.IImageLibService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DocumentServiceProvider
implements IGlueServiceProvider {
    private static Logger logger = Logger.getLogger(DocumentServiceProvider.class);
    private ContentExtFieldMgr m_oExtFieldMgr = null;
    public static boolean SUPPORT_DEFINE_DOCUMENT_RIGHT = true;
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;
    private static final String DEFAULT_DELCHANNELIDS = "-1";
    private static String[][] DEFAULT_FIELDS = new String[][]{{"DocTitle", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label1", "\u6807\u9898"), "true"}, {"CrTime", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label2", "\u521b\u5efa\u65f6\u95f4"), "true"}, {"DocChannel", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label3", "\u6240\u5c5e\u680f\u76ee"), "true"}, {"CrUser", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label4", "\u53d1\u7a3f\u4eba"), "true"}, {"DocStatus", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label5", "\u72b6\u6001"), "true"}, {"DocType", I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label6", "\u7c7b\u578b"), "true"}};
    private static StringBuffer DEFAULT_SELECT_FIELDS = new StringBuffer(10 + DEFAULT_FIELDS.length * 20);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private ICustomizeMgr m_oCustomizeMgr = (ICustomizeMgr)DreamFactory.createObjectById("ICustomizeMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    private DocReplyMgr m_oDocReplyMgr = null;

    public DocumentServiceProvider() {
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
        this.m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        boolean bl = methodContext.getValue("Drop", false);
        Documents documents = Documents.findByIds(user, methodContext.getObjectIds());
        this.validateRight(user, baseChannel, documents, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label7", "\u5220\u9664"));
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            Channel channel = null;
            channel = !baseChannel.isSite() ? (Channel)baseChannel : document.getChannel();
            this.m_oDocumentMgr.delete(document, channel, bl);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        Object object;
        int n;
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        this.validateRight(user, baseChannel, 30, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label8", "\u83b7\u53d6\u6587\u6863\u5217\u8868"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        int n2 = methodContext.getValue("ItemCount", 0);
        if (n2 > 0) {
            wCMFilter.setMaxRowNumber(n2);
        }
        if ((n = methodContext.getValue("FilterType", 0)) != 0 && (object = this.makeFilterByType(user, baseChannel.getSite(), n)) != null && ((WCMFilter)object).getWhere() != null && ((WCMFilter)object).getWhere().length() > 0) {
            wCMFilter.setWhere(((WCMFilter)object).getWhere());
            wCMFilter.setSearchValues(((WCMFilter)object).getSearchValues());
        }
        object = this.m_oDocumentMgr.getDocuments(baseChannel, wCMFilter);
        if (SUPPORT_DEFINE_DOCUMENT_RIGHT) {
            this.removeDocumentNotHasRight(user, baseChannel, (Documents)object, 30, methodContext);
        }
        debugTimer.stop();
        logger.info((Object)("use[" + debugTimer.getTime() + "]ms"));
        return object;
    }

    private BaseChannel makeCurrChannelOrSite(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("SiteID", 0);
        int n2 = methodContext.getValue("ChannelId", 0);
        if (n <= 0 && n2 <= 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label9", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u65e0\u6548\u7684\u7ad9\u70b9ID[") + n + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label10", "]\u6216\u680f\u76eeID[") + n2 + "]!");
        }
        if (n > 0 && n2 > 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label11", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u540c\u65f6\u6307\u5b9a\u4e86\u7ad9\u70b9ID[") + n + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label12", "]\u548c\u680f\u76eeID[") + n2 + "]!");
        }
        BaseChannel baseChannel = null;
        if (n > 0 && ((baseChannel = WebSite.findById(n)) == null || baseChannel.getStatus() < 0)) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(103)}));
        }
        if (n2 > 0) {
            baseChannel = Channel.findById(n2);
            if (baseChannel == null || baseChannel.getStatus() < 0) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n2), WCMTypes.getLowerObjName(101)}));
            }
            methodContext.putContextCacheData("CurrChannel", baseChannel);
        }
        return baseChannel;
    }

    public String preview(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        Document document = null;
        document = new Document();
        String[] stringArray = new String[]{"ChannelId", "SiteId", "ObjectId"};
        document = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, document, stringArray);
        document.setPubHtmlContent(document.getHtmlContent());
        document.setProperty("CRTIME", CMyDateTime.now());
        document.setProperty("CRUSER", user.getName());
        if (document.getType() != 20) {
            document.setProperty("DOCPUBHTMLCON", document.getProperty("DocContent"));
        }
        String[] stringArray2 = new String[1];
        String string = null;
        if (baseChannel instanceof Channel) {
            document.setChannel((Channel)baseChannel);
            int n2 = methodContext.getValue("FlowDocId", 0);
            if (n2 > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label15", "\u9884\u89c8"));
            } else {
                Document document2 = Document.findById(methodContext.getObjectId());
                if (!DocumentAuthServer.hasRight(user, baseChannel, document2, 38)) {
                    throw new WCMException(1002, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label16", "\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8") + baseChannel + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label17", "\u4e2d\u7684\u6587\u6863"));
                }
            }
            n = methodContext.getObjectId();
            if (n == 0) {
                n = -user.getId();
            }
        } else {
            throw new WCMException(200006, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label18", "\u6ca1\u6709\u4f20\u5165\u680f\u76eeID!"));
        }
        document.setId(n);
        IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        iPublishContent.setFolder(iPublishFolder);
        Template template = Template.findById(methodContext.getValue("TemplateId", 0));
        string = PublishServer.getInstance().previewContent(iPublishContent, stringArray2, template);
        return "<result><![CDATA[" + string + "]]></result>";
    }

    public int save(MethodContext methodContext) throws Throwable {
        DebugTimer debugTimer = new DebugTimer();
        DebugTimer debugTimer2 = new DebugTimer();
        if (logger.isDebugEnabled()) {
            debugTimer.start();
            debugTimer2.start();
            logger.info((Object)"Document.save...");
        }
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        Document document = null;
        int n = methodContext.getObjectId();
        if (n == 0) {
            document = new Document();
        } else {
            document = Document.findById(n);
            if (document == null) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label19", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
            }
        }
        int n2 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0 && n > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else {
            int n3 = 80;
            if (!this.hasRight(user, baseChannel, document, n3)) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label21", "\u60a8\u6ca1\u6709\u6743\u9650\u4fdd\u5b58\u6587\u6863![ObjectId=") + methodContext.getObjectId() + "]");
            }
        }
        String[] stringArray = new String[]{"ChannelId", "SiteId", "ObjectId", "FLOWDOCID", "FieldNamesNotTrim"};
        document = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, document, stringArray);
        if (document.isAddMode()) {
            document.setChannel(methodContext.getValue("ChannelId", 0));
        }
        if (logger.isDebugEnabled()) {
            debugTimer2.stop();
            logger.info((Object)("init[" + document + "] use [" + debugTimer2.getTime() + "]ms!"));
        }
        if (!document.isAddMode() && document.isChangeProperty("DocStatus")) {
            this.m_oDocumentMgr.changeStatus(document, baseChannel.isSite() ? document.getChannel() : (Channel)baseChannel, document.getNewPropertyAsInt("DocStatus", 1));
            document.unlock();
            int n4 = document.getPropertyAsInt("DocStatus", 0);
            int n5 = document.getNewPropertyAsInt("DocStatus", 0);
            if (n4 == 1028 && n5 == 1) {
                this.m_oDocumentMgr.save(document);
            }
        } else {
            debugTimer2 = new DebugTimer();
            if (logger.isDebugEnabled()) {
                debugTimer2.start();
                logger.info((Object)"DocumentMgr.save...");
            }
            this.m_oDocumentMgr.save(document);
            if (logger.isDebugEnabled()) {
                debugTimer2.stop();
                logger.info((Object)("DocumentMgr.save[" + document + "] use [" + debugTimer2.getTime() + "]ms!"));
            }
        }
        if (logger.isDebugEnabled()) {
            debugTimer.stop();
            logger.info((Object)("save[" + document + "] use [" + debugTimer.getTime() + "]ms!"));
        }
        try {
            WCMProcessServiceHelper.startDocumentInFlow(user, document, methodContext);
        }
        catch (Throwable throwable) {
            ServiceInvocationException serviceInvocationException = new ServiceInvocationException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label22", "\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label23", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), throwable);
            serviceInvocationException.setErrorCode("17080");
            throw serviceInvocationException;
        }
        this.processQutedPhotoIfNeed(document);
        return document.getId();
    }

    private void processQutedPhotoIfNeed(Document document) {
        if (document.getType() != 20) {
            return;
        }
        final Document document2 = document;
        final Logger logger = DocumentServiceProvider.logger;
        final User user = ContextHelper.getLoginUser();
        new Thread(){

            public void run() {
                ContextHelper.initContext(user);
                String string = document2.getHtmlContent();
                HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string);
                HtmlElement htmlElement = null;
                HashSet<String> hashSet = new HashSet<String>(5, 0.2f);
                String string2 = null;
                while ((htmlElement = htmlElementFinder.findNextElement("img")) != null) {
                    if (!"1".equals(htmlElement.getAttributeValue("fromphoto"))) continue;
                    string2 = htmlElement.getAttributeValue("photodocid");
                    hashSet.add(string2);
                }
                IImageLibService iImageLibService = (IImageLibService)DreamFactory.createObjectById("IImageLibService");
                if (!hashSet.isEmpty()) {
                    try {
                        StringBuffer stringBuffer = new StringBuffer(64);
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append(",");
                            stringBuffer.append(iterator.next());
                        }
                        iImageLibService.quoteImages(document2.getId(), stringBuffer.substring(1));
                    }
                    catch (Exception exception) {
                        logger.error((Object)"fail to record photolib quoted!", (Throwable)exception);
                    }
                } else {
                    try {
                        iImageLibService.clearQuotedImages(document2.getId());
                    }
                    catch (WCMException wCMException) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("SelectFields");
        Document document = Document.findById(n, string);
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        int n2 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0 && n > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(user, baseChannel, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label109", "\u67e5\u770b"));
        }
        return document;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        boolean bl = methodContext.getValue("FromOutline", false);
        String string = methodContext.getObjectIds();
        String string2 = methodContext.getValue("SelectFields");
        Documents documents = Documents.findByIds(null, string);
        documents.setFilter(new WCMFilter("", "", "", string2));
        this.removeDocumentNotHasRight(user, baseChannel, documents, bl ? 30 : 34, methodContext);
        return documents;
    }

    public String getPageInfo(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        if (baseChannel == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label25", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + methodContext.getValue("SITEID") + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label14", "]\u6216\u680f\u76ee[ID=") + methodContext.getValue("CHANNELID") + "].");
        }
        int n = 30;
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label26", "\u60a8\u6ca1\u6709\u6743\u9650\u6d4f\u89c8[") + baseChannel + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label27", "]\u7684\u6587\u6863\u5217\u8868\uff01"));
        }
        Element element = DocumentHelper.createElement((String)"PageInfo");
        if (baseChannel.isSite()) {
            element.addAttribute("SiteId", String.valueOf(baseChannel.getId()));
        } else {
            element.addAttribute("ChannelId", String.valueOf(baseChannel.getId()));
        }
        element.addElement("DisplayName").addCDATA(baseChannel.getDesc());
        element.addElement("DisplayDesc").addCDATA(this.getFolderPath(baseChannel));
        Element element2 = element.addElement("Personal");
        this.addFilters(element2);
        this.addFileds(element2);
        return element.asXML();
    }

    public PageOperators getOperators(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        int n = methodContext.getObjectId();
        if (n > 0) {
            return this.makeDocumentOpertators(user, baseChannel, n);
        }
        String string = methodContext.getObjectIds();
        if (string != null && string.length() > 0) {
            return this.makeDocumentsOpertators(user, baseChannel, string);
        }
        throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label28", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public Channels getQuotedChannels(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("ObjectId", 0);
        if (n <= 0) {
            return new Channels(null);
        }
        Document document = this.findDocumentById(n);
        int n2 = methodContext.getValue("Modal", 0);
        return this.m_oDocumentMgr.getQutoedChannels(document, n2, null);
    }

    public Reports move(MethodContext methodContext) throws Throwable {
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getValue("FromChannelId", 0);
        Channel channel = Channel.findById(n2);
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label103", "\u6e90\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        Documents documents = this.getDocuments(methodContext);
        Channel channel2 = this.findChannelById(methodContext.getValue("ToChannelId", 0));
        if (channel2 == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label104", "\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        if (channel2.getStatus() < 0) {
            return null;
        }
        String string = channel == null ? "" : CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label30", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863\u5230\u680f\u76ee[{1}]."), new String[]{channel.getDispDesc(), channel2.getDispDesc()});
        Reports reports = new Reports(string);
        if (!this.hasRight(user, channel2, null, 31)) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label31", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[{0}]\u4e2d\u6dfb\u52a0\u6587\u6863!"), new String[]{channel2.getDispDesc()}), null);
            return reports;
        }
        int n3 = documents.size();
        for (n = 0; n < n3; ++n) {
            Document document = (Document)documents.getAt(n);
            if (document == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label33", "\u79fb\u52a8\u5931\u8d25:\u6587\u6863[ID={0}]\u6ca1\u6709\u627e\u5230!"), new int[]{documents.getIdAt(n)}), null);
                documents.removeAt(n, false);
                continue;
            }
            if (this.hasRight(user, channel, document, 33)) continue;
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label35", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u79fb\u52a8\u6587\u6863[") + document.getTitle() + "]!", null);
            documents.removeAt(n, false);
        }
        for (n = documents.size() - 1; n >= 0; --n) {
            Document document = (Document)documents.getAt(n);
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(document, channel, channel2));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label102", "\u4ece\u680f\u76ee[{0}\u79fb\u52a8\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25."), new String[]{channel.getDispDesc(), document.getTitle(), channel2.getDispDesc()}), throwable);
            }
        }
        return reports;
    }

    public Reports copy(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("FromChannelId", 0);
        Channel channel = Channel.findById(n);
        Documents documents = this.getDocuments(methodContext);
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        int n2 = methodContext.getValue("TransmitType", 1);
        return this.transmit(user, channel, documents, channels, n2);
    }

    public void startDocumentInFlow(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Document document = Document.findById(methodContext.getObjectId());
        if (document == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label19", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + methodContext.getObjectId() + "]");
        }
        if (!DocumentAuthServer.hasRight(user, null, document, 32)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label39", "\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u6587\u6863[Title=") + document.getTitle() + "][DocId=" + methodContext.getObjectId() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label40", "]\u6d41\u8f6c\uff01"));
        }
        methodContext.setValue("force2start", "true");
        WCMProcessServiceHelper.startDocumentInFlow(user, document, methodContext);
    }

    private Documents getDocuments(MethodContext methodContext) throws WCMException {
        Channel channel = null;
        Documents documents = null;
        String string = methodContext.getObjectIds();
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label41", "\u6ca1\u6709\u6307\u5b9a\u8981\u5f15\u7528\u7684\u6587\u6863\uff01"));
        }
        int n = methodContext.getValue("FromChannelId", 0);
        if (n == 0 || n == -2 || n == -1) {
            documents = Documents.findByIds(this.getLoginUser(), string);
        } else {
            channel = this.findChannelById(n);
            WCMFilter wCMFilter = new WCMFilter("", "DocId IN(" + string + ")", "");
            documents = this.m_oDocumentMgr.getDocuments(channel, wCMFilter);
        }
        return documents;
    }

    public Reports transmit(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Documents documents = Documents.findByIds(user, methodContext.getObjectIds());
        Channel channel = null;
        int n = methodContext.getValue("FromChannelId", 0);
        if (n > 0) {
            channel = this.findChannelById(n);
        }
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        int n2 = methodContext.getValue("TransmitType", 1);
        return this.transmit(user, channel, documents, channels, n2);
    }

    public ContentExtendValues queryExtendFields(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Document document = this.findDocumentById(methodContext.getValue("DocumentId", 0));
        Channel channel = document.getChannel();
        if (channel == null) {
            return new ContentExtendValues(user);
        }
        this.validateRight(user, (BaseChannel)channel, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label42", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        ContentExtFields contentExtFields = this.m_oExtFieldMgr.getExtFields(channel, wCMFilter, false);
        ContentExtendValues contentExtendValues = new ContentExtendValues(user, contentExtFields.size(), 1);
        int n = contentExtFields.size();
        for (int i = 0; i < n; ++i) {
            ContentExtField contentExtField = (ContentExtField)contentExtFields.getAt(i);
            if (contentExtField == null) continue;
            contentExtendValues.addElement(i + 1, contentExtField.getDesc(), contentExtField.getName(), document.getPropertyAsString(contentExtField.getName()));
        }
        return contentExtendValues;
    }

    public void setTopDocument(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Document document = this.findDocumentById(methodContext.getValue("DocumentId", 0));
        Document document2 = null;
        int n = methodContext.getValue("TargetDocumentId", 0);
        if (n > 0) {
            document2 = this.findDocumentById(n);
        }
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        CMyDateTime cMyDateTime = null;
        int n2 = methodContext.getValue("Position", 0);
        int n3 = methodContext.getValue("TopFlag", 0);
        if (!document.getCrUser().equals(user)) {
            this.validateRight(user, channel, 62, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label43", "\u7f6e\u9876"));
        }
        if (n3 > 0) {
            if (n3 == 1) {
                cMyDateTime = methodContext.getValue("InvalidTime", new CMyDateTime());
            } else if (n3 == 2) {
                cMyDateTime = null;
            } else if (n3 == 3) {
                cMyDateTime = new CMyDateTime();
            }
            this.m_oDocumentMgr.setTopDocument(channel, document, document2, n2, cMyDateTime);
        } else {
            this.m_oDocumentMgr.removeToppedDocument(channel, document);
        }
    }

    private Reports copy(User user, Documents documents, Channel channel, Channels channels) throws WCMException {
        int n;
        String string = "";
        if (channel != null) {
            string = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label44", "\u4ece\u680f\u76ee[{0}]\u590d\u5236\u6587\u6863"), new String[]{CMyString.filterForHTMLValue(channel.getDispDesc())});
        }
        Reports reports = new Reports(string);
        documents.setMaxBufferSize(documents.size());
        for (n = documents.size() - 1; n >= 0; --n) {
            Document document = (Document)documents.getAt(n);
            if (document == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label45", "\u590d\u5236\u5931\u8d25:\u6587\u6863[ID=") + documents.getIdAt(n) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                documents.removeAt(n, false);
                continue;
            }
            if (this.hasRight(user, channel, document, 34)) continue;
        }
        if (documents.size() <= 0) {
            reports.addSucessedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label110", "\u6ca1\u6709\u9700\u8981\u590d\u5236\u7684\u6587\u6863\u3002"));
            return reports;
        }
        int n2 = channels.size();
        for (n = 0; n < n2; ++n) {
            Channel channel2 = (Channel)channels.getAt(n);
            if (channel2 == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label47", "\u590d\u5236\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(n) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            reports.add(this.copy(user, documents, channel, channel2));
        }
        return reports;
    }

    private Reports copy(User user, Documents documents, Channel channel, Channel channel2) throws WCMException {
        String string = null;
        string = channel != null ? CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label48", "\u4ece\u680f\u76ee[{0}]\u5411\u680f\u76ee[{1}]\u590d\u5236\u6587\u6863"), new String[]{channel.getDispDesc(), channel2.getDispDesc()}) : CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label49", "\u5411\u680f\u76ee[{0}]\u590d\u5236\u6587\u6863"), new String[]{channel2.getDispDesc()});
        Reports reports = new Reports(string);
        if (!this.hasRight(user, channel2, null, 31)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label105", "\u590d\u5236\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + user.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + channel2.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
            return reports;
        }
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            try {
                Document document2 = this.m_oDocumentMgr.copyDocument(document, channel, channel2);
                if (document2 == null) {
                    reports.addFailedReport(document + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label55", "\u5728") + channel2 + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label56", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
                    continue;
                }
                if (document2.getId() != document.getId()) {
                    this.m_oAppendixMgr.copyAppendixes(document, document2);
                    this.m_oRelationMgr.copyRelations(document, document2);
                    this.m_oDocReplyMgr.copyDocReplys(document, document2);
                }
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label57", "\u590d\u5236\u6587\u6863[{0}]\u6210\u529f!"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label36", "\u590d\u5236\u6587\u6863[{0}]\u5931\u8d25!"), new String[]{document.getTitle()}), throwable);
            }
        }
        return reports;
    }

    public Reports copyAll(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("FromChannelId", 0));
        this.validateRight(user, channel, 57, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label58", "\u62f7\u8d1d"));
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        methodContext.setValue("ChannelId", channel.getId());
        Documents documents = (Documents)this.query(methodContext);
        return this.copy(user, documents, channel, channels);
    }

    public Reports setQuote(MethodContext methodContext) throws Throwable {
        Channel channel;
        int n;
        User user = this.getLoginUser();
        int n2 = methodContext.getValue("FromChannelId", 0);
        Channel channel2 = Channel.findById(n2);
        int n3 = methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(n3);
        String string = methodContext.getValue("QuoteType");
        String string2 = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label59", "\u5f15\u7528\u6587\u6863");
        Reports reports = new Reports(string2);
        if (document == null) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label60", "\u5f15\u7528\u5931\u8d25:\u6587\u6863[ID=") + n3 + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
            return reports;
        }
        if (!this.hasRight(user, channel2, document, 34)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label61", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[") + document.getTitle() + "]!", null);
            return reports;
        }
        String string3 = methodContext.getValue("ToChannelIds");
        String string4 = methodContext.getValue("DelChannelIds");
        Channels channels = Channels.findByIds(user, string3);
        String string5 = null;
        int n4 = channels.size();
        for (n = 0; n < n4; ++n) {
            channel = (Channel)channels.getAt(n);
            ChnlDoc chnlDoc = this.m_oDocumentMgr.findChnlDoc(document, channel);
            if (chnlDoc == null) continue;
            if (string.equals("mirror")) {
                if (chnlDoc.getModal() != 2) continue;
                if (string5 == null) {
                    string5 = CMyString.numberToStr(channel.getId());
                    continue;
                }
                string5 = string5 + "," + CMyString.numberToStr(channel.getId());
                continue;
            }
            if (chnlDoc.getModal() != 3) continue;
            string5 = string5 == null ? CMyString.numberToStr(channel.getId()) : string5 + "," + CMyString.numberToStr(channel.getId());
        }
        if (string5 != null) {
            string4 = string4.equals(DEFAULT_DELCHANNELIDS) ? string5 : string4 + "," + string5;
        }
        try {
            if (string4 == null) {
                if (string.equals("mirror")) {
                    this.m_oDocumentMgr.deleteDocMirrors(document, string3);
                } else {
                    this.m_oDocumentMgr.deleteDocQuotes(document, string3);
                }
            } else if (!string4.equals(DEFAULT_DELCHANNELIDS) || !CMyString.isEmpty(string4)) {
                this.m_oDocumentMgr.deleteDocQuotesInDelChnlIds(document, string4);
            }
        }
        catch (WCMException wCMException) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label62", "\u5220\u9664\u4e0d\u518d\u4f7f\u7528\u7684\u5f15\u7528\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01"), wCMException);
            return reports;
        }
        channels = Channels.findByIds(user, string3);
        n4 = channels.size();
        for (n = 0; n < n4; ++n) {
            channel = (Channel)channels.getAt(n);
            if (channel == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label63", "\u5f15\u7528\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(n) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            string2 = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label64", "\u5728\u680f\u76ee[{0}]\u5f15\u7528\u6587\u6863"), new String[]{channel.getDispDesc()});
            if (!channel.isCluster() && !this.hasRight(user, channel, null, 31)) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label106", "\u5f15\u7528\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + user.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + channel.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
                continue;
            }
            try {
                if (string.equals("mirror")) {
                    this.m_oDocumentMgr.mirrorTo(document, channel);
                } else {
                    this.m_oDocumentMgr.quoteTo(document, channel);
                }
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label107", "\u5f15\u7528\u6587\u6863[{0}]\u6210\u529f\uff01"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label108", "\u5f15\u7528\u6587\u6863[{0}]\u5931\u8d25\uff01"), new String[]{document.getTitle()}), throwable);
            }
        }
        return reports;
    }

    public Reports quote(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        int n = methodContext.getValue("FromChannelId", 0);
        Channel channel = Channel.findById(n);
        Documents documents = this.getDocuments(methodContext);
        String string = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label59", "\u5f15\u7528\u6587\u6863");
        Reports reports = new Reports(string);
        for (int i = documents.size() - 1; i >= 0; --i) {
            object = (Document)documents.getAt(i);
            if (object == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label60", "\u5f15\u7528\u5931\u8d25:\u6587\u6863[ID=") + documents.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                documents.removeAt(i, false);
                continue;
            }
            if (this.hasRight(user, channel, (Document)object, 34)) continue;
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label61", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[") + ((Document)object).getTitle() + "]!", null);
            documents.removeAt(i, false);
        }
        String string2 = methodContext.getValue("ToChannelIds");
        object = Channels.findByIds(user, string2);
        int n2 = ((BaseObjs)object).size();
        for (int i = 0; i < n2; ++i) {
            Channel channel2 = (Channel)((BaseObjs)object).getAt(i);
            if (channel2 == null) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label63", "\u5f15\u7528\u5931\u8d25:\u680f\u76ee[ID=") + ((BaseObjs)object).getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            reports.add(this.quote(user, documents, channel2));
        }
        return reports;
    }

    private Reports quote(User user, Documents documents, Channel channel) throws WCMException {
        String string = CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label64", "\u5728\u680f\u76ee[{0}]\u5f15\u7528\u6587\u6863"), new String[]{channel.getDispDesc()});
        Reports reports = new Reports(string);
        if (!this.hasRight(user, channel, null, 31)) {
            reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label106", "\u5f15\u7528\u6587\u6863\u5931\u8d25!"), null).setRportDetail(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label52", "\u7528\u6237[") + user.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label53", "]\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[") + channel.getDispDesc() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label54", "]\u6dfb\u52a0\u6587\u6863!"));
            return reports;
        }
        for (int i = documents.size() - 1; i >= 0; --i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            try {
                this.m_oDocumentMgr.quoteTo(document, channel);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label107", "\u5f15\u7528\u6587\u6863[{0}]\u6210\u529f\uff01"), new String[]{document.getTitle()}));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label108", "\u5f15\u7528\u6587\u6863[{0}]\u5931\u8d25\uff01"), new String[]{document.getTitle()}), throwable);
            }
        }
        return reports;
    }

    public void changeOrder(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Document document = this.findDocumentById(methodContext.getValue("FromDocId", 0));
        Document document2 = this.findDocumentById(methodContext.getValue("ToDocId", 0));
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        int n = methodContext.getValue("Position", 1);
        if (!DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, 62)) {
            throw new WCMException(1002, CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label111", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[{0}][ID=[{1}]\u4e0b\u6539\u53d8\u8bb0\u5f55\u987a\u5e8f\uff01"), new Object[]{channel.toString(), new Integer(channel.getId())}));
        }
        this.validateRight(user, channel, 62, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label68", "\u6539\u53d8\u6587\u6863\u987a\u5e8f"));
        this.m_oDocumentMgr.moveDocumentInChannel(document, document2, channel, n);
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Documents documents = Documents.findByIds(user, methodContext.getObjectIds());
        String string = methodContext.getValue("ExportFields");
        boolean bl = methodContext.getValue("ExportAppendix", false);
        this.validateRight(user, null, documents, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label69", "\u5bfc\u51fa\u6587\u6863"));
        DocumentExporter documentExporter = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        String string2 = documentExporter.export(documents, string, bl);
        methodContext.setContentTypeIsHTML();
        return string2;
    }

    public String importDocuments(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        String string = methodContext.getValue("ImportFile");
        String string2 = methodContext.getValue("ImportXSLFile");
        boolean bl = methodContext.getValue("ImportByChnlName", true);
        boolean bl2 = methodContext.getValue("ImportToCurrChannel", true);
        boolean bl3 = methodContext.getValue("IgnoreTitleSim", true);
        boolean bl4 = methodContext.getValue("IsTrsServerFile", false);
        this.validateRight(user, baseChannel, 31, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label70", "\u5bfc\u5165\u6587\u6863"));
        DocumentImporter documentImporter = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        if (bl4) {
            return documentImporter.importFromTRSFile(string, baseChannel.isSite() ? null : (Channel)baseChannel, string2, bl3, bl2).toJSONXML();
        }
        return documentImporter.importFromFile(string, baseChannel.isSite() ? null : (Channel)baseChannel, string2, bl3, bl2, bl).toJSONXML();
    }

    public Relations queryRelations(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(n);
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        int n2 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0 && n > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(user, null, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label71", "\u83b7\u53d6\u76f8\u5173\u6587\u6863\u4fe1\u606f"));
        }
        return this.m_oRelationMgr.getRelations(document, wCMFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRelation(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(n);
        int n2 = methodContext.getValue("FlowDocId", 0);
        if (n2 > 0 && n > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n2, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!user.isAdministrator() && !user.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(user, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label72", "\u8bbe\u7f6e\u76f8\u5173\u6587\u6863"));
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new Relation());
        xMLToCMSObj.parse(methodContext.getValue("RelationsXML"));
        this.m_oRelationMgr.deleteUnuseRelations(xMLToCMSObj.getObjectIds(), document);
        boolean bl = true;
        try {
            int n3 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n3; ++i) {
                Relation relation = (Relation)xMLToCMSObj.getCMSObjs()[i];
                if (relation == null) continue;
                if (relation.isAddMode()) {
                    relation.setDocId(n);
                } else if (i + 1 == relation.getSerialNo()) {
                    relation.cancelUpdate(user);
                    continue;
                }
                relation.setProperty("SERN", i + 1);
                relation.save(user);
            }
            bl = false;
        }
        finally {
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
        }
    }

    public Documents queryRecycle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        this.validateRight(user, baseChannel, 30, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label8", "\u83b7\u53d6\u6587\u6863\u5217\u8868"));
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oDocumentMgr.getRecycleDocuments(baseChannel, wCMFilter);
    }

    public void restore(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        this.validateRight(user, baseChannel, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label73", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        boolean bl = methodContext.getValue("RestoreAll", false);
        Documents documents = null;
        documents = bl ? this.m_oDocumentMgr.getRecycleDocuments(baseChannel, null) : Documents.findByIds(user, methodContext.getObjectIds());
        Channel channel = baseChannel.isSite() ? null : (Channel)baseChannel;
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.m_oDocumentMgr.restore(document, channel);
        }
    }

    public void clearRecycle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        this.validateRight(user, baseChannel, 33, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label74", "\u6e05\u7a7a\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        this.m_oDocumentMgr.clearAll(user, baseChannel);
    }

    public Appendixes queryAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("AppendixType", 50);
        int n2 = methodContext.getValue("DocumentId", 0);
        Document document = this.findDocumentById(n2);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n3 > 0 && n2 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, -1, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label24", "\u67e5\u770b"));
        } else {
            this.validateRight(user, null, document, 34, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label75", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f"));
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(document, n, wCMFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("AppendixType", 50);
        int n2 = methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(n2);
        FilesMan filesMan = FilesMan.getFilesMan();
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n3 > 0 && n2 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!user.isAdministrator() && !user.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(user, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label76", "\u8bbe\u7f6e\u9644\u4ef6"));
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new Appendix());
        xMLToCMSObj.parse(methodContext.getValue("AppendixesXML"));
        this.m_oAppendixMgr.deleteUnuseAppendixes(document, xMLToCMSObj.getObjectIds(), n);
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n4;
            int n5 = xMLToCMSObj.getCMSObjs().length;
            for (n4 = 0; n4 < n5; ++n4) {
                boolean bl3;
                Appendix appendix = (Appendix)xMLToCMSObj.getCMSObjs()[n4];
                if (appendix == null) continue;
                appendix.setSerialNo(n4 + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(n);
                    appendix.setDocId(n2);
                    this.m_oAppendixMgr.addAppendix(document, appendix);
                } else {
                    this.m_oAppendixMgr.editAppendix(document, appendix);
                }
                if (bl2 || appendix.getFlag() != 20) continue;
                String string = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
                int[] nArray = CMyString.splitToInt(string, ",");
                String string2 = appendix.getFile();
                String string3 = filesMan.mapFilePath(string2, 0) + string2;
                bl2 = bl3 = CMyFile.validImageFile(string3, nArray[0], nArray[1]);
            }
            bl = false;
            if (n == 50 || n == 20) {
                n4 = document.hasImgInDocContent() ? 1 : 0;
                if (n4 != 0 && !bl2) {
                    document.setAttachPic(2);
                } else if (n4 == 0 && bl2) {
                    document.setAttachPic(1);
                } else if (n4 != 0 && bl2) {
                    document.setAttachPic(3);
                } else {
                    document.setAttachPic(0);
                }
                document.validCanEditAndLock(user);
                document.save(user);
            }
        }
        finally {
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("AppendixType", 50);
        int n2 = methodContext.getValue("DocId", 0);
        Document document = this.findDocumentById(n2);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n3 > 0 && n2 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, document, n3, 0, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label20", "\u4fee\u6539"));
        } else if (!user.isAdministrator() && !user.getName().equalsIgnoreCase(document.getCrUserName())) {
            this.validateRight(user, null, document, 32, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label76", "\u8bbe\u7f6e\u9644\u4ef6"));
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new Appendix());
        xMLToCMSObj.parse(methodContext.getValue("AppendixesXML"));
        boolean bl = true;
        boolean bl2 = false;
        try {
            int n4 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n4; ++i) {
                Appendix appendix = (Appendix)xMLToCMSObj.getCMSObjs()[i];
                if (appendix == null) continue;
                appendix.setSerialNo(i + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(n);
                    appendix.setDocId(n2);
                    this.m_oAppendixMgr.addAppendix(document, appendix);
                } else {
                    this.m_oAppendixMgr.editAppendix(document, appendix);
                }
                if (appendix.getFlag() != 20) continue;
                bl2 = true;
            }
            bl = false;
            if (n == 50 || n == 20) {
                document.validCanEditAndLock(user);
                document.setProperty("AttachPic", bl2 ? 1L : 0L);
                document.save(user);
            }
        }
        finally {
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
        }
    }

    public void changeStatus(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        BaseChannel baseChannel = this.makeCurrChannelOrSite(methodContext);
        Documents documents = Documents.findByIds(user, methodContext.getObjectIds());
        Status status = Status.findById(methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label77", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(user, baseChannel, status.getRightIndex(), I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label78", "\u6539\u53d8\u6587\u6863\u72b6\u6001"));
        int n = documents.size();
        for (int i = 0; i < n; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.m_oDocumentMgr.changeStatus(document, baseChannel.isSite() ? document.getChannel() : (Channel)baseChannel, status.getId());
        }
    }

    private PageOperators makeDocumentOpertators(User user, BaseChannel baseChannel, int n) throws WCMException {
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label79", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ID=") + n + "]\uff01");
        }
        PageOperators pageOperators = this.m_oCustomizeMgr.getPageOpertators(user, "document", new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
        if (user.isAdministrator()) {
            return pageOperators;
        }
        for (int i = pageOperators.size() - 1; i >= 0; --i) {
            PageOperator pageOperator = (PageOperator)pageOperators.getAt(i);
            if (pageOperator == null || pageOperator.getRightIndex() >= 0 || DocumentAuthServer.hasRight(user, baseChannel, document, pageOperator.getRightIndex())) continue;
            pageOperators.removeAt(i, false);
        }
        return pageOperators;
    }

    private PageOperators makeDocumentsOpertators(User user, BaseChannel baseChannel, String string) throws WCMException {
        Documents documents = Documents.findByIds(user, string);
        if (documents.isEmpty()) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label80", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u6863[ObjectIds=") + string + "]\uff01");
        }
        if (documents.size() == 1) {
            return this.makeDocumentOpertators(user, baseChannel, documents.getIdAt(0));
        }
        PageOperators pageOperators = this.m_oCustomizeMgr.getPageOpertators(user, "documents", new WCMFilter("", "", "", "RightIndex, OprName, OprDesc, OprType, OprKey, ISDISPLAY"));
        if (user.isAdministrator()) {
            return pageOperators;
        }
        for (int i = pageOperators.size() - 1; i >= 0; --i) {
            PageOperator pageOperator = (PageOperator)pageOperators.getAt(i);
            if (pageOperator == null || pageOperator.getRightIndex() >= 0 || DocumentAuthServer.hasRight(user, baseChannel, documents, pageOperator.getRightIndex())) continue;
            pageOperators.removeAt(i, false);
        }
        return pageOperators;
    }

    private void addFilters(Element element) {
        Element element2 = element.addElement("Filters");
        for (int i = 0; i < ServiceConstants.FILTERS_DOCUMENTS_DEFAULT.length; ++i) {
            element2.addElement("Filter").addAttribute("Name", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][0]).addAttribute("Type", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][1]).addAttribute("IsDefault", ServiceConstants.FILTERS_DOCUMENTS_DEFAULT[i][2]);
        }
    }

    private void addFileds(Element element) {
        Element element2 = element.addElement("DisplayFields");
        for (int i = 0; i < DEFAULT_FIELDS.length; ++i) {
            element2.addElement("Field").addAttribute("Name", DEFAULT_FIELDS[i][0]).addAttribute("Desc", DEFAULT_FIELDS[i][1]).addAttribute("IsOrder", DEFAULT_FIELDS[i][2]);
        }
    }

    private String getFolderPath(BaseChannel baseChannel) throws WCMException {
        if (baseChannel.isSite()) {
            return baseChannel.getDesc();
        }
        return this.getFolderPath(baseChannel.getHost()) + ">>" + baseChannel.getDesc();
    }

    private WCMFilter makeFilterByType(User user, WebSite webSite, int n) throws Exception {
        WCMFilter wCMFilter = new WCMFilter();
        String string = null;
        switch (n) {
            case 1: {
                string = "DocStatus=?";
                wCMFilter.addSearchValues(0, 1);
                break;
            }
            case 3: {
                string = "DocStatus=?";
                wCMFilter.addSearchValues(0, 10);
                break;
            }
            case 2: {
                IFolderPubStatusCacheMgr iFolderPubStatusCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                int[] nArray = iFolderPubStatusCacheMgr.findStatusesCanDoIncreasePub(webSite.getWCMType(), webSite.getId());
                if (nArray == null) {
                    nArray = new int[]{-1};
                }
                for (int i = 0; i < nArray.length; ++i) {
                    string = string == null ? "DocStatus in(?" : string + ",?";
                    wCMFilter.addSearchValues(i, nArray[i]);
                }
                if (string == null) break;
                string = string + ")";
                break;
            }
            case 4: {
                string = "CrUser=?";
                wCMFilter.addSearchValues(0, user.getName());
                break;
            }
            case 5: {
                string = "CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                break;
            }
            case 6: {
                string = "CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                break;
            }
            case 7: {
                string = "CrTime>=?";
                wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                break;
            }
        }
        wCMFilter.setWhere(string);
        return wCMFilter;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Document findDocumentById(int n) throws WCMException {
        Document document = Document.findById(n);
        if (document == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(605)}));
        }
        return document;
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(n), WCMTypes.getLowerObjName(101)}));
        }
        return channel;
    }

    private void validateRight(User user, BaseChannel baseChannel, Documents documents, int n, String string) throws WCMException {
        int n2 = documents.size();
        for (int i = 0; i < n2; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.validateRight(user, baseChannel, document, n, string);
        }
    }

    private void removeDocumentNotHasRight(User user, BaseChannel baseChannel, Documents documents, int n, MethodContext methodContext) throws WCMException {
        int n2 = -1;
        int n3 = 1;
        n2 = methodContext.getPageSize();
        n3 = methodContext.getPageIndex();
        CPager cPager = new CPager(n2);
        cPager.setCurrentPageIndex(n3);
        cPager.setItemCount(documents.size());
        int n4 = cPager.getLastItemIndex() - cPager.getFirstItemIndex() + 1;
        if (n4 > 300) {
            return;
        }
        for (int i = cPager.getLastItemIndex(); i >= cPager.getFirstItemIndex(); --i) {
            Document document = (Document)documents.getAt(i - 1);
            if (document == null || this.hasRight(user, baseChannel, document, n)) continue;
            documents.removeAt(i, false);
        }
    }

    private void validateRight(User user, BaseChannel baseChannel, Document document, int n, String string) throws WCMException {
        if (!this.hasRight(user, baseChannel, document, n)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label84", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label85", "]\u6ca1\u6709\u6743\u9650") + string + ":" + document + "\uff01");
        }
    }

    private boolean hasRight(User user, BaseChannel baseChannel, Document document, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, baseChannel, document, n);
    }

    private void validateRight(User user, BaseChannel baseChannel, int n, String string) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label84", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728({1})\u4e0a\u6267\u884c[{2}]\u64cd\u4f5c\uff01"), new String[]{user.getName(), baseChannel.toString(), string}));
        }
    }

    private Reports transmit(User user, Channel channel, Documents documents, Channels channels, int n) throws WCMException {
        CMSObj cMSObj;
        int n2;
        String string = this.makeTransmitDesc(n);
        String string2 = null;
        string2 = channel != null ? I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label89", "\u5728[") + channel + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label90", "]\u4e0a") + string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label91", "\u6587\u6863") : string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label91", "\u6587\u6863");
        Reports reports = new Reports(string2);
        Channel channel2 = channel;
        int n3 = 0;
        if (channel2 != null) {
            n3 = channel2.getId();
        }
        if (!user.isAdministrator()) {
            for (n2 = channels.size() - 1; n2 >= 0; --n2) {
                cMSObj = (Channel)channels.getAt(n2);
                if (cMSObj == null) {
                    reports.addFailedReport(string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label92", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(n2) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                    channels.removeAt(n2, false);
                    continue;
                }
                if (AuthServer.hasRight(user, cMSObj, 31)) continue;
                reports.addFailedReport(string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label93", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[") + cMSObj + "].", null);
                channels.removeAt(n2, false);
            }
        }
        for (n2 = documents.size() - 1; n2 >= 0; --n2) {
            cMSObj = (Document)documents.getAt(n2);
            if (cMSObj == null) {
                reports.addFailedReport(string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label94", "\u5931\u8d25:\u6587\u6863[ID=") + documents.getIdAt(n2) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel channel3 = null;
            channel3 = n3 == ((Document)cMSObj).getChannelId() ? channel2 : ((Document)cMSObj).getChannel();
            if (!this.hasRight(user, channel3, (Document)cMSObj, 34)) {
                reports.addFailedReport(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label95", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + cMSObj.getId() + ",Title=" + ((Document)cMSObj).getTitle() + "]!", null);
                continue;
            }
            int n4 = channels.size();
            for (int i = 0; i < n4; ++i) {
                Channel channel4 = (Channel)channels.getAt(i);
                if (channel4 == null) {
                    reports.addFailedReport(string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label92", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(i) + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label34", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(channel3, (Document)cMSObj, channel4, n, reports);
            }
        }
        return reports;
    }

    private String makeTransmitDesc(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label96", "\u590d\u5236");
                break;
            }
            case 2: {
                string = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label97", "\u5f15\u7528");
                break;
            }
            case 3: {
                string = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label98", "\u955c\u50cf");
            }
        }
        return string;
    }

    private void transmit(Channel channel, Document document, Channel channel2, int n, Reports reports) {
        String string = this.makeTransmitDesc(n);
        if (channel2.isVirtual()) {
            string = I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label97", "\u5f15\u7528");
        }
        try {
            switch (n) {
                case 1: {
                    Document document2 = this.m_oDocumentMgr.copyDocument(document, channel, channel2);
                    if (document2 == null) {
                        reports.addFailedReport(document + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label55", "\u5728") + channel2 + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label56", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"), null);
                        return;
                    }
                    if (document2.getId() != document.getId()) {
                        this.m_oAppendixMgr.copyAppendixes(document, document2);
                        this.m_oRelationMgr.copyRelations(document, document2);
                        this.m_oDocReplyMgr.copyDocReplys(document, document2);
                    }
                    reports.addSucessedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label99", "\u6210\u529f\u590d\u5236\u6587\u6863[{0}]\u5230\u680f\u76ee[{1}]!"), new String[]{document.getTitle(), channel2.getDispDesc()}));
                    break;
                }
                case 2: {
                    reports.addReport(this.m_oDocumentMgr.quoteTo(document, channel2));
                    break;
                }
                case 3: {
                    reports.addReport(this.m_oDocumentMgr.mirrorTo(document, channel2));
                }
            }
        }
        catch (Throwable throwable) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label100", "{0}\u6587\u6863[{1}]\u5230\u680f\u76ee[{2}]\u5931\u8d25\uff01"), new String[]{string, document.getTitle(), channel2.getDispDesc()}), throwable);
        }
    }

    public void trsSaveToWCM(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ServerIds");
        int n = methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label104", "\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        Document document = new Document();
        int n2 = 80;
        if (!this.hasRight(user, channel, document, n2)) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label21", "\u60a8\u6ca1\u6709\u6743\u9650\u4fdd\u5b58\u6587\u6863![ObjectId=") + methodContext.getObjectId() + "]");
        }
        DatasFromTRSServer datasFromTRSServer = new DatasFromTRSServer();
        datasFromTRSServer.setWhere("IR_SID=" + string);
        datasFromTRSServer.setSelect("IR_SID,IR_URLTITLE,IR_URLTIME,IR_ABSTRACT,IR_KEYWORDS,IR_AUTHORS,IR_CONTENT,IR_URLCONTENT");
        ArrayList arrayList = new ArrayList();
        arrayList = (ArrayList)datasFromTRSServer.getDatasFromTRSServer(methodContext.getPageIndex(), methodContext.getPageSize());
        if (arrayList.size() <= 0) {
            throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label50", "\u672a\u627e\u5230IR_SID\u4e3a") + string + I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label51", "\u7684TRSServer\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\uff01"));
        }
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                HashMap hashMap = (HashMap)arrayList.get(i);
                if (hashMap == null) continue;
                Document document2 = new Document();
                document2.setType(20);
                document2.setChannel(channel);
                string2 = CMyString.transDisplay((String)hashMap.get("IR_ABSTRACT"));
                string3 = CMyString.transDisplay((String)hashMap.get("IR_URLCONTENT"));
                document2.setTitle((String)hashMap.get("IR_URLTITLE"));
                document2.setAuthor((String)hashMap.get("IR_AUTHORS"));
                document2.setKeywords((String)hashMap.get("IR_KEYWORDS"));
                document2.setAbstract(string2);
                document2.setContent(string3);
                document2.setHtmlContent(string3);
                this.m_oDocumentMgr.save(document2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        DEFAULT_SELECT_FIELDS.append("DocId");
        for (int i = 0; i < DEFAULT_FIELDS.length; ++i) {
            DEFAULT_SELECT_FIELDS.append(",");
            DEFAULT_SELECT_FIELDS.append(DEFAULT_FIELDS[i][0]);
        }
    }
}

