/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ICategoryServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.util.Category;
import com.trs.components.wcm.util.Categorys;
import com.trs.components.wcm.util.ICategoryMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import java.util.Map;

public class CategoryServiceProvider
implements ICategoryServiceProvider {
    private static final int SELECT_NODE = 0;
    private static final int ONLY_SELECT_LEAF = 1;
    private ICategoryMgr m_oCategoryMgr = (ICategoryMgr)DreamFactory.createObjectById("ICategoryMgr");

    public void delete(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getObjectId();
        if (n > 0) {
            Category category = Category.findById(n);
            this.m_oCategoryMgr.deleteCategory(user, category);
        } else {
            String string = methodContext.getObjectIds();
            Categorys categorys = Categorys.findByIds(user, string);
            int n2 = categorys.size();
            for (int i = 0; i < n2; ++i) {
                Category category = (Category)categorys.getAt(i);
                if (category == null) continue;
                this.m_oCategoryMgr.deleteCategory(user, category);
            }
        }
    }

    public Object findById(MethodContext methodContext) throws WCMException {
        int n = methodContext.getObjectId();
        Category category = null;
        category = n == 0 ? Category.createNewInstance() : Category.findById(n);
        return category;
    }

    public Object query(MethodContext methodContext) throws WCMException {
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        return Categorys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
    }

    public Category saveCategory(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        Category category = null;
        if (n > 0 && (category = Category.findById(n)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9[Id=" + n + "]\u4e0d\u5b58\u5728\uff01");
        }
        int n2 = methodContext.getValue("objectId", 0);
        Category category2 = null;
        if (n2 > 0) {
            category2 = Category.findById(n2);
            if (category2 == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5206\u7c7b\u8282\u70b9[ID=" + n2 + "]\u6ca1\u6709\u627e\u5230\uff01");
            }
        } else {
            category2 = Category.createNewInstance();
            category2.setParentId(n);
            if (category != null) {
                category2.setRootId(category2.isRoot() ? category2.getId() : category2.getRootId());
            } else {
                category2.setRootId(0);
            }
        }
        WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, category2, new String[]{"objectId"});
        category2.save(user);
        return category2;
    }

    public String createCategoryTreeHTML(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ParentId", 0);
        Category category = Category.findById(n);
        if (category == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9[Id=" + n + "]\u4e0d\u5b58\u5728\uff01");
        }
        Categorys categorys = this.m_oCategoryMgr.queryChildren(user, category, null);
        int n2 = methodContext.getValue("SelectType", 0);
        StringBuffer stringBuffer = new StringBuffer(51200);
        this.makeCategoryHTML(stringBuffer, categorys, n2);
        return stringBuffer.toString();
    }

    public String createCategoryTreeHTMLOfIds(MethodContext methodContext) throws Throwable {
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getValue("objectIds");
        int n = methodContext.getValue("SelectType", 0);
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (methodContext.getValue("type", 0) == 0) {
            int[] nArray = CMyString.splitToInt(string, ",");
            this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, n, 0);
        } else {
            string = this.m_oCategoryMgr.getPath(Categorys.findByIds(user, string));
            int[] nArray = CMyString.splitToInt(string, ",");
            HashMap hashMap = new HashMap(nArray.length);
            this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, hashMap, n, 0);
        }
        return stringBuffer.toString();
    }

    private void createCategoryTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, int n, int n2) throws WCMException {
        if (n2 == nArray.length) {
            return;
        }
        Category category = Category.findById(nArray[n2]);
        if (category == null) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        Categorys categorys = this.m_oCategoryMgr.queryChildren(user, category, null);
        if (categorys.size() <= 0) {
            return;
        }
        ++n2;
        int n3 = categorys.size();
        for (int i = 0; i < n3; ++i) {
            Category category2 = (Category)categorys.getAt(i);
            if (category2 == null) continue;
            if (n2 + 1 < nArray.length && category2.getId() == nArray[n2]) {
                this.appendCategoryHTML(stringBuffer, category2, n);
                stringBuffer.append("<ul>");
                this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, n, n2);
                stringBuffer.append("</ul>");
                continue;
            }
            this.makeCategoryHTML(stringBuffer, category2, n);
        }
    }

    private void createCategoryTreeHTMLOfIds(StringBuffer stringBuffer, int[] nArray, Map map, int n, int n2) throws WCMException {
        if (n2 >= nArray.length) {
            return;
        }
        if (map.get(new Integer(nArray[n2])) == Boolean.TRUE) {
            this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, map, n, n2 + 1);
            return;
        }
        map.put(new Integer(nArray[n2]), Boolean.TRUE);
        Category category = Category.findById(nArray[n2]);
        if (category == null) {
            this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, map, n, n2 + 1);
            return;
        }
        User user = ContextHelper.getLoginUser();
        this.appendCategoryHTML(stringBuffer, category, n);
        Categorys categorys = this.m_oCategoryMgr.queryChildren(user, category, null);
        if (categorys.size() <= 0) {
            return;
        }
        stringBuffer.append("<ul>");
        ++n2;
        int n3 = categorys.size();
        for (int i = 0; i < n3; ++i) {
            Category category2 = (Category)categorys.getAt(i);
            if (category2 == null) continue;
            if (n2 < nArray.length && this.isContain(nArray, category2.getId())) {
                this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, map, n, n2);
                continue;
            }
            this.makeCategoryHTML(stringBuffer, category2, n);
        }
        stringBuffer.append("</ul>");
        this.createCategoryTreeHTMLOfIds(stringBuffer, nArray, map, n, n2 + 1);
    }

    private boolean isContain(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private void makeCategoryHTML(StringBuffer stringBuffer, Categorys categorys, int n) throws WCMException {
        int n2 = categorys.size();
        for (int i = 0; i < n2; ++i) {
            this.makeCategoryHTML(stringBuffer, (Category)categorys.getAt(i), n);
        }
    }

    private void makeCategoryHTML(StringBuffer stringBuffer, Category category, int n) throws WCMException {
        this.appendCategoryHTML(stringBuffer, category, n);
        if (!category.isLeaf()) {
            stringBuffer.append("<ul></ul>\n");
        }
    }

    private void appendCategoryHTML(StringBuffer stringBuffer, Category category, int n) throws WCMException {
        if (category == null) {
            return;
        }
        boolean bl = category.isLeaf();
        stringBuffer.append("<div objectId=");
        stringBuffer.append("'");
        stringBuffer.append(category.getId());
        stringBuffer.append("'");
        stringBuffer.append(" id=");
        stringBuffer.append("'");
        stringBuffer.append("node_");
        stringBuffer.append(category.getId());
        stringBuffer.append("'");
        if (n == 1 && !bl) {
            stringBuffer.append(" onlyNode='true'");
        }
        stringBuffer.append(" cDesc=");
        stringBuffer.append("'");
        stringBuffer.append(CMyString.filterForHTMLValue(category.getCDesc()));
        stringBuffer.append("'");
        stringBuffer.append(" title=");
        stringBuffer.append("'");
        stringBuffer.append("ID:");
        stringBuffer.append(category.getId());
        stringBuffer.append("'");
        stringBuffer.append(">");
        stringBuffer.append("<a href=#>");
        stringBuffer.append(CMyString.transDisplay(category.getCName()));
        stringBuffer.append("</a></div>");
    }

    public String getPath(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("objectId", 0);
        if (n == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u5206\u7c7bID");
        }
        Category category = Category.findById(n);
        if (category == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + n + "]");
        }
        return this.m_oCategoryMgr.getPath(category);
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    public int save(MethodContext methodContext) throws WCMException {
        return this.saveCategory(methodContext).getId();
    }
}

