/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class SenderByMulticast
extends ClusterSenderBase {
    private static final Logger s_logger;
    private long sendBytes;
    private int sendBytesHalf;
    private MulticastSocket sendSocket;
    private DatagramPacket dataPacket;
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.SenderByMulticast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public SenderByMulticast() {
        super("SenderByMulticast");
    }

    public Member getRemoteMember() {
        return null;
    }

    protected void sendMessage(ClusterMessage message) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to send message:" + message));
        }
        int retry = 0;
        while (retry < this.getMaxRetry()) {
            try {
                byte[] buffer = this.dataPacket.getData();
                int dataLength = message.flush(buffer, 0);
                DatagramPacket packet = this.dataPacket;
                packet.setAddress(null);
                packet.setPort(0);
                packet.setLength(dataLength);
                this.sendSocket.send(packet);
                this.incSendBytes(dataLength);
                TransportTracer tracer = this.transportTracer;
                if (tracer == null) break;
                tracer.trace(buffer, 0, dataLength);
                break;
            }
            catch (Exception e) {
                s_logger.error((Object)("Send  '" + message + "' failed, retry=" + retry), (Throwable)e);
                ++retry;
            }
        }
    }

    protected long getSendBytes() {
        return this.sendBytes + (long)this.sendBytesHalf;
    }

    private final void incSendBytes(int value) {
        int temp = this.sendBytesHalf + value;
        if (temp > 0) {
            this.sendBytesHalf = temp;
            return;
        }
        this.sendBytesHalf = 0;
        this.sendBytes = this.sendBytes + (long)this.sendBytesHalf + (long)value;
    }

    protected void startup() {
        try {
            String path;
            int port = this.getConfig().getMulticastPort();
            InetAddress bind = this.getConfig().getInetMulticastBind();
            InetAddress group = this.getConfig().getInetMulticastAddress();
            try {
                this.sendSocket = new MulticastSocket(new InetSocketAddress(bind, 0));
                this.sendSocket.setNetworkInterface(NetworkInterface.getByInetAddress(bind));
                this.sendSocket.setInterface(bind);
            }
            catch (SocketException e) {
                if (this.sendSocket != null) {
                    try {
                        this.sendSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sendSocket = new MulticastSocket(0);
                this.sendSocket.setNetworkInterface(NetworkInterface.getByInetAddress(bind));
                this.sendSocket.setInterface(bind);
            }
            this.sendSocket.setTimeToLive(this.getConfig().getMulticastTTL());
            this.sendSocket.setSendBufferSize(this.getConfig().getUDPBufferSize());
            this.sendSocket.connect(group, port);
            byte[] buffer = new byte[this.getConfig().getUDPBufferSize()];
            this.dataPacket = new DatagramPacket(buffer, buffer.length);
            if (s_logger.isDebugEnabled() && (path = this.getConfig().getTracerDirectory()) != null) {
                String file = this.getName();
                this.transportTracer = TransportTracer.newTracer(path, file);
                if (this.transportTracer != null) {
                    this.transportTracer = this.transportTracer.initialize(this.sendSocket, true);
                }
            }
        }
        catch (IOException e) {
            String info = "SenderByMulticast startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void cleanup() {
        try {
            this.sendSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"SenderByMulticast cleanup failed", (Throwable)e);
        }
        this.dataPacket = null;
        this.sendSocket = null;
    }
}

