/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.impl.InetListener;
import com.trs.infra.cluster.impl.transport.ReceiverByTCP;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.member.MemberImpl;
import com.trs.infra.cluster.member.MemberManagerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class InetListenerByTCP
extends InetListener {
    private static final Logger s_logger;
    private MemberManagerImpl memberManager;
    private ServerSocket serverSocket;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.InetListenerByTCP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public InetListenerByTCP() {
        super("InetListenerByTCP");
    }

    public final MemberManagerImpl getMemberManager() {
        return this.memberManager;
    }

    public final void setMemberManager(MemberManagerImpl memberManager) {
        this.memberManager = memberManager;
    }

    protected void startup() {
        try {
            int port = this.getConfig().getTCPListenPort();
            InetAddress bind = this.getConfig().getInetTCPListenAddress();
            InetSocketAddress address = new InetSocketAddress(bind, port);
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(address);
        }
        catch (IOException e) {
            String info = "InetListenerByTCP startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void doListen() {
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByTCP doListen failed", (Throwable)e);
        }
        if (socket == null) {
            return;
        }
        if (!this.isContinue()) {
            return;
        }
        MemberImpl member = null;
        FilterStreamReader reader = null;
        try {
            reader = new FilterStreamReader(socket.getInputStream());
            String guid = reader.read_string();
            member = this.memberManager.memberArrive(guid);
            if (member == null) {
                throw new IOException("For resource free.");
            }
        }
        catch (IOException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                reader = null;
            }
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket = null;
            member = null;
        }
        if (member == null) {
            return;
        }
        ReceiverByTCP receiver = new ReceiverByTCP(socket, reader, member);
        receiver.setContext(this.getContext());
        receiver.start();
    }

    protected void cleanup() {
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByTCP cleanup failed", (Throwable)e);
        }
        this.serverSocket = null;
    }
}

