/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.collector;

import com.trs.components.collector.IInformation;
import com.trs.components.collector.InfoProperties;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationCollector {
    private final String url = "http://wcm6.trs.cn/wcm/infoCollector/information_addedit_dowith.jsp";
    private final String XMLKEY = "ObjectXML";

    public void send() {
        new Thread(){

            public void run() {
                while (true) {
                    if (InformationCollector.this.needToSend()) {
                        String xmlInfo = InformationCollector.this.getInformation();
                        if (xmlInfo == null) {
                            return;
                        }
                        HashMap<String, String> infoMap = new HashMap<String, String>(1);
                        infoMap.put("ObjectXML", xmlInfo);
                        InformationCollector.this.sendHttpRequest(infoMap);
                    }
                    try {
                        Thread.sleep(604800000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    private boolean needToSend() {
        int currentMoth = Calendar.getInstance().get(2) + 1;
        InfoProperties ip = InfoProperties.getInstance();
        String sLastMonth = ip.getProperity("lastSendTime");
        if (sLastMonth == null) {
            ip.setProperity("lastSendTime", "" + currentMoth);
            return true;
        }
        int lastMonth = Integer.parseInt(sLastMonth);
        if (lastMonth == currentMoth) {
            return false;
        }
        ip.setProperity("lastSendTime", "" + currentMoth);
        return true;
    }

    private String getInformation() {
        Iterator itConvertos = WCMDiscoveryFactory.getDiscovery().getImplementors(IInformation.class.getName());
        if (itConvertos == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<WCMOBJ><PROPERTIES><INFORMATIONID>0</INFORMATIONID>");
        while (itConvertos.hasNext()) {
            try {
                IInformation infoClass = (IInformation)Class.forName((String)itConvertos.next()).newInstance();
                HashMap<String, String> info = infoClass.getInfo();
                if (info == null) continue;
                for (String key : info.keySet()) {
                    sb.append("<");
                    sb.append(key);
                    sb.append(">");
                    sb.append("<![CDATA[");
                    sb.append(info.get(key));
                    sb.append("]]>");
                    sb.append("</");
                    sb.append(key);
                    sb.append(">");
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        sb.append("</PROPERTIES></WCMOBJ>");
        return sb.toString();
    }

    private void sendHttpRequest(HashMap<String, String> infoMap) {
        try {
            CMy3WLib.doPost((String)"http://wcm6.trs.cn/wcm/infoCollector/information_addedit_dowith.jsp", infoMap, (String)"ISO-8859-1");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }
}

