/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.collector;

import com.trs.infra.config.ConfigConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoProperties {
    private String infoFilePath;
    private HashMap<String, String> properties = new HashMap();
    private static InfoProperties instance = null;
    public static final String LASTSENDTIME = "lastSendTime";
    public static final String MAXSITECOUNT = "maxSiteCount";
    private static final String DEFAULT_MAX_SITE_COUNT = "5";

    InfoProperties() {
        this.infoFilePath = String.valueOf(ConfigConstants.DIR_APPROOT) + "infoConfig.properties";
        this.loadFile();
    }

    public String toString() {
        return this.properties.toString();
    }

    public static synchronized InfoProperties getInstance() {
        if (instance == null) {
            instance = new InfoProperties();
        }
        return instance;
    }

    public HashMap<String, String> getProperities() {
        return this.properties;
    }

    public String getProperity(String key) {
        if (key == null) {
            return null;
        }
        return this.properties.get(key);
    }

    void setProperity(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.properties.put(key, value);
        this.writeFile();
    }

    private void loadFile() {
        File propertyFile = new File(this.infoFilePath);
        if (!propertyFile.exists()) {
            this.setProperity(MAXSITECOUNT, DEFAULT_MAX_SITE_COUNT);
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.infoFilePath));
            String str = null;
            while ((str = br.readLine()) != null) {
                if (str.startsWith("#")) continue;
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 2);
                }
                String[] pair = str.split("=");
                this.properties.put(pair[0].trim(), pair[1].trim());
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeFile() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.infoFilePath));
            StringBuffer result = new StringBuffer();
            for (String key : this.properties.keySet()) {
                result.append(key);
                result.append("=");
                result.append(this.properties.get(key));
                result.append("\n");
            }
            bw.write(result.toString(), 0, result.toString().length());
            bw.flush();
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

