/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.api;

import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.beans.QParameter;
import com.tencent.weibo.utils.OAuthClient;
import com.tencent.weibo.utils.QHttpClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAPI {
    QHttpClient http = new QHttpClient();
    private static Log log = LogFactory.getLog(RequestAPI.class);

    public String getResource(String url, List<QParameter> parameters, OAuth oauth) throws Exception {
        parameters.addAll(oauth.getTokenParams());
        OAuthClient oac = new OAuthClient();
        String queryString = oac.getOauthParams(url, "GET", oauth.getOauth_consumer_secret(), oauth.getOauth_token_secret(), parameters);
        return this.http.httpGet(url, queryString);
    }

    public String postContent(String url, List<QParameter> parameters, OAuth oauth) throws Exception {
        parameters.addAll(oauth.getTokenParams());
        OAuthClient oac = new OAuthClient();
        String queryString = oac.getOauthParams(url, "POST", oauth.getOauth_consumer_secret(), oauth.getOauth_token_secret(), parameters);
        return this.http.httpPost(url, queryString);
    }

    public String postFile(String url, List<QParameter> parameters, List<QParameter> files, OAuth oauth) throws Exception {
        parameters.addAll(oauth.getTokenParams());
        OAuthClient oac = new OAuthClient();
        String queryString = oac.getOauthParams(url, "POST", oauth.getOauth_consumer_secret(), oauth.getOauth_token_secret(), parameters);
        return this.http.httpPostWithFile(url, queryString, files);
    }

    public String[] message(String result) {
        String[] arr = new String[2];
        try {
            SAXReader saxReader = new SAXReader();
            Document xml = saxReader.read((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")));
            arr[0] = xml.selectSingleNode("root/ret").getText();
            switch (Integer.parseInt(arr[0])) {
                case 0: {
                    arr[1] = "\u64cd\u4f5c\u6210\u529f";
                    break;
                }
                case 1: {
                    arr[1] = "\u53c2\u6570\u9519\u8bef";
                    break;
                }
                case 2: {
                    arr[1] = "\u9891\u7387\u53d7\u9650";
                    break;
                }
                case 3: {
                    arr[1] = "\u9274\u6743\u5931\u8d25";
                    break;
                }
                case 4: {
                    arr[1] = "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef";
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            arr[0] = "4";
            arr[1] = e.toString();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            arr[0] = "4";
            arr[1] = e.toString();
        }
        return arr;
    }
}

