/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public abstract class BaseImplClob {
    private static String footprint = "$Revision:   1.3.1.0  $";
    public static final int ASCII_ENCODING = 1;
    public static final int UCS2_ENCODING = 2;
    protected BaseExceptions exceptions;
    public static final String ASCII_ENCODING_NAME = "ISO-8859-1";
    public static final String UCS2_ENCODING_NAME = "UTF-16BE";

    public BaseImplClob(BaseExceptions baseExceptions) {
        UtilDebug.assert((String)"Must supply an exception generator", (baseExceptions != null ? 1 : 0) != 0);
        this.exceptions = baseExceptions;
    }

    public abstract void close() throws SQLException;

    public long find(String string, long l) throws SQLException {
        throw this.exceptions.getException(6004);
    }

    public static int getBytesPerChar(BaseImplClob baseImplClob) {
        UtilDebug.assert((String)"Must supply a BaseImplClob object", (baseImplClob != null ? 1 : 0) != 0);
        int n = -1;
        switch (baseImplClob.getCharacterEncoding()) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                UtilDebug.assert((String)"Invalid character encoding", (boolean)false);
            }
        }
        return n;
    }

    public abstract int getCharacterEncoding();

    public static String getEncodingName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = ASCII_ENCODING_NAME;
                break;
            }
            case 2: {
                string = UCS2_ENCODING_NAME;
                break;
            }
            default: {
                UtilDebug.assert((String)"Invalid character encoding", (boolean)false);
            }
        }
        return string;
    }

    public abstract long getLength() throws SQLException;

    public long getMaxChunkSize() {
        return 0L;
    }

    public abstract int readData(byte[] var1, int var2, long var3, int var5) throws SQLException;

    public boolean supportsSearch() {
        return false;
    }

    public abstract void truncate(long var1) throws SQLException;

    public abstract int writeData(long var1, byte[] var3, int var4, int var5) throws SQLException;
}

