/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.search.spans.SpanNearQuery;

public final class QueryTermExtractor {
    public static final WeightedTerm[] getTerms(Query query) {
        return QueryTermExtractor.getTerms(query, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query, false, fieldName);
        int totalNumDocs = reader.numDocs();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited, String fieldName) {
        HashSet terms = new HashSet();
        if (fieldName != null) {
            fieldName = fieldName.intern();
        }
        QueryTermExtractor.getTerms(query, terms, prohibited, fieldName);
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited) {
        return QueryTermExtractor.getTerms(query, prohibited, null);
    }

    private static final void getTerms(Query query, HashSet terms, boolean prohibited, String fieldName) {
        if (query instanceof BooleanQuery) {
            QueryTermExtractor.getTermsFromBooleanQuery((BooleanQuery)query, terms, prohibited, fieldName);
        } else if (query instanceof PhraseQuery) {
            QueryTermExtractor.getTermsFromPhraseQuery((PhraseQuery)query, terms, fieldName);
        } else if (query instanceof TermQuery) {
            QueryTermExtractor.getTermsFromTermQuery((TermQuery)query, terms, fieldName);
        } else if (query instanceof SpanNearQuery) {
            QueryTermExtractor.getTermsFromSpanNearQuery((SpanNearQuery)query, terms, fieldName);
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query, HashSet terms, boolean prohibited, String fieldName) {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].getOccur() == BooleanClause.Occur.MUST_NOT) continue;
            QueryTermExtractor.getTerms(queryClauses[i].getQuery(), terms, prohibited, fieldName);
        }
    }

    private static final void getTermsFromPhraseQuery(PhraseQuery query, HashSet terms, String fieldName) {
        Term[] queryTerms = query.getTerms();
        for (int i = 0; i < queryTerms.length; ++i) {
            if (fieldName != null && queryTerms[i].field() != fieldName) continue;
            terms.add(new WeightedTerm(query.getBoost(), queryTerms[i].text()));
        }
    }

    private static final void getTermsFromTermQuery(TermQuery query, HashSet terms, String fieldName) {
        if (fieldName == null || query.getTerm().field() == fieldName) {
            terms.add(new WeightedTerm(query.getBoost(), query.getTerm().text()));
        }
    }

    private static final void getTermsFromSpanNearQuery(SpanNearQuery query, HashSet terms, String fieldName) {
        Collection queryTerms = query.getTerms();
        Iterator iterator = queryTerms.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            String text = term.text();
            if (fieldName != null && term.field() != fieldName) continue;
            terms.add(new WeightedTerm(query.getBoost(), text));
        }
    }
}

