/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.largeobject.ClobOutputStream;
import com.kingbase8.largeobject.ClobWriter;
import com.kingbase8.util.LOGGER;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;

public class KbClob
implements Clob {
    private char[] buf;
    private Clob clob;
    private long len;
    private KbResultSet rs;
    private int columnIndex;

    public KbClob(char[] ch) throws SQLException, SQLException {
        this.len = ch.length;
        this.buf = new char[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = ch[i];
            ++i;
        }
        this.clob = null;
    }

    public KbClob(char[] ch, KbResultSet rs, int columnIndex) {
        if (ch != null) {
            this.len = ch.length;
            this.buf = new char[(int)this.len];
            int i = 0;
            while ((long)i < this.len) {
                this.buf[i] = ch[i];
                ++i;
            }
        } else {
            this.len = 0L;
            this.buf = new char[(int)this.len];
        }
        this.clob = null;
        this.rs = rs;
        this.columnIndex = columnIndex;
    }

    public KbClob(Clob clob) throws SQLException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a KbClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int read = 0;
        int offset = 0;
        try {
            Reader charStream = clob.getCharacterStream();
            if (charStream == null) {
                throw new SQLException("Invalid Clob object. The call to getCharacterStream returned null which cannot be serialized.");
            }
            InputStream asciiStream = clob.getAsciiStream();
            if (asciiStream == null) {
                throw new SQLException("Invalid Clob object. The call to getAsciiStream returned null which cannot be serialized.");
            }
            BufferedReader reader = new BufferedReader(charStream);
            do {
                read = ((Reader)reader).read(this.buf, offset, (int)(this.len - (long)offset));
                offset += read;
            } while (read > 0);
        }
        catch (IOException ex) {
            throw new SQLException("KbClob: " + ex.getMessage());
        }
    }

    @Override
    public long length() throws SQLException {
        this.isValid();
        return this.len;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.isValid();
        return new CharArrayReader(this.buf);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException, SQLException {
        this.isValid();
        String sbuf = this.getSubString(1L, (int)this.length());
        ByteArrayInputStream ins = new ByteArrayInputStream(sbuf.getBytes());
        return ins;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.length() && this.length() > 0L || pos > 1L && this.length() == 0L) {
            throw new SQLException("Invalid position in KbClob object set");
        }
        if (pos - 1L + (long)length > this.length()) {
            throw new SQLException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)pos - 1, length);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException("StringIndexOutOfBoundsException: " + e.getMessage());
        }
    }

    @Override
    public long position(String searchStr, long start) throws SQLException, SQLException {
        this.isValid();
        if (start < 1L || start > this.len) {
            return -1L;
        }
        char[] pattern = searchStr.toCharArray();
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException, SQLException {
        this.isValid();
        return this.position(searchStr.getSubString(1L, (int)searchStr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        LOGGER.log(Level.INFO, "pos: {0}, str: {1}", new Object[]{pos, str});
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int length) throws SQLException {
        LOGGER.log(Level.INFO, "pos: {0}, str: {1}, offset: {2}, length: {3}", new Object[]{pos, str, offset, length});
        this.isValid();
        String temp = str.substring(offset);
        char[] cPattern = temp.toCharArray();
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Invalid offset in char array set");
        }
        if (length < 0 || length > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length in char array set");
        }
        if (length == 0) {
            return 0;
        }
        if (pos < 1L || pos + (long)length - 1L > Integer.MAX_VALUE) {
            throw new SQLException("Invalid position in Clob object set");
        }
        int newlen = 0;
        if (pos <= this.len) {
            long remainlen = this.len - pos + 1L;
            if (remainlen < (long)length) {
                newlen = (int)(this.len + (long)length - remainlen);
            }
        } else {
            newlen = (int)(pos + (long)length - 1L);
        }
        if ((long)newlen > this.len) {
            this.len = newlen;
            char[] btemp = new char[(int)this.len];
            btemp = Arrays.copyOf(this.buf, (int)this.len);
            this.buf = btemp;
        }
        int cplen = 0;
        cplen = offset + length > str.length() ? str.length() - (int)pos : length;
        System.arraycopy(cPattern, offset, this.buf, (int)(--pos), cplen);
        if (this.rs != null) {
            this.rs.insertLob(this);
        }
        return length;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException, SQLException {
        LOGGER.log(Level.INFO, "setAsciiStream");
        this.isValid();
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Invalid position in CLOB object set");
        }
        return new ClobOutputStream(this, (int)pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException, SQLException {
        LOGGER.log(Level.INFO, "setCharacterStream");
        this.isValid();
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Invalid position in Clob object set");
        }
        return new ClobWriter(this, (int)pos);
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.isValid();
        if (length > this.len) {
            this.len = length;
            char[] btemp = new char[(int)this.len];
            btemp = Arrays.copyOf(this.buf, (int)this.len);
            this.buf = btemp;
        } else {
            this.len = length;
            this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.length() && this.length() > 0L || pos > 1L && this.length() == 0L) {
            throw new SQLException("Invalid position in Clob object set");
        }
        if (pos - 1L + length > this.length()) {
            throw new SQLException("Invalid position and substring length");
        }
        if (length < 0L) {
            throw new SQLException("Invalid length specified");
        }
        return new CharArrayReader(this.buf, (int)pos - 1, (int)length);
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
            if (this.clob != null) {
                this.clob.free();
            }
            this.clob = null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KbClob) {
            KbClob sc = (KbClob)obj;
            if (this.len == sc.len) {
                return Arrays.equals(this.buf, sc.buf);
            }
        }
        return false;
    }

    private void isValid() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("Error: You cannot call a method on a KbClob instance once free() has been called.");
        }
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

