/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBNotification;
import com.kingbase8.KBProperty;
import com.kingbase8.core.BaseQueryKey;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.CachedQueryCreateAction;
import com.kingbase8.core.CallableQueryKey;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.QueryWithReturningColumnsKey;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.Utils;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.LruCache;
import com.kingbase8.util.ServerErrorMessage;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

public abstract class QueryExecutorBase
implements QueryExecutor {
    protected final KBStream pgStream;
    private final String user;
    private final String database;
    private final int cancelSignalTimeout;
    private int cancelPid;
    private int cancelKey;
    private boolean closed = false;
    private String serverVersion;
    private int serverVersionNum = 0;
    private TransactionState transactionState;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabled;
    private final PreferQueryMode preferQueryMode;
    private AutoSave autoSave;
    private boolean flushCacheOnDeallocate = true;
    private boolean standardConformingStrings = false;
    private SQLWarning warnings;
    private final ArrayList<KBNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;

    protected QueryExecutorBase(KBStream pgStream, String user, String database, int cancelSignalTimeout, Properties info) throws SQLException {
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.cancelSignalTimeout = cancelSignalTimeout;
        this.reWriteBatchedInserts = KBProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        this.columnSanitiserDisabled = KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        String preferMode = KBProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryMode = PreferQueryMode.of(preferMode);
        this.autoSave = AutoSave.of(KBProperty.AUTOSAVE.get(info));
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) throws SQLException {
                cachedQuery.query.close();
            }
        });
    }

    protected abstract void sendCloseMessage() throws IOException;

    @Override
    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    @Override
    public int getBackendPID() {
        return this.cancelPid;
    }

    @Override
    public void abort() {
        try {
            this.pgStream.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            LOGGER.log(Level.FINEST, " FE=> Terminate");
            this.sendCloseMessage();
            this.pgStream.flush();
            this.pgStream.close();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINEST, "Discarding IOException on close:", ioe);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryCancel() throws SQLException {
        if (this.cancelPid <= 0) {
            return;
        }
        KBStream cancelStream = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, " FE=> CancelRequest(pid={0},ckey={1})", new Object[]{this.cancelPid, this.cancelKey});
            }
            cancelStream = new KBStream(this.pgStream.getSocketFactory(), this.pgStream.getHostSpec(), this.cancelSignalTimeout);
            if (this.cancelSignalTimeout > 0) {
                cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
            }
            cancelStream.sendInteger4(16);
            cancelStream.sendInteger2(1234);
            cancelStream.sendInteger2(5678);
            cancelStream.sendInteger4(this.cancelPid);
            cancelStream.sendInteger4(this.cancelKey);
            cancelStream.flush();
            cancelStream.receiveEOF();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Ignoring exception on cancel request:", e);
        }
        finally {
            if (cancelStream != null) {
                try {
                    cancelStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    public synchronized void addNotification(KBNotification notification) {
        this.notifications.add(notification);
    }

    @Override
    public synchronized KBNotification[] getNotifications() throws SQLException {
        KBNotification[] array = this.notifications.toArray(new KBNotification[this.notifications.size()]);
        this.notifications.clear();
        return array;
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public int getServerVersionNum() {
        if (this.serverVersionNum != 0) {
            return this.serverVersionNum;
        }
        this.serverVersionNum = Utils.parseServerVersionStr(this.serverVersion);
        return this.serverVersionNum;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void setServerVersionNum(int serverVersionNum) {
        this.serverVersionNum = serverVersionNum;
    }

    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        this.pgStream.setEncoding(encoding);
    }

    @Override
    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    @Override
    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    @Override
    public final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.statementCache.borrow(sql);
    }

    @Override
    public final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.statementCache.borrow(new CallableQueryKey(sql));
    }

    @Override
    public final CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(sql, true, true, columnNames));
    }

    @Override
    public CachedQuery borrowQueryByKey(Object key) throws SQLException {
        return this.statementCache.borrow(key);
    }

    @Override
    public void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    @Override
    public final Object createQueryKey(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) {
        Object key = columnNames == null || columnNames.length != 0 ? new QueryWithReturningColumnsKey(sql, isParameterized, escapeProcessing, columnNames) : (isParameterized ? sql : new BaseQueryKey(sql, false, escapeProcessing));
        return key;
    }

    @Override
    public CachedQuery createQueryByKey(Object key) throws SQLException {
        return this.cachedQueryCreateAction.create(key);
    }

    @Override
    public final CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        Object key = this.createQueryKey(sql, escapeProcessing, isParameterized, columnNames);
        return this.createQueryByKey(key);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.columnSanitiserDisabled;
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    @Override
    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    @Override
    public void setAutoSave(AutoSave autoSave) {
        this.autoSave = autoSave;
    }

    protected boolean willHealViaReparse(SQLException e) {
        if (KSQLState.INVALID_SQL_STATEMENT_NAME.getState().equals(e.getSQLState())) {
            return true;
        }
        if (!KSQLState.NOT_IMPLEMENTED.getState().equals(e.getSQLState())) {
            return false;
        }
        if (!(e instanceof KSQLException)) {
            return false;
        }
        KSQLException pe = (KSQLException)e;
        ServerErrorMessage serverErrorMessage = pe.getServerErrorMessage();
        if (serverErrorMessage == null) {
            return false;
        }
        String routine = pe.getServerErrorMessage().getRoutine();
        return "RevalidateCachedQuery".equals(routine) || "RevalidateCachedPlan".equals(routine);
    }

    @Override
    public boolean willHealOnRetry(SQLException e) {
        if (this.autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            return false;
        }
        return this.willHealViaReparse(e);
    }

    public boolean isFlushCacheOnDeallocate() {
        return this.flushCacheOnDeallocate;
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
    }
}

