/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;

public class DmdbIntervalYM
implements Serializable {
    private static final long serialVersionUID = 1952079341353118308L;
    public static final byte QUA_Y = 0;
    public static final byte QUA_YM = 1;
    public static final byte QUA_MO = 2;
    private int hF = 0;
    private boolean hO = false;
    public byte type = 0;
    public int hP = 0;
    public int hQ = 0;
    private int hN = 0;

    private DmdbIntervalYM(byte by, int n2, int n3, int n4) {
        this.type = by;
        this.hP = n2;
        this.hQ = n3;
        this.hN = n4;
        this.hF = n4 >> 4 & 0xF;
    }

    public DmdbIntervalYM(String string) {
        this.hO = false;
        this.parseIntervYMString(string);
    }

    public DmdbIntervalYM(byte[] byArray) {
        this.reset(byArray);
    }

    private void reset(byte[] byArray) {
        this.hN = ByteUtil.getInt(byArray, 8);
        this.hF = this.hN >> 4 & 0xF;
        this.type = byArray[9];
        switch (this.type) {
            case 0: {
                this.hP = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 1: {
                this.hP = ByteUtil.getInt(byArray, 0);
                this.hQ = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 2: {
                this.hQ = ByteUtil.getInt(byArray, 4);
            }
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DmdbIntervalYM) {
            DmdbIntervalYM dmdbIntervalYM = (DmdbIntervalYM)object;
            if (dmdbIntervalYM.type == this.type) {
                switch (this.type) {
                    case 0: {
                        if (this.hP != dmdbIntervalYM.hP) break;
                        return true;
                    }
                    case 1: {
                        if (this.hP != dmdbIntervalYM.hP || this.hQ != dmdbIntervalYM.hQ) break;
                        return true;
                    }
                    case 2: {
                        if (this.hQ != dmdbIntervalYM.hQ) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final int getYear() {
        return this.hP;
    }

    public final int getMonth() {
        return this.hQ;
    }

    public final byte getYMType() {
        return this.type;
    }

    public final int getLeadScale() {
        return this.hF;
    }

    public final String toString() {
        String string = "INTERVAL ";
        switch (this.type) {
            case 0: {
                String string2 = String.valueOf(Math.abs(this.hP));
                if (this.hP < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.hF > string2.length()) {
                    int n2 = string2.length();
                    int n3 = this.hF;
                    while (n3-- > n2) {
                        string2 = "0" + string2;
                    }
                }
                string = String.valueOf(string) + "'" + string2 + "' YEAR(" + this.hF + ")";
                break;
            }
            case 1: {
                String string3 = String.valueOf(Math.abs(this.hP));
                String string4 = String.valueOf(Math.abs(this.hQ));
                if (this.hP < 0 || this.hQ < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.hF > string3.length()) {
                    int n4 = string3.length();
                    int n5 = this.hF;
                    while (n5-- > n4) {
                        string3 = "0" + string3;
                    }
                }
                if (string4.length() < 2) {
                    string4 = "0" + string4;
                }
                string = String.valueOf(string) + "'" + string3 + "-" + string4 + "' YEAR(" + this.hF + ") TO MONTH";
                break;
            }
            case 2: {
                String string5 = String.valueOf(Math.abs(this.hQ));
                if (this.hQ < 0) {
                    string = String.valueOf(string) + "-";
                }
                if (this.hF > string5.length()) {
                    int n6 = string5.length();
                    int n7 = this.hF;
                    while (n7-- > n6) {
                        string5 = "0" + string5;
                    }
                }
                string = String.valueOf(string) + "'" + string5 + "' MONTH(" + this.hF + ")";
            }
        }
        return string;
    }

    public byte[] encode(int n2) {
        Object object;
        if (n2 == 0) {
            n2 = this.hN;
        }
        int n3 = this.hP;
        int n4 = this.hQ;
        this.checkScale(this.hF);
        if (n2 != this.hN) {
            object = this.convertTo(n2);
            n3 = ((DmdbIntervalYM)object).hP;
            n4 = ((DmdbIntervalYM)object).hQ;
        } else {
            this.checkScale(this.hF);
        }
        object = new byte[12];
        ByteUtil.setInt((byte[])object, 0, n3);
        ByteUtil.setInt((byte[])object, 4, n4);
        ByteUtil.setInt((byte[])object, 8, n2);
        return object;
    }

    public DmdbIntervalYM convertTo(int n2) {
        int n3 = (n2 & 0xFF00) >> 8;
        int n4 = n2 >> 4 & 0xF;
        int n5 = this.hP * 12 + this.hQ;
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 0: {
                n6 = n5 / 12;
                if (n5 % 12 >= 6) {
                    ++n6;
                } else if (n5 % 12 <= -6) {
                    --n6;
                }
                if (n4 >= String.valueOf(Math.abs(n6)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
                break;
            }
            case 1: {
                n6 = n5 / 12;
                n7 = n5 % 12;
                if (n4 >= String.valueOf(Math.abs(n6)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
                break;
            }
            case 2: {
                n7 = n5;
                if (n4 >= String.valueOf(Math.abs(n7)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
            }
        }
        return new DmdbIntervalYM((byte)n3, n6, n7, n2);
    }

    private int getLeadPrec(String string, int n2) {
        if (this.hO) {
            return this.hF;
        }
        int n3 = string.indexOf("(", n2);
        int n4 = string.indexOf(")", n2);
        int n5 = 0;
        if (n4 == -1 && n3 == -1) {
            String string2;
            int n6 = string.indexOf("'");
            int n7 = n6 != -1 ? string.indexOf("'", n6 + 1) : -1;
            String string3 = string2 = n7 != -1 ? string.substring(n6 + 1, n7).trim() : null;
            if (StringUtil.isNotEmpty(string2)) {
                int n8;
                char c2 = string2.charAt(0);
                if (c2 == '+' || c2 == '-') {
                    string2 = string2.substring(1).trim();
                }
                string2 = (n8 = string2.indexOf("-")) != -1 ? string2.substring(0, n8) : string2;
                n5 = string2.length();
            } else {
                n5 = 2;
            }
        } else if (n4 != -1 && n3 != -1 && n4 > n3 + 1) {
            String string4 = string.substring(n3 + 1, n4).trim();
            n5 = Integer.parseInt(string4);
        } else {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        return n5;
    }

    private int[] getTimeValue(String string, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            bl = true;
            string = string.substring(1, string.length() - 1).trim();
        }
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            string = string.substring(1);
        } else if (string.startsWith("+")) {
            bl2 = false;
            string = string.substring(1);
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            bl = true;
            string = string.substring(1, string.length() - 1).trim();
        }
        if (!bl) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        int n5 = string.lastIndexOf("-");
        String[] stringArray = new String[2];
        if (n5 == -1 || n5 == 0) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n5);
            stringArray[1] = string.substring(n5 + 1);
        }
        if (n2 == 1) {
            n4 = Integer.parseInt(stringArray[0]);
            n3 = stringArray[1].equalsIgnoreCase("") ? 0 : Integer.parseInt(stringArray[1]);
            if (bl2) {
                n4 *= -1;
                n3 *= -1;
            }
            if ((double)n4 > Math.pow(10.0, this.hF) - 1.0 || (double)n4 < 1.0 - Math.pow(10.0, this.hF)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
        } else if (n2 == 0) {
            n4 = Integer.parseInt(stringArray[0]);
            n3 = 0;
            if (bl2) {
                n4 *= -1;
            }
            if ((double)n4 > Math.pow(10.0, this.hF) - 1.0 || (double)n4 < 1.0 - Math.pow(10.0, this.hF)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
        } else {
            n4 = 0;
            n3 = Integer.parseInt(stringArray[0]);
            if (bl2) {
                n3 *= -1;
            }
            if ((double)n3 > Math.pow(10.0, this.hF) - 1.0 || (double)n3 < 1.0 - Math.pow(10.0, this.hF)) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
        }
        int[] nArray = new int[]{n4, n3};
        return nArray;
    }

    private void parseIntervYMString(String string) {
        String[] stringArray;
        int n2;
        if (string == null) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        if ((n2 = (stringArray = (string = string.toUpperCase()).split(" ")).length) < 3 || !stringArray[0].equalsIgnoreCase("INTERVAL") || !stringArray[2].startsWith("YEAR") && !stringArray[2].startsWith("MONTH")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
        }
        this.type = 1;
        int n3 = string.indexOf("YEAR");
        int n4 = string.indexOf("MONTH");
        int n5 = string.indexOf("TO");
        if (n5 == -1) {
            if (n3 != -1 && n4 == -1) {
                this.type = 0;
                this.hF = this.getLeadPrec(string, n3);
            } else if (n4 != -1 && n3 == -1) {
                this.type = (byte)2;
                this.hF = this.getLeadPrec(string, n4);
            } else {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
        } else {
            if (n3 == -1 || n4 == -1) {
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
            }
            this.type = 1;
            this.hF = this.getLeadPrec(string, n3);
        }
        this.hN = (this.type << 8) + (this.hF << 4);
        int[] nArray = this.getTimeValue(stringArray[1], this.type);
        this.hP = nArray[0];
        this.hQ = nArray[1];
        this.checkScale(this.hF);
    }

    private void checkScale(int n2) {
        switch (this.type) {
            case 0: {
                if (n2 >= String.valueOf(Math.abs(this.hP)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
                break;
            }
            case 1: {
                if (n2 < String.valueOf(Math.abs(this.hP)).length()) {
                    DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
                }
                if (Math.abs(this.hQ) <= 11) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(new String[0]);
                break;
            }
            case 2: {
                if (n2 >= String.valueOf(Math.abs(this.hQ)).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwException(new String[0]);
            }
        }
    }

    public int getPrecForSvr() {
        return this.hN;
    }
}

