/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.c;
import dm.jdbc.b.e;
import dm.jdbc.b.g;
import dm.jdbc.b.h;
import dm.jdbc.b.i;
import dm.jdbc.b.p;
import dm.jdbc.c.a;
import dm.jdbc.c.b;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection$1;
import dm.jdbc.driver.DmdbConnection$2;
import dm.jdbc.driver.DmdbConnection$3;
import dm.jdbc.driver.DmdbConnection$4;
import dm.jdbc.driver.DmdbConnection$5;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.Filterable;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.processor.DBAliveCheckThread;
import dm.jdbc.util.CacheMap;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbConnection
extends Filterable
implements Connection {
    public long gy = -1L;
    public String gz;
    public String gA;
    private String gx = "GB18030";
    public boolean gB = false;
    public short gC = 0;
    public int gD = 0;
    public int gE;
    public int gF;
    public int gG;
    public int gH;
    public boolean caseSensitive = true;
    public boolean gI;
    public int gJ = -1;
    public int gK = 0;
    public boolean gL = true;
    public boolean gM = true;
    public boolean gN = false;
    public boolean gO = true;
    public boolean gP = false;
    public int gQ = i.eq.getLanguage();
    public String gR;
    public String gS;
    public String gT;
    public String gU;
    public String gV;
    public String gW;
    public int gX;
    public int gY;
    public boolean dZ;
    public Map gZ = new HashMap();
    public String connection_property_url;
    public String connection_property_user;
    public String connection_property_password;
    public String connection_property_host = "localhost";
    public int connection_property_port = 5236;
    public boolean connection_property_doSwitch = false;
    public int connection_property_loginMode = 0;
    public int connection_property_loginStatus = 0;
    public boolean connection_property_loginDscCtrl = false;
    public int connection_property_switchTimes = 3;
    public int connection_property_switchInterval = 2000;
    public int connection_property_socketTimeout = 0;
    public int connection_property_connectTimeout = 5000;
    public int connection_property_sessionTimeout = 0;
    public boolean connection_property_loginEncrypt = true;
    public String connection_property_loginCertificate = null;
    public String connection_property_cipherPath = null;
    public byte connection_property_osAuthType = 0;
    public String connection_property_sslFilesPath = "";
    public String connection_property_sslKeystorePass = "";
    public String connection_property_kerberosLoginConfPath = "";
    public String connection_property_uKeyName = "";
    public String connection_property_uKeyPin = "";
    public int connection_property_compress = 0;
    public byte connection_property_compressID = 0;
    public String connection_property_sessEncode;
    public boolean connection_property_enRsCache = false;
    public int connection_property_rsCacheSize = 20;
    public int connection_property_rsRefreshFreq = 10;
    public String[] connection_property_keyWords = null;
    public boolean connection_property_dec2Double = false;
    public boolean connection_property_rwSeparate = false;
    public int connection_property_rwFilterType = 2;
    public int connection_property_rwPercent = 25;
    public boolean connection_property_rwAutoDistribute = true;
    public int connection_property_rwStandbyRecoverTime = 1000;
    public boolean connection_property_rwHA = false;
    public boolean connection_property_loadBalance = false;
    public int connection_property_loadBalancePercent = 10;
    public boolean connection_property_mppLocal = false;
    public static final int MPP_FLDR_INSERT = 1;
    public static final int MPP_FLDR_SELECT = 2;
    public int connection_property_mppOpt = 0;
    public String connection_property_appName = "";
    public String connection_property_osName = System.getProperty("os.name", "");
    public short connection_property_localTimezone = e.bd;
    public int connection_property_stmtPoolMaxSize = 15;
    public int connection_property_pstmtPoolMaxSize = 0;
    public int connection_property_pstmtPoolValidTime = 0;
    public boolean connection_property_alwayseAllowCommit = true;
    public boolean connection_property_autoCommit = true;
    public boolean connection_property_continueBatchOnError = false;
    public boolean connection_property_escapeProcess = true;
    public boolean connection_property_callBatchNot = false;
    public int connection_property_batchType = 1;
    public boolean connection_property_dbmdChkPrv = true;
    public boolean connection_property_isBdtaRS = false;
    public int connection_property_resultSetType = 1003;
    public int connection_property_maxRows = 0;
    public int connection_property_rowPrefetch = 10;
    public int connection_property_bufPrefetch = 0;
    public int connection_property_lobMode = 1;
    public int connection_property_compatibleMode = 0;
    public String connection_property_databaseProductName = "";
    public static final int COLUMN_NAME_UPPDER_CASE = 1;
    public static final int COLUMN_NAME_LOWER_CASE = 2;
    public boolean connection_property_clobAsString = false;
    public boolean connection_property_ignoreCase = true;
    public int connection_property_columnNameCase = 0;
    public int ha = 0;
    public boolean J = false;
    public static AtomicLong IDGenerator = new AtomicLong(0L);
    public h eo;
    public g hb;
    public boolean hc = false;
    private Object hd = new Object();
    private ILogger LOG = LogFactory.getLog(DmdbConnection.class);
    public a he;
    public boolean closed = true;
    public boolean hf = true;
    public boolean readOnly = false;
    public int hg = 1;
    public SQLWarning hh;
    public Map hi;
    public CacheQueue hj;
    public List hk = new ArrayList();
    public CacheMap hl;
    private static final SQLPermission hm = new SQLPermission("abort");
    private static final SQLPermission hn = new SQLPermission("setNetworkTimeout");

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public void setAttributes(h h2) {
        if (h2 == null || h2.size() == 0) {
            return;
        }
        this.connection_property_url = h2.a("url", this.connection_property_url);
        this.connection_property_host = h2.a("host", this.connection_property_host);
        this.connection_property_port = h2.a("port", this.connection_property_port, (Integer)null, (Integer)null);
        this.connection_property_user = h2.getProperty("user", this.connection_property_user);
        this.connection_property_password = h2.getProperty("password", this.connection_property_password);
        this.hc = h2.getBoolean("rwStandby", this.hc);
        this.connection_property_compress = h2.getBoolean("isCompress", false) ? 2 : this.connection_property_compress;
        this.connection_property_compress = h2.a("compress", this.connection_property_compress, 0, 2);
        this.connection_property_compressID = (byte)h2.a("compressID", this.connection_property_compressID, -1, 1);
        String string = h2.a("sessEncode", this.connection_property_sessEncode);
        if (StringUtil.isNotEmpty(string) && !Charset.isSupported(string)) {
            this.connection_property_sessEncode = null;
            this.LOG.warn(this, "setAttributes", "unsupported sessEncode:" + string);
        } else {
            this.connection_property_sessEncode = string;
        }
        this.connection_property_enRsCache = h2.getBoolean("enRsCache", this.connection_property_enRsCache);
        this.connection_property_localTimezone = (short)h2.a("localTimezone", this.connection_property_localTimezone, -720, 720);
        this.connection_property_rsCacheSize = h2.a("rsCacheSize", this.connection_property_rsCacheSize, 0, null);
        this.connection_property_rsRefreshFreq = h2.a("rsRefreshFreq", this.connection_property_rsRefreshFreq, 0, null);
        this.connection_property_loginMode = h2.a("loginMode", this.connection_property_loginMode, 0, null);
        this.connection_property_loginStatus = h2.a("loginStatus", this.connection_property_loginStatus, 0, null);
        this.connection_property_loginDscCtrl = h2.getBoolean("loginDscCtrl", this.connection_property_loginDscCtrl);
        this.connection_property_switchTimes = h2.a("switchTimes", this.connection_property_switchTimes, 0, null);
        this.connection_property_switchInterval = h2.a("switchInterval", this.connection_property_switchInterval, 0, null);
        this.connection_property_loginEncrypt = h2.getBoolean("loginEncrypt", this.connection_property_loginEncrypt);
        this.connection_property_loginCertificate = h2.a("loginCertificate", this.connection_property_loginCertificate);
        this.connection_property_dec2Double = h2.getBoolean("dec2Double", this.connection_property_dec2Double);
        this.connection_property_rwSeparate = h2.getBoolean("rwSeparate", this.connection_property_rwSeparate);
        this.connection_property_rwFilterType = h2.a("rwFilterType", this.connection_property_rwFilterType, 1, 2);
        this.connection_property_rwAutoDistribute = h2.getBoolean("rwAutoDistribute", this.connection_property_rwAutoDistribute);
        this.connection_property_rwPercent = h2.a("rwPercent", this.connection_property_rwPercent, 0, 100);
        this.connection_property_rwHA = h2.getBoolean("rwHA", this.connection_property_rwHA);
        this.connection_property_rwStandbyRecoverTime = h2.a("rwStandbyRecoverTime", this.connection_property_rwStandbyRecoverTime, 0, null);
        this.connection_property_doSwitch = h2.getBoolean("doSwitch", this.connection_property_doSwitch);
        this.connection_property_cipherPath = h2.a("cipherPath", this.connection_property_cipherPath);
        if (h2.getBoolean("comOra", false)) {
            this.connection_property_compatibleMode = 1;
        }
        this.parseCompatibleMode(h2);
        this.connection_property_loadBalance = h2.getBoolean("loadBalance", this.connection_property_loadBalance);
        this.connection_property_loadBalancePercent = h2.a("loadBalancePercent", this.connection_property_loadBalancePercent, 0, 100);
        this.connection_property_keyWords = h2.a("keyWords", this.connection_property_keyWords);
        this.connection_property_appName = h2.a("appName", this.connection_property_appName);
        this.connection_property_mppLocal = h2.getBoolean("mppLocal", this.connection_property_mppLocal);
        this.connection_property_socketTimeout = h2.a("socketTimeout", this.connection_property_socketTimeout, 0, null);
        this.connection_property_connectTimeout = h2.a("connectTimeout", this.connection_property_connectTimeout, 0, null);
        this.connection_property_sessionTimeout = h2.a("sessionTimeout", this.connection_property_sessionTimeout, 0, null);
        this.parseOsAuthType(h2);
        this.connection_property_continueBatchOnError = h2.getBoolean("continueBatchOnError", this.connection_property_continueBatchOnError);
        this.connection_property_escapeProcess = h2.getBoolean("escapeProcess", this.connection_property_escapeProcess);
        this.connection_property_autoCommit = h2.getBoolean("autoCommit", this.connection_property_autoCommit);
        this.connection_property_maxRows = h2.a("maxRows", this.connection_property_maxRows, 0, null);
        this.connection_property_rowPrefetch = h2.a("rowPrefetch", this.connection_property_rowPrefetch, 0, null);
        this.connection_property_bufPrefetch = h2.a("bufPrefetch", this.connection_property_bufPrefetch, 32, 65536);
        this.connection_property_lobMode = h2.a("LobMode", this.connection_property_lobMode, 1, 2);
        this.connection_property_stmtPoolMaxSize = h2.a("StmtPoolSize", this.connection_property_stmtPoolMaxSize, 0, null);
        this.connection_property_pstmtPoolMaxSize = h2.a("PStmtPoolSize", this.connection_property_pstmtPoolMaxSize, 0, null);
        this.connection_property_pstmtPoolMaxSize = h2.a("PStmtPoolValidTime", this.connection_property_pstmtPoolValidTime, 0, null);
        this.connection_property_ignoreCase = h2.getBoolean("ignoreCase", this.connection_property_ignoreCase);
        this.connection_property_alwayseAllowCommit = h2.getBoolean("alwayseAllowCommit", this.connection_property_alwayseAllowCommit);
        this.connection_property_batchType = h2.a("batchType", this.connection_property_batchType, 1, 2);
        this.connection_property_resultSetType = h2.a("resultSetType", this.connection_property_resultSetType, (Integer)null, (Integer)null);
        this.connection_property_dbmdChkPrv = h2.getBoolean("dbmdChkPrv", this.connection_property_dbmdChkPrv);
        this.connection_property_isBdtaRS = h2.getBoolean("isBdtaRS", this.connection_property_isBdtaRS);
        this.connection_property_clobAsString = h2.getBoolean("clobAsString", this.connection_property_clobAsString);
        this.connection_property_callBatchNot = h2.getBoolean("callBatchNot", this.connection_property_callBatchNot);
        this.connection_property_sslFilesPath = h2.a("sslFilesPath", this.connection_property_sslFilesPath);
        this.connection_property_sslKeystorePass = h2.a("sslKeystorePass", this.connection_property_sslKeystorePass);
        this.connection_property_kerberosLoginConfPath = h2.a("kerberosLoginConfPath", this.connection_property_kerberosLoginConfPath);
        this.connection_property_uKeyName = h2.a("uKeyName", this.connection_property_uKeyName);
        this.connection_property_uKeyPin = h2.a("uKeyPin", this.connection_property_uKeyPin);
        this.connection_property_columnNameCase = h2.getBoolean("columnNameUpperCase", false) ? 1 : 0;
        this.parseColumnNameCase(h2.a("columnNameCase", ""));
        this.connection_property_databaseProductName = h2.a("databaseProductName", this.connection_property_databaseProductName);
        this.ha = h2.a("bufferType", this.ha, 0, 1);
        this.hb = (g)h2.getObject("serverGroup");
        this.connection_property_mppOpt = h2.a("mppOpt", 0, (Integer)null, (Integer)null);
    }

    private void parseOsAuthType(h h2) {
        String string = h2.getProperty("osAuthType");
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "ON")) {
                this.connection_property_osAuthType = 0;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSDBA")) {
                this.connection_property_osAuthType = 1;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSAUDITOR")) {
                this.connection_property_osAuthType = (byte)3;
            } else if (StringUtil.equalsIgnoreCase(string, "SYSSSO")) {
                this.connection_property_osAuthType = (byte)2;
            } else if (StringUtil.equalsIgnoreCase(string, "AUTO")) {
                this.connection_property_osAuthType = (byte)4;
            } else if (StringUtil.equalsIgnoreCase(string, "OFF")) {
                this.connection_property_osAuthType = 0;
            }
        } else {
            this.connection_property_osAuthType = (byte)h2.a("osAuthType", this.connection_property_osAuthType, 0, 4);
        }
        if (this.connection_property_user == null && this.connection_property_osAuthType == 0) {
            this.connection_property_user = "SYSDBA";
        } else if (this.connection_property_osAuthType != 0 && StringUtil.isNotEmpty(this.connection_property_user)) {
            DBError.ECJDBC_OSAUTH_ERROR.throwException(new String[0]);
        } else if (this.connection_property_osAuthType != 0) {
            this.connection_property_user = System.getProperty("user.name", "");
            this.connection_property_password = "";
        }
    }

    private void parseCompatibleMode(h h2) {
        String string = h2.getProperty("compatibleMode");
        if (StringUtil.isNotEmpty(string) && !StringUtil.isDigit(string)) {
            if (StringUtil.equalsIgnoreCase(string, "oracle")) {
                this.connection_property_compatibleMode = 1;
            } else if (StringUtil.equalsIgnoreCase(string, "mysql")) {
                this.connection_property_compatibleMode = 2;
            }
        } else {
            this.connection_property_compatibleMode = h2.a("compatibleMode", this.connection_property_compatibleMode, 0, 2);
        }
    }

    public boolean compatibleOracle() {
        return this.connection_property_compatibleMode == 1;
    }

    public boolean compatibleMysql() {
        return this.connection_property_compatibleMode == 2;
    }

    public boolean isColumnNameUpperCase() {
        return this.connection_property_columnNameCase == 1;
    }

    public boolean isColumnNameLowerCase() {
        return this.connection_property_columnNameCase == 2;
    }

    public void parseColumnNameCase(String string) {
        if (StringUtil.equalsIgnoreCase("upper", string)) {
            this.connection_property_columnNameCase = 1;
        } else if (StringUtil.equalsIgnoreCase("lower", string)) {
            this.connection_property_columnNameCase = 2;
        }
    }

    public boolean lobFetchAll() {
        return this.connection_property_lobMode == 2;
    }

    public static int db2jIsoLevel(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    public static int j2dbIsoLevel(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return -1;
    }

    public DmdbConnection(h h2) {
        super(null, h2);
        this.eo = h2;
        this.setAttributes(h2);
        if (this.connection_property_stmtPoolMaxSize > 0) {
            this.hj = new DmdbConnection$1(this, this.connection_property_stmtPoolMaxSize, false);
        }
        if (this.connection_property_pstmtPoolMaxSize > 0) {
            this.hl = new DmdbConnection$2(this, this.connection_property_pstmtPoolMaxSize);
        }
    }

    public void openConnection() {
        try {
            this.he = this.ha == 0 ? new a(this) : new b(this);
            this.he.r();
            this.closed = false;
            this.resetClientInfo();
            DBAliveCheckThread.addConnection(this);
        }
        finally {
            if (this.closed) {
                this.free();
            }
        }
    }

    private void resetClientInfo() {
        this.eo.setProperty("ApplicationName", this.connection_property_appName);
        this.eo.setProperty("ClientUser", this.connection_property_user);
        this.eo.setProperty("ClientHostname", this.connection_property_host);
    }

    public DmdbStatement do_createStatement() {
        return this.do_createStatement(this.connection_property_resultSetType, 1007, this.hg);
    }

    public DmdbStatement do_createStatement(int n2, int n3) {
        return this.do_createStatement(n2, n3, this.hg);
    }

    public DmdbStatement do_createStatement(int n2, int n3, int n4) {
        this.checkClosed();
        DmdbStatement dmdbStatement = new DmdbStatement(this, n2, n3, n4);
        this.hk.add(dmdbStatement);
        return dmdbStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string) {
        return this.do_prepareStatement(string, this.connection_property_resultSetType, 1007, this.hg);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3) {
        return this.do_prepareStatement(string, n2, n3, this.hg);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2, n3, n4);
        this.hk.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int n2) {
        this.checkClosed();
        DmdbPreparedStatement dmdbPreparedStatement = new DmdbPreparedStatement(this, string, n2);
        this.hk.add(dmdbPreparedStatement);
        return dmdbPreparedStatement;
    }

    public DmdbPreparedStatement do_prepareStatement(String string, int[] nArray) {
        return this.do_prepareStatement(string, nArray != null && nArray.length > 0 ? 1 : 2);
    }

    public DmdbPreparedStatement do_prepareStatement(String string, String[] stringArray) {
        Object object;
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            object = null;
            try {
                object = SQLProcessor.lexSkipWhitespace(string, 2);
            }
            catch (Throwable throwable) {}
            int n2 = object == null ? 0 : object.size();
            String string3 = n2 > 0 ? ((LVal)object.get((int)0)).value : null;
            String string4 = string2 = n2 > 1 ? ((LVal)object.get((int)1)).value : null;
            if (StringUtil.equalsIgnoreCase("update", string3) || StringUtil.equals("delete", string3) || StringUtil.equalsIgnoreCase("insert", string3) && StringUtil.equalsIgnoreCase("into", string2)) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append(string);
                while (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                stringBuilder.append(" return ");
                stringBuilder.append(StringUtil.join(stringArray, ", "));
                stringBuilder.append(" into ");
                stringBuilder.append(StringUtil.join("?", stringArray.length, ", "));
                string = stringBuilder.toString();
            }
        }
        object = this.do_prepareStatement(string, stringArray != null && stringArray.length > 0 ? 1 : 2);
        ((DmdbPreparedStatement)object).iz = stringArray;
        return object;
    }

    public DmdbCallableStatement do_prepareCall(String string) {
        return this.do_prepareCall(string, 1003, 1007, this.hg);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3) {
        return this.do_prepareCall(string, n2, n3, this.hg);
    }

    public DmdbCallableStatement do_prepareCall(String string, int n2, int n3, int n4) {
        this.checkClosed();
        DmdbCallableStatement dmdbCallableStatement = new DmdbCallableStatement(this, string, n2, n3, n4);
        this.hk.add(dmdbCallableStatement);
        return dmdbCallableStatement;
    }

    public String do_nativeSQL(String string) {
        try {
            return SQLProcessor.escape(string, this.connection_property_keyWords);
        }
        catch (IOException iOException) {
            DBError.throwException("Sql escape error!", iOException);
            return string;
        }
    }

    public void do_commit() {
        this.checkClosed();
        if (!this.connection_property_autoCommit) {
            this.he.commit();
            this.gL = true;
        } else if (!this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_COMMIT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
    }

    public void do_rollback() {
        this.checkClosed();
        if (!this.connection_property_autoCommit) {
            this.he.rollback();
            this.gL = true;
        } else if (!this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_ROLLBACK_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Object object = this.hd;
        synchronized (object) {
            if (this.he != null) {
                this.he.close();
            }
            this.closed = true;
            if (this.hk != null) {
                for (DmdbStatement dmdbStatement : this.hk) {
                    dmdbStatement.free();
                }
            }
            if (this.hj != null) {
                this.hj.clear();
            }
            if (this.hl != null) {
                this.hl.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_close() {
        Object object = this.hd;
        synchronized (object) {
            if (this.compatibleOracle() && !this.closed) {
                this.do_commit();
            }
            this.free();
            if (this.hk != null) {
                this.hk.clear();
            }
            this.closed = true;
        }
    }

    public void checkClosed() {
        if (this.closed) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwException(new String[0]);
        }
    }

    public DmdbDatabaseMetaData do_getMetaData() {
        this.checkClosed();
        return new DmdbDatabaseMetaData(this);
    }

    public void do_setTransactionIsolation(int n2) {
        this.checkClosed();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.he.setTransactionIsolation(n2);
                this.gJ = n2;
                break;
            }
            case 4: {
                if (!this.compatibleMysql()) break;
                n2 = 2;
                this.he.setTransactionIsolation(n2);
                this.gJ = n2;
                break;
            }
            default: {
                DBError.ECJDBC_INVALID_TRAN_ISOLATION.throwException(new String[0]);
            }
        }
    }

    public void addSQLWarning(SQLWarning sQLWarning) {
        if (this.hh == sQLWarning) {
            return;
        }
        if (this.hh == null) {
            this.hh = sQLWarning;
        } else {
            this.hh.setNextWarning(sQLWarning);
        }
    }

    public void do_clearWarnings() {
        this.hh = null;
    }

    public DmdbSavepoint do_setSavepoint() {
        return this.do_setSavepoint(null);
    }

    public DmdbSavepoint do_setSavepoint(String string) {
        this.checkClosed();
        if (this.connection_property_autoCommit) {
            DBError.ECJDBC_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        return new DmdbSavepoint(this, string);
    }

    public void do_rollback(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwException(new String[0]);
        }
        if (this.connection_property_autoCommit && !this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_ROLLBACK_TO_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        DmdbSavepoint dmdbSavepoint = (DmdbSavepoint)savepoint;
        if (dmdbSavepoint.kg) {
            DBError.ECJDBC_SAVEPOINT_RELEASED.throwException(new String[0]);
        }
        String string = "ROLLBACK TO SAVEPOINT \"" + StringUtil.processDoubleQuoteOfName(dmdbSavepoint.name) + "\"";
        DriverUtil.execute(this, string);
    }

    public void do_releaseSavepoint(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            DBError.ECJDBC_INVALID_SAVEPOINT.throwException(new String[0]);
        }
        if (this.connection_property_autoCommit && !this.connection_property_alwayseAllowCommit) {
            DBError.ECJDBC_RELEASE_SAVEPOINT_IN_AUTOCOMMIT_MODE.throwException(new String[0]);
        }
        ((DmdbSavepoint)savepoint).release();
    }

    public DmdbClob do_createClob() {
        this.checkClosed();
        return DmdbClob.newInstance("", this);
    }

    public DmdbBlob do_createBlob() {
        this.checkClosed();
        return DmdbBlob.newInstanceOfLocal(new byte[0], this);
    }

    public boolean do_isValid(int n2) {
        if (this.do_isClosed()) {
            return false;
        }
        if (n2 <= 0) {
            try {
                DriverUtil.execute(this, "select 1 from dual");
                this.hf = true;
            }
            catch (Throwable throwable) {
                this.hf = false;
            }
        } else {
            try {
                Thread thread = new Thread(new DmdbConnection$3(this));
                thread.start();
                thread.join(n2 * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.hf;
    }

    public void do_setClientInfo(String string, String string2) {
        this.eo.setProperty(string, string2);
    }

    public void do_setClientInfo(Properties properties) {
        this.eo.setProperties(properties);
    }

    public String do_getClientInfo(String string) {
        return this.eo.getProperty(string);
    }

    public Properties do_getClientInfo() {
        return this.eo.getProperties();
    }

    public DmdbArray do_createArrayOf(String string, Object[] objectArray) {
        this.checkClosed();
        c c2 = new c(string, this);
        return new DmdbArray(c2, this, objectArray);
    }

    public DmdbStruct do_createStruct(String string, Object[] objectArray) {
        this.checkClosed();
        p p2 = new p(string, this);
        return new DmdbStruct(p2, this, objectArray);
    }

    public void do_setAutoCommit(boolean bl) {
        this.connection_property_autoCommit = bl;
    }

    public boolean do_getAutoCommit() {
        return this.connection_property_autoCommit;
    }

    public boolean do_isClosed() {
        return this.closed;
    }

    public void do_setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean do_isReadOnly() {
        return this.readOnly;
    }

    public void do_setCatalog(String string) {
    }

    public String do_getCatalog() {
        return null;
    }

    public int do_getTransactionIsolation() {
        return this.gJ;
    }

    public SQLWarning do_getWarnings() {
        return this.hh;
    }

    public Map do_getTypeMap() {
        return this.hi;
    }

    public void do_setTypeMap(Map map) {
        this.hi = map;
    }

    public void do_setHoldability(int n2) {
        this.hg = n2;
    }

    public int do_getHoldability() {
        return this.hg;
    }

    public NClob do_createNClob() {
        this.checkClosed();
        return DmdbNClob.newInstance("", this);
    }

    public SQLXML do_createSQLXML() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public void do_setSchema(String string) {
        if (StringUtil.isNotEmpty(string)) {
            DriverUtil.execute(this, "set schema " + string);
        }
    }

    public String do_getSchema() {
        return this.gz;
    }

    public void do_abort(Executor executor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(hm);
        }
        if (executor == null) {
            try {
                this.free();
            }
            catch (Exception exception) {
                DBError.throwRuntimeException("Abort failed!", exception);
            }
        } else {
            executor.execute(new DmdbConnection$4(this));
        }
    }

    public void do_setNetworkTimeout(Executor executor, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(hn);
        }
        if (executor == null) {
            DBError.throwException("Executor can not be null", 0);
        }
        executor.execute(new DmdbConnection$5(this, n2));
    }

    public int do_getNetworkTimeout() {
        return this.connection_property_socketTimeout;
    }

    public void setTrxFinish(int n2) {
        switch (n2 & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.gL = true;
                break;
            }
            default: {
                this.gL = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement();
            }
            return this.filterChain.reset().Connection_createStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_nativeSQL(string);
            }
            return this.filterChain.reset().Connection_nativeSQL(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setAutoCommit(bl);
            } else {
                this.filterChain.reset().Connection_setAutoCommit(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAutoCommit();
            }
            return this.filterChain.reset().Connection_getAutoCommit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_commit();
            } else {
                this.filterChain.reset().Connection_commit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback();
            } else {
                this.filterChain.reset().Connection_rollback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_close();
            } else {
                this.filterChain.reset().Connection_close(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        if (this.filterChain == null) {
            return this.do_isClosed();
        }
        return this.filterChain.reset().Connection_isClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getMetaData();
            }
            return this.filterChain.reset().Connection_getMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setReadOnly(bl);
            } else {
                this.filterChain.reset().Connection_setReadOnly(this, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isReadOnly();
            }
            return this.filterChain.reset().Connection_isReadOnly(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setCatalog(string);
            } else {
                this.filterChain.reset().Connection_setCatalog(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalog();
            }
            return this.filterChain.reset().Connection_getCatalog(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setTransactionIsolation(n2);
            } else {
                this.filterChain.reset().Connection_setTransactionIsolation(this, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTransactionIsolation();
            }
            return this.filterChain.reset().Connection_getTransactionIsolation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getWarnings();
            }
            return this.filterChain.reset().Connection_getWarnings(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_clearWarnings();
            } else {
                this.filterChain.reset().Connection_clearWarnings(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3);
        }
    }

    public Map getTypeMap() {
        if (this.filterChain == null) {
            return this.do_getTypeMap();
        }
        return this.filterChain.reset().Connection_getTypeMap(this);
    }

    public void setTypeMap(Map map) {
        if (this.filterChain == null) {
            this.do_setTypeMap(map);
        } else {
            this.filterChain.reset().Connection_setTypeMap(this, map);
        }
    }

    @Override
    public void setHoldability(int n2) {
        if (this.filterChain == null) {
            this.do_setHoldability(n2);
        } else {
            this.filterChain.reset().Connection_setHoldability(this, n2);
        }
    }

    @Override
    public int getHoldability() {
        if (this.filterChain == null) {
            return this.do_getHoldability();
        }
        return this.filterChain.reset().Connection_getHoldability(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint();
            }
            return this.filterChain.reset().Connection_setSavepoint(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setSavepoint(string);
            }
            return this.filterChain.reset().Connection_setSavepoint(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_rollback(savepoint);
            } else {
                this.filterChain.reset().Connection_rollback(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_releaseSavepoint(savepoint);
            } else {
                this.filterChain.reset().Connection_releaseSavepoint(this, savepoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStatement(n2, n3, n4);
            }
            return this.filterChain.reset().Connection_createStatement(this, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareCall(string, n2, n3, n4);
            }
            return this.filterChain.reset().Connection_prepareCall(this, string, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, n2);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, nArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_prepareStatement(string, stringArray);
            }
            return this.filterChain.reset().Connection_prepareStatement(this, string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createClob();
            }
            return this.filterChain.reset().Connection_createClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createBlob();
            }
            return this.filterChain.reset().Connection_createBlob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createNClob();
            }
            return this.filterChain.reset().Connection_createNClob(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML createSQLXML() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createSQLXML();
            }
            return this.filterChain.reset().Connection_createSQLXML(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_isValid(n2);
            }
            return this.filterChain.reset().Connection_isValid(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String string, String string2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(string, string2);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setClientInfo(properties);
            } else {
                this.filterChain.reset().Connection_setClientInfo(this, properties);
            }
        }
    }

    @Override
    public String getClientInfo(String string) {
        if (this.filterChain == null) {
            return this.do_getClientInfo(string);
        }
        return this.filterChain.reset().Connection_getClientInfo(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfo();
            }
            return this.filterChain.reset().Connection_getClientInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createArrayOf(string, objectArray);
            }
            return this.filterChain.reset().Connection_createArrayOf(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_createStruct(string, objectArray);
            }
            return this.filterChain.reset().Connection_createStruct(this, string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setSchema(string);
            } else {
                this.filterChain.reset().Connection_setSchema(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchema();
            }
            return this.filterChain.reset().Connection_getSchema(this);
        }
    }

    @Override
    public void abort(Executor executor) {
        if (this.filterChain == null) {
            this.do_abort(executor);
        } else {
            this.filterChain.reset().Connection_abort(this, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_setNetworkTimeout(executor, n2);
            } else {
                this.filterChain.reset().Connection_setNetworkTimeout(this, executor, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNetworkTimeout() {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getNetworkTimeout();
            }
            return this.filterChain.reset().Connection_getNetworkTimeout(this);
        }
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionTrace(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainInfo(String string) {
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (StringUtil.isEmpty(string)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
            }
            if (!string.equalsIgnoreCase("show_pln_stat")) {
                string = "EXPLAIN " + string;
            }
            return DriverUtil.executeAndGetExplain(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_reconnect() {
        this.free();
        DmdbConnection dmdbConnection = this;
        synchronized (dmdbConnection) {
            if (this.hb != null) {
                this.hb.a(this);
            } else {
                this.openConnection();
            }
            ArrayList<DmdbStatement> arrayList = new ArrayList<DmdbStatement>(this.hk.size());
            for (DmdbStatement dmdbStatement : this.hk) {
                try {
                    dmdbStatement.reconnect();
                }
                catch (Throwable throwable) {
                    dmdbStatement.ku = false;
                    arrayList.add(dmdbStatement);
                }
            }
            for (DmdbStatement dmdbStatement : arrayList) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void reconnect() {
        FilterChain filterChain = this.createFilterChain(this, this.eo);
        if (filterChain == null) {
            this.do_reconnect();
        } else {
            filterChain.reset().Connection_reconnect(this);
        }
    }

    public short getDBTimeZone() {
        return this.gC;
    }

    public String getHostName() {
        return this.connection_property_host;
    }

    public int getHostPort() {
        return this.connection_property_port;
    }

    public boolean getTransFinish() {
        return this.gL;
    }

    public String getLastLoginIP() {
        return (String)this.nonStandardInterface("lastLoginIP");
    }

    public String getLastLoginTime() {
        return (String)this.nonStandardInterface("lastLoginTime");
    }

    public int getLoginWarningID() {
        return (Integer)this.nonStandardInterface("loginWarningID");
    }

    public int getGraceTimeRemainder() {
        return (Integer)this.nonStandardInterface("GraceTimeRemainder");
    }

    public int getFailedAttempt() {
        return (Integer)this.nonStandardInterface("failedAttempts");
    }

    public boolean getNetworkEncypted() {
        return this.gD == 1;
    }

    public int getNetworkPacketSize() {
        return this.he != null ? this.he.kZ : 0;
    }

    public int getConnectTimeout() {
        return this.connection_property_connectTimeout;
    }

    public int getLanguage() {
        return i.eq.getLanguage();
    }

    public boolean getBackslashEsc() {
        return (Boolean)this.nonStandardInterface("backslashEscape");
    }

    public int getGlobalServerSeries() {
        return (Integer)this.nonStandardInterface("globalServerSeries");
    }

    public int getEncryptMsg() {
        return this.gD;
    }

    public boolean getEscape() {
        return this.connection_property_escapeProcess;
    }

    public void setEscape(boolean bl) {
        this.connection_property_escapeProcess = bl;
    }

    public void setEscape(Boolean bl) {
        this.connection_property_escapeProcess = bl;
    }

    public void setDbmdChkPrivileges(boolean bl) {
        this.connection_property_dbmdChkPrv = bl;
    }

    public boolean getDbmdChkPrivileges() {
        return this.connection_property_dbmdChkPrv;
    }

    public void reset() {
        this.reconnect();
    }

    public void do_reset() {
        this.checkClosed();
        if (this.gy != -1L) {
            DriverUtil.executeWithNewConnection(this, "SP_CANCEL_SESSION_OPERATION(" + this.gy + ")");
        }
    }

    public String getServerEncoding() {
        if (StringUtil.isNotEmpty(this.connection_property_sessEncode)) {
            return this.connection_property_sessEncode;
        }
        return this.gx;
    }

    public void setServerEncoding(String string) {
        this.gx = string;
    }

    public Object nonStandardInterface(String string) {
        if (string == null) {
            return null;
        }
        return this.gZ.get(string.toLowerCase());
    }

    public void setInfo(String string, Object object) {
        this.gZ.put(string.toLowerCase(), object);
    }

    public int getLoginStatus() {
        return this.connection_property_rwSeparate ? 4 : this.connection_property_loginStatus;
    }

    public boolean isMppFldrInsertEnable() {
        return (this.connection_property_mppOpt & 1) != 0;
    }

    public boolean isMppFldrSelectEnable() {
        return (this.connection_property_mppOpt & 2) != 0;
    }
}

