/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.a.a;
import dm.jdbc.b.d;
import dm.jdbc.b.q;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbConnection;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DmdbArrayDataResultSet
implements ResultSet {
    private DmdbArray gp = null;
    private long gq = 1L;
    private int gr = 0;
    private int gs = (int)(this.gq - 1L);
    private boolean gt = false;
    private boolean gu = false;
    private int ad = 1000;
    private int ae = -1;
    private DmdbConnection fw = null;

    public DmdbArrayDataResultSet(DmdbArray dmdbArray) {
        this.gp = dmdbArray;
        this.gr = this.gp.gi.length;
        this.gq = 1L;
        this.gs = (int)(this.gq - 1L);
        this.fw = this.gp.gh.d().fw;
    }

    public DmdbArrayDataResultSet(DmdbArray dmdbArray, long l2, int n2) {
        this(dmdbArray);
        this.gq = l2;
        this.gr = this.gr < n2 ? this.gr : n2;
        this.gs = (int)(this.gq - 1L);
    }

    private void checkClose() {
        if (this.gt) {
            DBError.ECJDBC_RESULTSET_CLOSED.throwException(new String[0]);
        }
    }

    private void checkCurrentRow() {
        this.checkClose();
        if ((long)this.gs < this.gq && this.gs > this.gr) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwException(new String[0]);
        }
    }

    private boolean checkIsNull(q q2) {
        this.gu = q2.fD == null && q2.fA == null;
        return this.gu;
    }

    private void release() {
        this.gp = null;
        this.gr = 0;
        this.gq = 1L;
        this.gt = true;
    }

    private void checkUpdatable() {
        DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwException(new String[0]);
    }

    @Override
    public boolean next() {
        this.checkClose();
        if (this.gr > this.gs) {
            ++this.gs;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.gt) {
            return;
        }
        this.release();
    }

    @Override
    public boolean wasNull() {
        return this.gu;
    }

    @Override
    public String getString(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof String) {
            return (String)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.d(q2.fD, d2, this.fw);
    }

    @Override
    public boolean getBoolean(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return false;
        }
        if (q2.fA instanceof Boolean) {
            return (Boolean)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.e(q2.fD, d2, this.fw);
    }

    @Override
    public byte getByte(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0;
        }
        if (q2.fA instanceof Byte) {
            return (Byte)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.f(q2.fD, d2, this.fw);
    }

    @Override
    public short getShort(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0;
        }
        if (q2.fA instanceof Short) {
            return (Short)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.g(q2.fD, d2, this.fw);
    }

    @Override
    public int getInt(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0;
        }
        if (q2.fA instanceof Integer) {
            return (Integer)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.h(q2.fD, d2, this.fw);
    }

    @Override
    public long getLong(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0L;
        }
        if (q2.fA instanceof Long) {
            return (Long)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.i(q2.fD, d2, this.fw);
    }

    @Override
    public float getFloat(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0.0f;
        }
        if (q2.fA instanceof Float) {
            return ((Float)q2.fA).longValue();
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.j(q2.fD, d2, this.fw);
    }

    @Override
    public double getDouble(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return 0.0;
        }
        if (q2.fA instanceof Double) {
            return (Double)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.k(q2.fD, d2, this.fw);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n3, 4);
    }

    @Override
    public byte[] getBytes(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof byte[]) {
            return (byte[])q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.m(q2.fD, d2, this.fw);
    }

    @Override
    public Date getDate(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof Date) {
            return (Date)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.a(q2.fD, d2, this.fw, null);
    }

    @Override
    public Time getTime(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof Time) {
            return (Time)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.b(q2.fD, d2, this.fw, null);
    }

    @Override
    public Timestamp getTimestamp(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof Timestamp) {
            return (Timestamp)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.c(q2.fD, d2, this.fw, null);
    }

    @Override
    public InputStream getAsciiStream(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.o(q2.fD, d2, this.fw);
    }

    @Override
    public InputStream getUnicodeStream(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.p(q2.fD, d2, this.fw);
    }

    @Override
    public InputStream getBinaryStream(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.q(q2.fD, d2, this.fw);
    }

    @Override
    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void clearWarnings() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public String getCursorName() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Object getObject(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        return q2.fA;
    }

    @Override
    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return 0;
    }

    @Override
    public Reader getCharacterStream(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.r(q2.fD, d2, this.fw);
    }

    @Override
    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof BigDecimal) {
            return (BigDecimal)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.l(q2.fD, d2, this.fw);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() {
        return this.gs + 1 <= 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.gs + 1 > this.gr;
    }

    @Override
    public boolean isFirst() {
        return this.gs + 1 == 1;
    }

    @Override
    public boolean isLast() {
        return this.gs + 1 == this.gr;
    }

    @Override
    public void beforeFirst() {
        this.checkClose();
        if (this.gr <= 0) {
            return;
        }
        this.gs = -1;
    }

    @Override
    public void afterLast() {
        this.checkClose();
        if (this.gr <= 0) {
            return;
        }
        this.gs = this.gr;
    }

    @Override
    public boolean first() {
        this.checkClose();
        if (this.gr > 0) {
            this.gs = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() {
        this.checkClose();
        if (this.gr > 0) {
            this.gs = this.gr - 1;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() {
        return this.gs + 1;
    }

    @Override
    public boolean absolute(int n2) {
        this.checkClose();
        if (Math.abs(n2) > this.gr || n2 == 0) {
            return false;
        }
        if (n2 < 0) {
            this.gs = n2 + this.gr;
            return true;
        }
        this.gs = n2 - 1;
        return true;
    }

    @Override
    public boolean relative(int n2) {
        this.checkClose();
        if (n2 == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        int n3 = this.gs + n2;
        if (n3 + 1 > this.gr || n3 + 1 < 1) {
            return false;
        }
        this.gs = n3;
        return true;
    }

    @Override
    public boolean previous() {
        this.checkClose();
        int n2 = this.gs - 1;
        if (n2 < 0 || n2 >= this.gr) {
            return false;
        }
        this.gs = n2;
        return true;
    }

    @Override
    public void setFetchDirection(int n2) {
        this.ad = n2;
    }

    @Override
    public int getFetchDirection() {
        return this.ad;
    }

    @Override
    public void setFetchSize(int n2) {
        this.ae = n2;
    }

    @Override
    public int getFetchSize() {
        return this.ae;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public boolean rowUpdated() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowInserted() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowDeleted() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public void updateNull(int n2) {
        this.checkUpdatable();
    }

    @Override
    public void updateBoolean(int n2, boolean bl) {
        this.checkUpdatable();
    }

    @Override
    public void updateByte(int n2, byte by) {
        this.checkUpdatable();
    }

    @Override
    public void updateShort(int n2, short s2) {
        this.checkUpdatable();
    }

    @Override
    public void updateInt(int n2, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateLong(int n2, long l2) {
        this.checkUpdatable();
    }

    @Override
    public void updateFloat(int n2, float f2) {
        this.checkUpdatable();
    }

    @Override
    public void updateDouble(int n2, double d2) {
        this.checkUpdatable();
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) {
        this.checkUpdatable();
    }

    @Override
    public void updateString(int n2, String string) {
        this.checkUpdatable();
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) {
        this.checkUpdatable();
    }

    @Override
    public void updateDate(int n2, Date date) {
        this.checkUpdatable();
    }

    @Override
    public void updateTime(int n2, Time time) {
        this.checkUpdatable();
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) {
        this.checkUpdatable();
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int n2, Object object, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int n2, Object object) {
        this.checkUpdatable();
    }

    @Override
    public void updateNull(String string) {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) {
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() {
        this.checkUpdatable();
    }

    @Override
    public void updateRow() {
        this.checkUpdatable();
    }

    @Override
    public void deleteRow() {
        this.checkUpdatable();
    }

    @Override
    public void refreshRow() {
        this.checkUpdatable();
    }

    @Override
    public void cancelRowUpdates() {
        this.checkUpdatable();
    }

    @Override
    public void moveToInsertRow() {
        this.checkUpdatable();
    }

    @Override
    public void moveToCurrentRow() {
        this.checkUpdatable();
    }

    @Override
    public Statement getStatement() {
        this.checkUpdatable();
        return null;
    }

    public Object getObject(int n2, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Ref getRef(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Blob getBlob(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof Blob) {
            return (Blob)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.s(q2.fD, d2, this.fw);
    }

    @Override
    public Clob getClob(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof Clob) {
            return (Clob)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.t(q2.fD, d2, this.fw);
    }

    @Override
    public Array getArray(int n2) {
        this.checkCurrentRow();
        q q2 = this.gp.getData(this.gs, n2, null);
        if (this.checkIsNull(q2)) {
            return null;
        }
        if (q2.fA instanceof DmdbArray) {
            return (Array)q2.fA;
        }
        d d2 = this.gp.getDataDesc(this.gs, n2);
        return a.u(q2.fD, d2, this.fw);
    }

    public Object getObject(String string, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Ref getRef(String string) {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) {
        Date date = this.getDate(n2);
        if (date == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(date);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) {
        Time time = this.getTime(n2);
        if (time == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        return new Time(calendar.getTimeInMillis());
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        Timestamp timestamp = this.getTimestamp(n2);
        if (timestamp == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public URL getURL(String string) {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public void updateRef(int n2, Ref ref) {
        this.checkUpdatable();
    }

    @Override
    public void updateRef(String string, Ref ref) {
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) {
        this.checkUpdatable();
    }

    @Override
    public void updateBlob(String string, Blob blob) {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) {
        this.checkUpdatable();
    }

    @Override
    public void updateClob(String string, Clob clob) {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateArray(int n2, Array array) {
        this.checkUpdatable();
    }

    @Override
    public void updateArray(String string, Array array) {
        this.updateArray(this.findColumn(string), array);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public RowId getRowId(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public RowId getRowId(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void updateRowId(int n2, RowId rowId) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public int getHoldability() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return this.fw.hg;
    }

    @Override
    public boolean isClosed() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return false;
    }

    @Override
    public void updateNString(int n2, String string) {
        this.updateString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n2) {
        return (NClob)this.getClob(n2);
    }

    @Override
    public NClob getNClob(String string) {
        return (NClob)this.getClob(string);
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public String getNString(int n2) {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        return this.getCharacterStream(string);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) {
        this.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) {
        this.updateClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) {
        this.updateClob(string, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateClob(int n2, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateClob(String string, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    @Override
    public void updateNClob(int n2, Reader reader) {
        this.updateClob(n2, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        this.updateClob(string, reader);
    }

    public Object getObject(int n2, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public Object getObject(String string, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }
}

