/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bbs.plad;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.StringTokenizer;

public final class StringUtil {
    private static final NumberFormat N_FORMAT = NumberFormat.getInstance();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DIGITS_0 = 48;
    private static final int DIGITS_A = 65;
    private static final int DIGITSA9 = 7;
    private static boolean[] dontNeedEncoding = new boolean[256];

    static {
        int i = 0;
        while (i < 256) {
            StringUtil.dontNeedEncoding[i] = false;
            ++i;
        }
        i = 97;
        while (i <= 122) {
            StringUtil.dontNeedEncoding[i] = true;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            StringUtil.dontNeedEncoding[i] = true;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            StringUtil.dontNeedEncoding[i] = true;
            ++i;
        }
        StringUtil.dontNeedEncoding[32] = true;
        StringUtil.dontNeedEncoding[45] = true;
        StringUtil.dontNeedEncoding[95] = true;
        StringUtil.dontNeedEncoding[46] = true;
        StringUtil.dontNeedEncoding[42] = true;
    }

    private StringUtil() {
    }

    public static String byte2hex(int j) {
        char[] buff = new char[]{DIGITS[j >>> 4 & 0xF], DIGITS[j & 0xF]};
        return new String(buff, 0, 2);
    }

    public static final String bytesToHex(byte[] buf, int off, int len) {
        char[] out = new char[len * 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            byte a = buf[off++];
            out[j++] = DIGITS[a >>> 4 & 0xF];
            out[j++] = DIGITS[a & 0xF];
            ++i;
        }
        return new String(out);
    }

    public static String escapeHtml(String strSRC) {
        if (strSRC == null) {
            return null;
        }
        int cLast = 0;
        char[] buff = strSRC.toCharArray();
        StringBuffer sb = new StringBuffer(buff.length + 100);
        int j = 0;
        while (j < buff.length) {
            int c = buff[j];
            switch (c) {
                case 13: {
                    if (j + 1 >= buff.length || buff[j + 1] != '\n') break;
                    sb.append("<br>\r\n");
                    ++j;
                    break;
                }
                case 32: {
                    if (cLast == 32) {
                        sb.append("&nbsp;");
                        break;
                    }
                    sb.append(' ');
                    break;
                }
                case 60: {
                    sb.append("&lt;");
                    break;
                }
                case 62: {
                    sb.append("&gt;");
                    break;
                }
                case 34: {
                    sb.append("&quot;");
                    break;
                }
                case 38: {
                    sb.append("&amp;");
                    break;
                }
                case 165: {
                    sb.append("&yen;");
                    break;
                }
                case 169: {
                    sb.append("&copy;");
                    break;
                }
                case 174: {
                    sb.append("&reg;");
                    break;
                }
                default: {
                    sb.append((char)c);
                }
            }
            cLast = c;
            ++j;
        }
        return sb.toString();
    }

    public static String escapeHtmlCR(String strSRC) {
        if (strSRC == null) {
            return null;
        }
        char[] buff = strSRC.toCharArray();
        StringBuffer sb = new StringBuffer(buff.length + 20);
        int j = 0;
        while (j < buff.length) {
            char c = buff[j];
            if (c == '\n') {
                sb.append("<br>");
            }
            sb.append(c);
            ++j;
        }
        return sb.toString();
    }

    public static String escapeHtmlTag(String strSRC) {
        if (strSRC == null) {
            return null;
        }
        char[] buff = strSRC.toCharArray();
        StringBuffer sb = new StringBuffer(buff.length + 20);
        int j = 0;
        while (j < buff.length) {
            char c = buff[j];
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++j;
        }
        return sb.toString();
    }

    public static String formatNumber(int i) {
        return N_FORMAT.format(i);
    }

    public static String getCurrentTime() {
        Calendar cal = Calendar.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append(cal.get(1));
        sb.append('-');
        sb.append(cal.get(2) + 1);
        sb.append('-');
        sb.append(cal.get(5));
        sb.append(' ');
        sb.append(cal.get(11));
        sb.append(':');
        sb.append(cal.get(12));
        sb.append(':');
        sb.append(cal.get(13));
        return sb.toString();
    }

    public static String getMilitaryRank(int i) {
        if (i < 100) {
            return "\u5217\u5175";
        }
        if (i < 200) {
            return "\u4e0a\u7b49\u5175";
        }
        if (i < 500) {
            return "\u4e0b\u58eb";
        }
        if (i < 1000) {
            return "\u4e2d\u58eb";
        }
        if (i < 2000) {
            return "\u4e0a\u58eb";
        }
        if (i < 4000) {
            return "\u4e13\u4e1a\u519b\u58eb";
        }
        if (i < 6000) {
            return "\u519b\u58eb\u957f";
        }
        if (i < 10000) {
            return "\u5c11\u5c09";
        }
        if (i < 15000) {
            return "\u4e2d\u5c09";
        }
        if (i < 20000) {
            return "\u4e0a\u5c09";
        }
        if (i < 25000) {
            return "\u5c11\u6821";
        }
        if (i < 30000) {
            return "\u4e2d\u6821";
        }
        if (i < 35000) {
            return "\u4e0a\u6821";
        }
        if (i < 45000) {
            return "\u5927\u6821";
        }
        if (i < 60000) {
            return "\u5c11\u5c06";
        }
        if (i < 80000) {
            return "\u4e2d\u5c06";
        }
        if (i < 100000) {
            return "\u4e0a\u5c06";
        }
        return "\u4e00\u7ea7\u4e0a\u5c06";
    }

    public static String getNotNULL(String str) {
        return str == null ? "" : str;
    }

    public static final String getSelected(int i, int j) {
        return i == j ? "selected" : "";
    }

    public static final String getSelected(String s1, String s2) {
        return s1 != null && s1.equals(s2) ? "selected" : "";
    }

    public static String getPathIDs(String strPath) {
        if (strPath == null) {
            return null;
        }
        char[] buff = strPath.toCharArray();
        int i = 0;
        int j = 0;
        char c = '\u0000';
        while (i < buff.length) {
            c = buff[i];
            if (c == '/') {
                if (j > 0 && buff[j - 1] != ',') {
                    buff[j++] = 44;
                }
            } else if (c >= '0' && c <= '9') {
                buff[j++] = c;
            }
            ++i;
        }
        if (j > 0 && buff[j - 1] == ',') {
            --j;
        }
        String strResult = new String(buff, 0, j);
        return strResult;
    }

    public static int hex2int(String s) {
        int iResult = 0;
        int iLength = s.length() < 8 ? s.length() : 8;
        int iTemp = 0;
        int i = 0;
        while (i < iLength) {
            iTemp = s.charAt(i) - 48;
            if (iTemp > 9) {
                iTemp -= 7;
            }
            iResult <<= 4;
            iResult |= (iTemp &= 0xF);
            ++i;
        }
        return iResult;
    }

    public static int hex2short(String s) {
        int iResult = 0;
        int iLength = s.length() < 4 ? s.length() : 4;
        int iTemp = 0;
        int i = 0;
        while (i < iLength) {
            iTemp = s.charAt(i) - 48;
            if (iTemp > 9) {
                iTemp -= 7;
            }
            iResult <<= 4;
            iResult |= (iTemp &= 0xF);
            ++i;
        }
        return iResult;
    }

    public static String id2file(int iBookID) {
        char[] buff = new char[]{File.separatorChar, DIGITS[iBookID >>> 20 & 0xF], DIGITS[iBookID >>> 16 & 0xF], File.separatorChar, DIGITS[iBookID >>> 12 & 0xF], DIGITS[iBookID >>> 8 & 0xF], File.separatorChar, DIGITS[iBookID >>> 4 & 0xF], DIGITS[iBookID & 0xF]};
        return new String(buff, 0, 9);
    }

    public static String id2path(int iBookID) {
        char[] buff = new char[]{File.separatorChar, DIGITS[iBookID >>> 20 & 0xF], DIGITS[iBookID >>> 16 & 0xF], File.separatorChar, DIGITS[iBookID >>> 12 & 0xF], DIGITS[iBookID >>> 8 & 0xF]};
        return new String(buff, 0, 6);
    }

    public static String int2hex(int j) {
        char[] buf = new char[8];
        int i = buf.length - 1;
        while (i >= 0) {
            buf[i] = DIGITS[j & 0xF];
            j >>>= 4;
            --i;
        }
        return new String(buf);
    }

    public static int parseInt(String strVal) {
        try {
            return Integer.parseInt(strVal);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static long ip2number(String strIP) {
        StringTokenizer st;
        if (strIP != null && (st = new StringTokenizer(strIP, ".")).countTokens() == 4) {
            long lResultIP = 0L;
            while (st.hasMoreTokens()) {
                int iToken = 0;
                try {
                    iToken = Integer.parseInt(st.nextToken().trim());
                }
                catch (Exception ex) {
                    iToken = -1;
                }
                if (iToken < 0 || iToken > 255) {
                    return -1L;
                }
                lResultIP <<= 8;
                lResultIP |= (long)iToken;
            }
            return lResultIP;
        }
        return -1L;
    }

    public static String short2hex(int i) {
        char[] buf = new char[4];
        int k = buf.length - 1;
        while (k >= 0) {
            buf[k] = DIGITS[i & 0xF];
            i >>>= 4;
            --k;
        }
        return new String(buf);
    }

    public static String throwableToString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String truncation(String strValue, int iMaxlength) {
        if (strValue == null || strValue.length() == 0) {
            return "\u65e0\u6807\u9898";
        }
        if (strValue.length() > iMaxlength && iMaxlength > 1) {
            return String.valueOf(strValue.substring(0, iMaxlength - 1)) + "...";
        }
        return strValue;
    }

    public static final String URLGBKDecode(String s) {
        if (s == null) {
            return null;
        }
        int iPos = 0;
        int iLen = s.length();
        int iLength = 0;
        String strResult = null;
        byte[] buff = new byte[iLen];
        iPos = 0;
        block8: while (iPos < iLen) {
            char c = s.charAt(iPos);
            switch (c) {
                case '+': {
                    buff[iLength++] = 32;
                    break;
                }
                case '%': {
                    try {
                        buff[iLength++] = (byte)Integer.parseInt(s.substring(iPos + 1, iPos + 3), 16);
                        iPos += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        break block8;
                    }
                }
                default: {
                    buff[iLength++] = (byte)c;
                }
            }
            ++iPos;
        }
        try {
            strResult = new String(buff, 0, iLength, "GBK");
        }
        catch (UnsupportedEncodingException ex) {
            strResult = new String(buff, 0, iLength);
        }
        return strResult;
    }

    public static final String URLGBKEncode(String s) {
        byte[] ba;
        String strResult = "";
        try {
            ba = s.getBytes("GBK");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        int iResultLen = 0;
        char[] out = new char[3 * ba.length + 1];
        int i = 0;
        while (i < ba.length) {
            int c = ba[i];
            if (dontNeedEncoding[c &= 0xFF]) {
                if (c == 32) {
                    c = 43;
                }
                out[iResultLen++] = (char)c;
            } else {
                out[iResultLen++] = 37;
                out[iResultLen++] = DIGITS[c >> 4 & 0xF];
                out[iResultLen++] = DIGITS[c & 0xF];
            }
            ++i;
        }
        return new String(out, 0, iResultLen);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

