/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.weblet.util.verfiycode.BitMapInputStream;
import com.trs.weblet.util.verfiycode.BitMapOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class BitMapData {
    static final byte[] FILE_TYPE_BYTES = new byte[]{66, 77};
    static final int FILE_TYPE_MAGIC = 19778;
    private byte[][] m_baData;
    private FileHeader m_obBmfh = new FileHeader();
    private InfoHeader m_obBmih = new InfoHeader();

    public int getCompression() {
        return this.m_obBmih.m_uiCompression;
    }

    public void setCompression(int n) {
        this.m_obBmih.m_uiCompression = n;
    }

    public int getWidth() {
        return this.m_obBmih.m_uiWidth;
    }

    public void setWidth(int n) {
        this.m_obBmih.m_uiWidth = n;
    }

    public int getHeight() {
        return this.m_obBmih.m_uiHeight;
    }

    public void setHeight(int n) {
        this.m_obBmih.m_uiHeight = n;
    }

    public byte[] getPalette() {
        return this.m_obBmih.m_baPalette;
    }

    public void setPalette(byte[] byArray) {
        InfoHeader.access$302(this.m_obBmih, byArray);
    }

    public int getFileSize() {
        return this.m_obBmfh.m_uiFileSize;
    }

    public byte[] getFileData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.getDataSize() + 1024);
        BitMapOutputStream bitMapOutputStream = new BitMapOutputStream(byteArrayOutputStream);
        try {
            this.save(bitMapOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getDataSize() {
        return this.m_obBmih.m_uiDataSize;
    }

    protected int getLineLength() {
        return this.getWidth() + 31 >> 5 << 2;
    }

    protected byte[][] getDataBuff() {
        if (this.m_baData == null) {
            int n = this.getHeight();
            int n2 = this.getLineLength();
            this.m_baData = new byte[n][];
            for (int i = 0; i < n; ++i) {
                this.m_baData[i] = new byte[n2];
            }
        }
        return this.m_baData;
    }

    public int getLineData(int n, byte[] byArray, int n2) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("line number");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dest offset");
        }
        if (byArray == null || n2 >= byArray.length) {
            throw new IllegalArgumentException("dest buffer");
        }
        if (this.m_baData == null) {
            throw new IllegalStateException("m_baData is null");
        }
        byte[] byArray2 = this.m_baData[n];
        int n3 = 0;
        int n4 = this.getLineLength();
        int n5 = byArray.length;
        int n6 = 0;
        for (n6 = 0; n6 < n4 && n2 < n5; ++n6) {
            byArray[n2++] = byArray2[n3++];
        }
        return n6;
    }

    public int setLineData(int n, byte[] byArray, int n2, int n3) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("line number");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("source offset or length");
        }
        if (byArray == null || n2 + n3 >= byArray.length) {
            throw new IllegalArgumentException("dest buffer");
        }
        if (this.m_baData == null) {
            throw new IllegalStateException("m_baData is null");
        }
        byte[] byArray2 = this.m_baData[n];
        int n4 = 0;
        int n5 = this.getHeight();
        int n6 = 0;
        for (n6 = 0; n6 < n3 && n4 < n5; ++n6) {
            byArray2[n4++] = byArray[n2++];
        }
        return n6;
    }

    public void load(BitMapInputStream bitMapInputStream) throws IOException {
        if (bitMapInputStream.readUnsignedByte2() != 19778) {
            throw new IllegalArgumentException("BMP format error");
        }
        this.m_obBmfh.m_uiFileSize = bitMapInputStream.readUnsignedByte4();
        this.m_obBmfh.m_uiReserved = bitMapInputStream.readUnsignedByte4();
        this.m_obBmfh.m_uiDataOffset = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiHeaderSize = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiWidth = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiHeight = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_usPlanes = bitMapInputStream.readUnsignedByte2();
        this.m_obBmih.m_usPixelBit = bitMapInputStream.readUnsignedByte2();
        this.m_obBmih.m_uiCompression = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiDataSize = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiHResolution = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiVResolution = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiColors = bitMapInputStream.readUnsignedByte4();
        this.m_obBmih.m_uiImportantColors = bitMapInputStream.readUnsignedByte4();
        int n = this.m_obBmih.m_uiHeaderSize - 40;
        if (n > 0) {
            bitMapInputStream.skip(n);
        }
        int n2 = this.m_obBmfh.m_uiDataOffset - this.m_obBmih.m_uiHeaderSize - 14;
        InfoHeader.access$302(this.m_obBmih, new byte[n2]);
        int n3 = bitMapInputStream.read(this.m_obBmih.m_baPalette);
        n = n2 - n3;
        if (n > 0) {
            bitMapInputStream.skip(n);
        }
        int n4 = this.getHeight();
        for (int i = 0; i < n4; ++i) {
            bitMapInputStream.read(this.getDataBuff()[i]);
        }
    }

    public void save(BitMapOutputStream bitMapOutputStream) throws IOException {
        this.m_obBmih.m_uiDataSize = this.getLineLength() * this.m_obBmih.m_uiHeight;
        this.m_obBmfh.m_uiDataOffset = 14 + this.m_obBmih.m_uiHeaderSize + this.m_obBmih.m_baPalette.length;
        this.m_obBmfh.m_uiFileSize = this.m_obBmfh.m_uiDataOffset + this.m_obBmih.m_uiDataSize;
        bitMapOutputStream.write(this.m_obBmfh.m_baFileType);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmfh.m_uiFileSize);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmfh.m_uiReserved);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmfh.m_uiDataOffset);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiHeaderSize);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiWidth);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiHeight);
        bitMapOutputStream.writeUnsignedByte2(this.m_obBmih.m_usPlanes);
        bitMapOutputStream.writeUnsignedByte2(this.m_obBmih.m_usPixelBit);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiCompression);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiDataSize);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiHResolution);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiVResolution);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiColors);
        bitMapOutputStream.writeUnsignedByte4(this.m_obBmih.m_uiImportantColors);
        bitMapOutputStream.write(this.m_obBmih.m_baPalette);
        int n = this.getHeight();
        int n2 = this.getLineLength();
        for (int i = 0; i < n; ++i) {
            bitMapOutputStream.writeLine(this.getDataBuff()[i], 0, n2);
        }
    }

    class InfoHeader {
        private int m_uiHeaderSize = 40;
        private int m_uiWidth = 0;
        private int m_uiHeight = 0;
        private int m_usPlanes = 1;
        private int m_usPixelBit = 1;
        private int m_uiCompression = 0;
        private int m_uiDataSize = 0;
        private int m_uiHResolution = 0;
        private int m_uiVResolution = 0;
        private int m_uiColors = 0;
        private int m_uiImportantColors = 0;
        private byte[] m_baPalette = null;

        InfoHeader() {
        }

        static /* synthetic */ byte[] access$302(InfoHeader infoHeader, byte[] byArray) {
            infoHeader.m_baPalette = byArray;
            return byArray;
        }
    }

    class FileHeader {
        private byte[] m_baFileType = FILE_TYPE_BYTES;
        private int m_uiFileSize = 0;
        private int m_uiReserved = 0;
        private int m_uiDataOffset = 0;

        FileHeader() {
        }
    }
}

