/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PostDataParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(PostDataParser.class);
    private CharArrayWriter m_oCharWriterTemp = new CharArrayWriter();
    private String m_sCurrServiceName = null;
    private String[] m_pServiceNames = new String[0];
    private HashMap[] m_pParameters = new HashMap[0];
    private int m_nCurrStatusId = 0;
    private static final int STATUS_START = 0;
    private static final int STATUS_METHOD_FIND = 1;
    private static final int STATUS_METHOD_RECORD = 2;
    private static final int STATUS_PARAMETERS_FIND = 3;
    private static final int STATUS_PARAMETER_FIND = 4;
    private static final int STATUS_PARAMETER_RECORD = 5;
    private static final int STATUS_END = 10;

    public void parse(String string) throws WCMException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(new InputSource(new FileReader(string)));
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(PostDataParser.class, "PostDataParser.label1", "\u89e3\u6790\u6587\u4ef6\u5931\u8d25!"), exception);
        }
    }

    public void parse(InputSource inputSource) throws WCMException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(PostDataParser.class, "PostDataParser.label2", "\u89e3\u6790\u8f93\u5165\u6d41\u5931\u8d25!"), exception);
        }
    }

    public HashMap findParameters(String string, String string2) {
        for (int i = 0; i < this.m_pServiceNames.length; ++i) {
            String string3 = this.m_pServiceNames[i];
            if (!string3.equalsIgnoreCase(string + "." + string2)) continue;
            return this.m_pParameters[i];
        }
        return null;
    }

    public HashMap[] findArrayParameters(String string, String string2) {
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        for (int i = 0; i < this.m_pServiceNames.length; ++i) {
            String string3 = this.m_pServiceNames[i];
            if (!string3.equalsIgnoreCase(string + "." + string2)) continue;
            arrayList.add(this.m_pParameters[i]);
        }
        HashMap[] hashMapArray = new HashMap[arrayList.size()];
        arrayList.toArray(hashMapArray);
        return hashMapArray;
    }

    public HashMap findParameters(int n) {
        if (n >= this.m_pParameters.length) {
            return null;
        }
        return this.m_pParameters[n];
    }

    public String findServiceId(int n) {
        if (n >= this.m_pServiceNames.length) {
            return null;
        }
        int n2 = this.m_pServiceNames[n].indexOf(".");
        return this.m_pServiceNames[n].substring(0, n2);
    }

    public String findMethodName(int n) {
        if (n >= this.m_pServiceNames.length) {
            return null;
        }
        int n2 = this.m_pServiceNames[n].indexOf(".");
        return this.m_pServiceNames[n].substring(n2 + 1);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_nCurrStatusId != 2 && this.m_nCurrStatusId != 5) {
            return;
        }
        this.m_oCharWriterTemp.write(cArray, n, n2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("post-data") && this.m_nCurrStatusId == 0) {
            this.m_nCurrStatusId = 1;
        } else if (string2.equalsIgnoreCase("METHOD") && this.m_nCurrStatusId == 1) {
            this.m_sCurrServiceName = attributes.getValue("type");
            this.m_nCurrStatusId = 2;
        } else if (string2.equalsIgnoreCase("parameters") && this.m_nCurrStatusId == 3) {
            this.m_nCurrStatusId = 4;
        } else if (this.m_nCurrStatusId == 4) {
            this.m_nCurrStatusId = 5;
        } else {
            logger.error((Object)I18NMessage.get(PostDataParser.class, "PostDataParser.label3", "\u4e0d\u7b26\u5408\u89c4\u5219\u7684\u6570\u636e\u7ed3\u6784\uff0c\u6682\u65f6\u4e0d\u76f4\u63a5\u629b\u51fa\u5f02\u5e38\u7ee7\u7eed\u64cd\u4f5c!\u4e0a\u4e0b\u6587\u4fe1\u606f\u5982\u4e0b\uff1a"));
            logger.error((Object)("TagName:" + string2));
            logger.error((Object)("_attributes:" + attributes));
        }
        if (this.m_nCurrStatusId == 2 || this.m_nCurrStatusId == 5) {
            this.m_oCharWriterTemp.reset();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.m_nCurrStatusId) {
            case 2: {
                this.m_sCurrServiceName = this.m_oCharWriterTemp.toString() + "." + this.m_sCurrServiceName;
                this.m_nCurrStatusId = 3;
                this.addServiceName();
                break;
            }
            case 5: {
                this.m_pParameters[this.m_pParameters.length - 1].put(string2, this.m_oCharWriterTemp.toString());
                this.m_nCurrStatusId = 4;
                break;
            }
            default: {
                if (string2.equalsIgnoreCase("post-data")) {
                    this.m_nCurrStatusId = 10;
                    break;
                }
                if (!string2.equalsIgnoreCase("parameters")) break;
                this.m_nCurrStatusId = 1;
            }
        }
    }

    private void addServiceName() {
        int n = this.m_pServiceNames.length;
        String[] stringArray = new String[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pServiceNames, 0, stringArray, 0, n);
        }
        stringArray[n] = this.m_sCurrServiceName;
        this.m_pServiceNames = stringArray;
        HashMap[] hashMapArray = new HashMap[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pParameters, 0, hashMapArray, 0, n);
        }
        hashMapArray[n] = new HashMap(3);
        this.m_pParameters = hashMapArray;
    }

    public static void main(String[] stringArray) {
        try {
            PostDataParser postDataParser = new PostDataParser();
            postDataParser.parse("c:/data.xml");
            for (int i = 0; i < postDataParser.m_pServiceNames.length; ++i) {
                String string = postDataParser.m_pServiceNames[i];
                System.out.println(string);
                System.out.println(postDataParser.m_pParameters[i]);
            }
            System.out.println(postDataParser.findServiceId(1));
            System.out.println(postDataParser.findMethodName(1));
            System.out.println(postDataParser.findParameters(1));
            System.out.println(postDataParser.findParameters("wcm6_channel", "changeorder2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

