/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.TRSParameter;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TRSPageParameter
extends TRSParameter {
    private static Logger logger = Logger.getLogger(TRSPageParameter.class);
    private String m_sName;
    private String m_sDesc;
    private boolean m_bRequired;
    private String m_sType;
    private String m_sDefault;
    private int m_nMaxLength = -1;
    private int m_nMinLength = -1;
    private String m_sMaxValue;
    private String m_sMinValue;
    private boolean m_bSearch;
    private String m_sSearchOperator;
    private String m_sSearchField;
    private String m_sSearchType;
    private String m_sExcludeValue;
    private String[] pExcludeValue = null;

    public boolean isRequired() {
        return this.m_bRequired;
    }

    public void setRequired(boolean bl) {
        this.m_bRequired = bl;
    }

    public String getType() {
        if (this.m_sType == null) {
            return "string";
        }
        return this.m_sType;
    }

    public void setType(String string) throws CMyException {
        if (!this.isSupportedType(string)) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label1", "\u7c7b\u578b[") + string + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label2", "]\u65e0\u6548!"));
        }
        this.m_sType = string.toLowerCase();
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String string) {
        this.m_sDesc = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public int getMaxLength() {
        return this.m_nMaxLength;
    }

    public void setMaxLength(int n) {
        this.m_nMaxLength = n;
    }

    public int getMinLength() {
        return this.m_nMinLength;
    }

    public void setMinLength(int n) {
        this.m_nMinLength = n;
    }

    public String getDefault() {
        return this.m_sDefault;
    }

    public int getDefaultAsInt(int n) {
        if (this.getDefault() == null) {
            return n;
        }
        try {
            return Integer.parseInt(this.getDefault());
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label5", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6574\u578b!")), (Throwable)exception);
            return n;
        }
    }

    public long getDefaultAsLong(long l) {
        if (this.getDefault() == null) {
            return l;
        }
        try {
            return Long.parseLong(this.getDefault());
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label6", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u957f\u6574\u578b!")), (Throwable)exception);
            return l;
        }
    }

    public float getDefaultAsFloat(float f) {
        if (this.getDefault() == null) {
            return f;
        }
        try {
            return Float.parseFloat(this.getDefault());
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label7", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6d6e\u70b9\u6570!")), (Throwable)exception);
            return f;
        }
    }

    public boolean getDefaultAsBoolean(boolean bl) {
        if (this.getDefault() == null) {
            return bl;
        }
        if ("true".equals(this.getDefault())) {
            return true;
        }
        if ("false".equals(this.getDefault())) {
            return true;
        }
        try {
            return this.getDefaultAsInt(0) == 1;
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label8", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u5e03\u5c14\u578b!")), (Throwable)exception);
            return bl;
        }
    }

    public double getDefaultAsDouble(double d) {
        if (this.getDefault() == null) {
            return d;
        }
        try {
            return Double.parseDouble(this.getDefault());
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label9", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u53cc\u7cbe\u5ea6\u6570!")), (Throwable)exception);
            return d;
        }
    }

    public CMyDateTime getDefaultAsDateTime() throws CMyException {
        if (this.getDefault() == null) {
            return null;
        }
        try {
            CMyDateTime cMyDateTime = new CMyDateTime();
            cMyDateTime.setDateTimeWithString(this.getDefault());
            return cMyDateTime;
        }
        catch (Exception exception) {
            throw new CMyException(2, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label3", "\u53c2\u6570[") + this.getName() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label4", "]\u7684\u9ed8\u8ba4\u503c[") + this.getDefault() + I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label10", "]\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65f6\u95f4\u7c7b\u578b!"), exception);
        }
    }

    public void setDefault(String string) {
        this.m_sDefault = string;
    }

    public String getMaxValue() {
        return this.m_sMaxValue;
    }

    public void setMaxValue(String string) {
        this.m_sMaxValue = string;
    }

    public String getMinValue() {
        return this.m_sMinValue;
    }

    public void setMinValue(String string) {
        this.m_sMinValue = string;
    }

    protected void validXMLElement(Element element) throws CMyException {
        String string = element.attributeValue("name");
        if (string == null || (string = string.trim()).length() <= 0) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label11", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aName\u5c5e\u6027!"));
        }
        String string2 = element.attributeValue("desc");
        if (string2 == null || (string2 = string2.trim()).length() <= 0) {
            throw new CMyException(10, I18NMessage.get(TRSPageParameter.class, "TRSPageParameter.label12", "\u53c2\u6570\u6ca1\u6709\u6307\u5b9aDesc\u5c5e\u6027!"));
        }
    }

    public boolean fromXML(Element element) throws CMyException {
        super.fromXML(element);
        this.setDefault(this.getPropertyAsString("default"));
        this.setName(this.getPropertyAsString("name"));
        this.setDesc(this.getPropertyAsString("desc"));
        this.setType(this.getPropertyAsString("type"));
        this.setRequired("true".equals(this.getPropertyAsString("required")));
        this.setMaxLength(this.getPropertyAsInt("max-length", -1));
        this.setMinLength(this.getPropertyAsInt("min-length", -1));
        this.setMaxValue(this.getPropertyAsString("max-value"));
        this.setMinValue(this.getPropertyAsString("min-value"));
        this.setSearch("true".equals(this.getPropertyAsString("search")));
        this.setSearchOperator(this.getPropertyAsString("search-operator"));
        this.setSearchField(this.getPropertyAsString("search-field"));
        this.setSearchType(this.getPropertyAsString("search-type"));
        this.setExcludeValue(this.getPropertyAsString("exclude-value"));
        return true;
    }

    public static TRSPageParameter createPageParameterFromXML(Element element) throws CMyException {
        TRSPageParameter tRSPageParameter = new TRSPageParameter();
        tRSPageParameter.fromXML(element);
        return tRSPageParameter;
    }

    private boolean isSupportedType(String string) {
        for (int i = 0; i < FrameworkConstants.DATA_TYPES_SUPPORTED.length; ++i) {
            if (!FrameworkConstants.DATA_TYPES_SUPPORTED[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getSearchExpress(int n) {
        String string = null;
        String string2 = this.getSearchOperator();
        String string3 = this.getSearchField();
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            string3 = this.getName();
        }
        switch (this.getType().toLowerCase().hashCode()) {
            case -891985903: {
                if (string2 == null) {
                    string2 = "like";
                }
                if (n > 1 && string2.toLowerCase().indexOf("in") < 0) {
                    StringBuffer stringBuffer = new StringBuffer(n * (string3.length() + string2.length() + 10));
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append("(" + string3 + ' ' + string2 + " ? " + ")");
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.setLength(stringBuffer.length() - 5);
                    return stringBuffer.toString();
                }
                if (n > 1 || string2.toLowerCase().indexOf("in") >= 0) {
                    for (int i = 0; i < n; ++i) {
                        string = string == null ? string3 + ' ' + string2 + " (?" : string + ", ?";
                    }
                    string = string + ")";
                    break;
                }
                string = string3 + ' ' + string2 + " ? ";
                break;
            }
            default: {
                if (string2 == null) {
                    string2 = "=";
                }
                string = string3 + ' ' + string2 + '?';
            }
        }
        return string;
    }

    public boolean isSearch() {
        return this.m_bSearch;
    }

    public void setSearch(boolean bl) {
        this.m_bSearch = bl;
    }

    public String getSearchOperator() {
        return this.m_sSearchOperator;
    }

    public void setSearchOperator(String string) {
        this.m_sSearchOperator = string;
    }

    public String getSearchField() {
        return this.m_sSearchField;
    }

    public void setSearchField(String string) {
        this.m_sSearchField = string;
    }

    public String getSearchType() {
        return this.m_sSearchType;
    }

    public void setSearchType(String string) {
        this.m_sSearchType = string;
    }

    public String getExcludeValue() {
        return this.m_sExcludeValue;
    }

    public boolean isExcludeValue(String string) {
        if (this.pExcludeValue == null) {
            return false;
        }
        for (int i = 0; i < this.pExcludeValue.length; ++i) {
            if (this.pExcludeValue[i] != string) continue;
            return true;
        }
        return false;
    }

    public void setExcludeValue(String string) {
        this.m_sExcludeValue = string;
        if (this.m_sExcludeValue != null) {
            this.pExcludeValue = CMyString.split(this.m_sExcludeValue, ",");
        }
    }

    protected void validValue() {
    }

    public boolean isSelectFields() {
        return this.m_sName.trim().equalsIgnoreCase("SelectFields");
    }

    public boolean isFromTable() {
        return this.m_sName.trim().equalsIgnoreCase("FromTable");
    }

    public boolean isOrderBy() {
        this.m_sName = this.m_sName.trim();
        return this.m_sName.equalsIgnoreCase("OrderBy") || this.m_sName.equalsIgnoreCase("OrderType");
    }
}

