/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.LoadingErrorReport;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.provider.IServiceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ServiceConfig {
    protected static Logger logger = Logger.getLogger(ServiceConfig.class);
    private Map m_mapServices = null;
    private LoadingErrorReport m_oLoadingErrorReport = null;
    private IServiceProvider m_oServiceProvider = null;
    private String m_sServiceId = null;
    private String m_sObjKlassName;

    public ServiceConfig(String string) {
        this.m_sServiceId = string;
    }

    public String getServiceId() {
        return this.m_sServiceId;
    }

    public Collection getServices() {
        return this.m_mapServices.values();
    }

    public MethodConfig findMethodByName(String string) {
        Integer n = new Integer(string.toLowerCase().hashCode());
        return (MethodConfig)this.m_mapServices.get(n);
    }

    public void loadFromFile(String string) {
        this.m_mapServices = new HashMap(4);
        SAXReader sAXReader = new SAXReader();
        try {
            Document document = sAXReader.read(string);
            Element element = document.getRootElement();
            String string2 = element.attributeValue("provider");
            String string3 = element.attributeValue("decorator");
            IServiceProvider iServiceProvider = null;
            iServiceProvider = string3 != null && string3.trim().length() != 0 ? ServiceConfigHelper.makeProvider(string2, string3) : ServiceConfigHelper.makeProvider(string2);
            if (iServiceProvider == null) {
                return;
            }
            this.m_sObjKlassName = element.attributeValue("objclass");
            this.m_oServiceProvider = iServiceProvider;
            Iterator iterator = element.elementIterator("method");
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string4 = element2.attributeValue("name");
                if (string4 == null || (string4 = string4.trim()).length() == 0) continue;
                int n = string4.toLowerCase().hashCode();
                try {
                    if (n == 96673) {
                        for (int i = 0; i < FrameworkConstants.METHOD_TYPES.length; ++i) {
                            int n2 = FrameworkConstants.METHOD_TYPES[i];
                            this.m_mapServices.put(new Integer(n2), this.makeMethodConfig(n2, element2, iServiceProvider));
                        }
                        continue;
                    }
                    this.m_mapServices.put(new Integer(n), this.makeMethodConfig(n, element2, iServiceProvider));
                }
                catch (Throwable throwable) {
                    logger.error((Object)(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label1", "\u65b9\u6cd5 [") + string4 + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label2", "] \u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01")), throwable);
                    if (this.m_oLoadingErrorReport == null) {
                        this.m_oLoadingErrorReport = new LoadingErrorReport();
                    }
                    this.m_oLoadingErrorReport.add(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label1", "\u65b9\u6cd5 [") + string4 + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label2", "] \u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01"), throwable);
                }
            }
        }
        catch (DocumentException documentException) {
            logger.error((Object)(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label3", "\u89e3\u6790\u6587\u4ef6[") + string + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label4", "]\u5931\u8d25!")), (Throwable)documentException);
            this.m_oLoadingErrorReport = new LoadingErrorReport(I18NMessage.get(ServiceConfig.class, "ServiceConfig.label3", "\u89e3\u6790\u6587\u4ef6[") + string + I18NMessage.get(ServiceConfig.class, "ServiceConfig.label4", "]\u5931\u8d25!"), documentException);
        }
    }

    private Object makeMethodConfig(int n, Element element, IServiceProvider iServiceProvider) throws CMyException {
        MethodConfig methodConfig = new MethodConfig(n, this);
        methodConfig.initFrom(element, iServiceProvider);
        return methodConfig;
    }

    public LoadingErrorReport getLoadingErrorReport() {
        return this.m_oLoadingErrorReport;
    }

    public Map getMethodConfigsMap() {
        return this.m_mapServices;
    }

    public IServiceProvider getServiceProvider() {
        return this.m_oServiceProvider;
    }

    public String getObjKlassName() {
        return this.m_sObjKlassName;
    }
}

