/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.NoSuchServiceException;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.provider.IServiceProvider;
import com.trs.webframework.xmlserver.IXMLConvertor;
import com.trs.webframework.xmlserver.XMLConvertorFactory;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MethodConfig {
    private static Logger logger = Logger.getLogger(MethodConfig.class);
    private boolean m_bIsVirtual = false;
    private int m_nMethdoNameHashCode = 0;
    private IServiceProvider m_oProvider = null;
    private TRSPageParameter[] m_pPageParameter = null;
    private String m_sName = null;
    private String m_sTrueName = null;
    private Method m_oMethod = null;
    private String m_sUri = null;
    private String m_sUrl = null;
    private boolean m_bParamsRequired = true;
    private boolean m_bIsSingleton = false;
    private String m_sProviderClassName = null;
    private ServiceConfig m_oServiceConfig = null;
    private String m_sConvertorValue = null;
    private String m_sLoggerName;
    private boolean m_zLogged;
    private String m_sLogObjClassName;
    private String m_sDesc;
    private int m_nConvertorType = 0;

    public MethodConfig(int n, ServiceConfig serviceConfig) {
        this.m_nMethdoNameHashCode = n;
        this.m_oServiceConfig = serviceConfig;
        this.m_sLogObjClassName = this.m_oServiceConfig.getObjKlassName();
    }

    public IServiceProvider getProvider() {
        if (this.m_oProvider == null || this.m_sProviderClassName == null) {
            return null;
        }
        if (this.m_bIsSingleton) {
            return this.m_oProvider;
        }
        return this.createProvider(this.m_sProviderClassName);
    }

    public TRSPageParameter[] getPageParameter() {
        return this.m_pPageParameter;
    }

    public void initFrom(Element element, IServiceProvider iServiceProvider) throws CMyException {
        Object object;
        Object object2;
        this.m_sName = element.attributeValue("name");
        if (this.m_sName == null || (this.m_sName = this.m_sName.trim()).length() == 0) {
            throw new CMyException(I18NMessage.get(MethodConfig.class, "MethodConfig.label1", "\u6ca1\u6709\u8bbe\u7f6ename\uff01"));
        }
        this.m_sTrueName = element.attributeValue("truename");
        if (this.m_sTrueName != null && !this.m_sTrueName.equalsIgnoreCase(this.m_sName)) {
            this.m_bIsVirtual = true;
        }
        this.m_sLoggerName = element.attributeValue("logger");
        if (CMyString.isEmpty(this.m_sLoggerName) && this.m_bIsVirtual) {
            object2 = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            this.m_sLoggerName = ((MethodConfig)object2).getLoggerName();
        }
        this.m_zLogged = !CMyString.isEmpty(this.m_sLoggerName);
        object2 = element.attributeValue("objclass");
        if (!CMyString.isEmpty((String)object2)) {
            this.m_sLogObjClassName = object2;
        }
        this.m_sDesc = element.attributeValue("desc");
        if (CMyString.isEmpty(this.m_sDesc) && this.m_bIsVirtual) {
            object = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            this.m_sDesc = ((MethodConfig)object).getDesc();
        }
        if ((object = element.attributeValue("isSingleton")) != null && ((object = ((String)object).trim().toLowerCase()) == "true" || object == "1")) {
            this.m_bIsSingleton = true;
        }
        this.m_sUri = element.attributeValue("uri");
        this.m_sUrl = element.attributeValue("url");
        if (this.m_sUri == null && this.m_sUrl == null) {
            this.initNormalParams(element, iServiceProvider);
        } else if (this.m_sUri != null && this.m_sUri.trim().length() == 0 && this.m_sUrl != null && this.m_sUrl.trim().length() == 0) {
            throw new ServiceCreationFailException(I18NMessage.get(MethodConfig.class, "MethodConfig.label2", "\u65e0\u6cd5\u4e3a\u65b9\u6cd5[") + this.m_sName + I18NMessage.get(MethodConfig.class, "MethodConfig.label3", "]\u521b\u5efa\u6307\u5b9a\u4e3a\u7a7a\u4e32\u7684\u670d\u52a1\u8df3\u8f6c\u94fe\u63a5\uff01"));
        }
        String string = element.attributeValue("convertor");
        if (string != null && (string = string.trim()).length() > 0) {
            int n = string.indexOf(58);
            if (n <= 0) {
                logger.error((Object)(this.getServiceConfig().getServiceId() + "." + this.getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label4", "\u6307\u5b9a\u7684Convertor[") + string + I18NMessage.get(MethodConfig.class, "MethodConfig.label5", "]\u4e0d\u7b26\u5408\u62df\u5b9a\u7684\u534f\u8bae\uff01")));
            } else {
                String string2 = string.substring(0, n).toUpperCase();
                if (string2.equals("URI")) {
                    this.m_nConvertorType = 1;
                } else if (string2.equals("URL")) {
                    this.m_nConvertorType = 2;
                } else if (string2.equals("XML")) {
                    this.m_nConvertorType = 3;
                } else if (string2.equals("JSON")) {
                    this.m_nConvertorType = 4;
                }
                this.m_sConvertorValue = string.substring(n + 1);
            }
        }
        this.initPageParameters(element);
        if (this.isDefaultURI()) {
            this.m_nConvertorType = 1;
        }
    }

    public boolean isDefaultURI() {
        String string = this.getServiceConfig().getServiceId();
        String string2 = this.getTrueName();
        return "wcm6_Default".equalsIgnoreCase(string) && "forword".equalsIgnoreCase(string2);
    }

    private void initNormalParams(Element element, IServiceProvider iServiceProvider) {
        Object object;
        IServiceProvider iServiceProvider2 = this.createProvider(element, iServiceProvider);
        if (iServiceProvider2 == null) {
            return;
        }
        this.m_oProvider = ServiceConfigHelper.validateProvider(this.m_nMethdoNameHashCode, iServiceProvider2);
        if (this.m_oProvider == null) {
            return;
        }
        if (ServiceConfigHelper.isSelfDefinedMethodName(this.m_nMethdoNameHashCode)) {
            object = element.attributeValue("params-required");
            if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                this.m_bParamsRequired = ((String)object).compareToIgnoreCase("true") == 0 || ((String)object).equals("1");
            }
            try {
                this.m_oMethod = this.m_bParamsRequired ? this.m_oProvider.getClass().getMethod(this.getTrueName(), MethodContext.class) : this.m_oProvider.getClass().getMethod(this.getTrueName(), null);
            }
            catch (SecurityException securityException) {
                throw new NoSuchServiceException(I18NMessage.get(MethodConfig.class, "MethodConfig.label6", "\u65e0\u6cd5\u4ece Service \u63d0\u4f9b\u8005[") + this.getProvider().getClass().getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label7", "]\u83b7\u53d6\u65b9\u6cd5[") + this.m_sName + "]\uff01", securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchServiceException(I18NMessage.get(MethodConfig.class, "MethodConfig.label8", "Service \u63d0\u4f9b\u8005[") + this.getProvider().getClass().getName() + I18NMessage.get(MethodConfig.class, "MethodConfig.label9", "]\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + this.m_sName + "(" + (this.m_bParamsRequired ? "MethodContext" : "") + ")]\uff01", noSuchMethodException);
            }
        }
        if (this.m_oProvider instanceof IXMLConvertor) {
            object = (IXMLConvertor)((Object)this.m_oProvider);
            String[] stringArray = object.registerTargetClassName();
            for (int i = 0; i < stringArray.length; ++i) {
                XMLConvertorFactory.registerConvertor((IXMLConvertor)object, stringArray[i]);
            }
        }
    }

    private IServiceProvider createProvider(Element element, IServiceProvider iServiceProvider) {
        String string = element.attributeValue("provider");
        String string2 = element.attributeValue("decorator");
        IServiceProvider iServiceProvider2 = null;
        if (string != null && string.length() > 0) {
            iServiceProvider2 = ServiceConfigHelper.makeProvider(string, string2);
            this.m_sProviderClassName = string2 == null ? string : string2;
        } else {
            iServiceProvider2 = iServiceProvider;
            this.m_sProviderClassName = iServiceProvider.getClass().getName();
        }
        return iServiceProvider2;
    }

    private IServiceProvider createProvider(String string) {
        return ServiceConfigHelper.makeProvider(string, null);
    }

    private void initPageParameters(Element element) throws CMyException {
        Element element2;
        List list = element.elements("parameter");
        int n = list.size();
        if (this.m_bIsVirtual) {
            MethodConfig methodConfig = this.m_oServiceConfig.findMethodByName(this.m_sTrueName);
            if (methodConfig == null) {
                throw new CMyException(I18NMessage.get(MethodConfig.class, "MethodConfig.label10", "\u65b9\u6cd5[") + this.m_sTrueName + I18NMessage.get(MethodConfig.class, "MethodConfig.label11", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            element2 = methodConfig.getPageParameter();
            this.m_pPageParameter = new TRSPageParameter[n + ((Element)element2).length];
            this.m_sTrueName = methodConfig.getTrueName();
            System.arraycopy(element2, 0, this.m_pPageParameter, n, ((Element)element2).length);
        } else {
            this.m_pPageParameter = new TRSPageParameter[n];
        }
        for (int i = 0; i < n; ++i) {
            element2 = (Element)list.get(i);
            if (element2 == null) continue;
            TRSPageParameter tRSPageParameter = new TRSPageParameter();
            tRSPageParameter.fromXML(element2);
            if (this.m_bIsVirtual) {
                boolean bl = false;
                for (int j = 0; j < this.m_pPageParameter.length; ++j) {
                    if (this.m_pPageParameter[j] == null || !tRSPageParameter.getName().equalsIgnoreCase(this.m_pPageParameter[j].getName())) continue;
                    this.m_pPageParameter[j] = tRSPageParameter;
                    this.m_pPageParameter[i] = null;
                    bl = true;
                }
                if (bl) continue;
            }
            this.m_pPageParameter[i] = tRSPageParameter;
        }
    }

    public int getMethdoNameHashCode() {
        return this.m_nMethdoNameHashCode;
    }

    public Method getMethod() {
        return this.m_oMethod;
    }

    public void setMethod(Method method) {
        this.m_oMethod = method;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public String getTrueName() {
        if (this.m_sTrueName == null || this.m_sTrueName.length() == 0) {
            this.m_sTrueName = this.m_sName;
        }
        return this.m_sTrueName;
    }

    public void setTrueName(String string) {
        this.m_sTrueName = string;
        if (this.m_sTrueName != null) {
            this.m_sTrueName = this.m_sTrueName.trim();
        }
    }

    public void setMethdoNameHashCode(int n) {
        this.m_nMethdoNameHashCode = n;
    }

    public boolean isPageParametersEmpty() {
        return this.m_pPageParameter == null || this.m_pPageParameter.length == 0;
    }

    public String toString() {
        return this.getTrueName();
    }

    public String getUri() {
        return this.m_sUri;
    }

    public void setUri(String string) {
        this.m_sUri = string;
    }

    public String getUrl() {
        return this.m_sUrl;
    }

    public void setUrl(String string) {
        this.m_sUrl = string;
    }

    public boolean isParamsRequired() {
        return this.m_bParamsRequired;
    }

    public ServiceConfig getServiceConfig() {
        return this.m_oServiceConfig;
    }

    public int getConvertorType() {
        return this.m_nConvertorType;
    }

    public String getConvertorValue() {
        return this.m_sConvertorValue;
    }

    public String getLoggerName() {
        return this.m_sLoggerName;
    }

    public boolean isLogged() {
        return this.m_zLogged;
    }

    public String getLogObjClassName() {
        return this.m_sLogObjClassName;
    }

    public String getDesc() {
        return this.m_sDesc;
    }
}

