/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;

public class Watermark
extends CMSObj {
    public static final int OBJ_TYPE = 1377689707;
    public static final String DB_TABLE_NAME = "XWCMWATERMARK";
    public static final String DB_ID_NAME = "WATERMARKID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 1377689707;
    }

    public String getWMName() {
        return this.getPropertyAsString("WMNAME");
    }

    public boolean setWMName(String string) throws WCMException {
        return this.setProperty("WMNAME", string);
    }

    public String getWMPicture() {
        return this.getPropertyAsString("WMPICTURE");
    }

    public boolean setWMPicture(String string) throws WCMException {
        return this.setProperty("WMPICTURE", string);
    }

    public int getLibId() {
        return this.getPropertyAsInt("LIBID", 0);
    }

    public boolean setLibId(int n) throws WCMException {
        return this.setProperty("LIBID", n);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getLibId() == 0) {
                throw new WCMException(1106, I18NMessage.get(Watermark.class, "Watermark.label1", "\u6c34\u5370\u6240\u5c5e\u56fe\u5e93Id\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Watermark.class, "Watermark.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Watermark.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(user);
        }
    }

    public static final Watermark findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Watermark)BaseObj.findById(Watermark.class, n);
    }

    public static final Watermark createNewInstance() throws WCMException {
        return (Watermark)BaseObj.createNewInstance(Watermark.class);
    }

    public static final Watermark findByKey(Object object) throws WCMException {
        return (Watermark)BaseObj.findByKey(Watermark.class, object);
    }

    public void save(User user) throws WCMException {
        String string = this.getWMPicture();
        String string2 = this.getNewPropertyAsString("WMPICTURE");
        FilesMan filesMan = FilesMan.getFilesMan();
        if (string2 != null && string2.length() > 0 && this.isChangeProperty("WMPICTURE")) {
            filesMan.deleteFile(string);
            string = string2;
        }
        if (!FilesMan.isValidFile(string, "W0")) {
            string = filesMan.moveWCMFile(string, "W0", true);
            string = CMyFile.extractFileName(string);
            this.setWMPicture(string);
        }
        if (this.isAddMode()) {
            this.insert(user);
        } else {
            this.update(user);
        }
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getWMName();
        }
        return this.getWMName() + I18NMessage.get(Watermark.class, "Watermark.label3", "[\u6c34\u5370-") + this.getId() + "]";
    }

    public int delete(User user) throws WCMException {
        int n = super.delete(user);
        final String string = this.getWMPicture();
        new Thread(){

            public void run() {
                try {
                    FilesMan.getFilesMan().deleteFile(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        return n;
    }
}

