/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.IImageLibConfig;

public class ImageLibHelper {
    public static String getImageFileNameByScaleIndex(Document document, int n) throws WCMException {
        return ImageLibHelper.getImageFileNameByScaleIndex(document, n, true);
    }

    public static String getImageFileNameByScaleIndex(Document document, int n, boolean bl) throws WCMException {
        String[] stringArray = ImageLibHelper.getAllImageFiles(document);
        if (stringArray == null) {
            return "";
        }
        if (stringArray.length <= n) {
            n = stringArray.length - 1;
        }
        String string = stringArray[n];
        if (bl) {
            return string;
        }
        return FilesMan.getFilesMan().mapFilePath(string, 1) + string;
    }

    public static String getOrigImageFilePath(Document document, boolean bl) throws WCMException {
        String string = document.getAttributeValue("srcfile");
        if (string == null || string.length() <= 0) {
            return "";
        }
        if (bl) {
            return string;
        }
        string = FilesMan.getFilesMan().copyWCMFile(string, "W0");
        return FilesMan.getFilesMan().mapFilePath(string, 1) + string;
    }

    public static String getOrigImageFileName(Document document, boolean bl) throws WCMException {
        String[] stringArray = ImageLibHelper.getAllImageFiles(document);
        if (stringArray == null) {
            return "";
        }
        int n = stringArray.length - 1;
        String string = stringArray[n];
        if (bl) {
            return string;
        }
        if (document.getStatusId() == 10) {
            IPublishContent iPublishContent = PublishElementFactory.makeContentFrom(document, null);
            PublishPathCompass publishPathCompass = new PublishPathCompass();
            return publishPathCompass.getAbsoluteHttpPath(iPublishContent) + string;
        }
        return FilesMan.getFilesMan().mapFilePath(string, 1) + string;
    }

    public static String[] getAllImageFiles(Document document) {
        String string = document.getRelateWords();
        if (string == null || string.length() <= 0) {
            return null;
        }
        String[] stringArray = CMyString.split(string, ",");
        return stringArray;
    }

    public static String getImageFileNameByScale(Document document, int n) throws WCMException {
        return ImageLibHelper.getImageFileNameByScale(document, n, true);
    }

    public static String getImageFileNameByScale(Document document, int n, boolean bl) throws WCMException {
        IImageLibConfig iImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int n2 = -1;
        int[] nArray = iImageLibConfig.getScaleSizes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            throw new WCMException(I18NMessage.get(ImageLibHelper.class, "ImageLibHelper.label2", "\u6307\u5b9a\u7684\u5c3a\u5bf8[") + n + I18NMessage.get(ImageLibHelper.class, "ImageLibHelper.label3", "]\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5b9a\u4e49\uff01"));
        }
        return ImageLibHelper.getImageFileNameByScaleIndex(document, n2, bl);
    }

    public static int getTypeQuotedImageLib(Appendix appendix) {
        String string = appendix.getFile();
        if (appendix.getFlag() != 20 || string.indexOf(47) < 0) {
            return 0;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        if (string.startsWith(filesMan.getPathConfigValue("W0", 1))) {
            return 1;
        }
        return 2;
    }
}

