/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class MD5Digest {
    private static Logger logger = Logger.getLogger(MD5Digest.class);
    private static final int BUFFER_LENGTH = 4096;
    private final byte[] BUFFER = new byte[4096];
    private String m_sAppDir;
    private String m_sDigestStoreFile;
    private MessageDigest m_oDigest;

    public MD5Digest(String _sAppDir, String _sWigestStoreFile) {
        this.m_sAppDir = _sAppDir;
        this.m_sDigestStoreFile = _sWigestStoreFile;
    }

    public void digest() throws Exception {
        final Properties props = new Properties();
        File fAppDir = new File(this.m_sAppDir);
        if (!fAppDir.exists() || !fAppDir.isDirectory()) {
            throw new Exception("Invlaid application dir: " + this.m_sAppDir);
        }
        final int APP_DIR_LEN = fAppDir.getAbsolutePath().length() + 1;
        this.m_oDigest = MessageDigest.getInstance("MD5");
        fAppDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    if (!".svn".equals(pathname.getName())) {
                        pathname.listFiles(this);
                    }
                } else {
                    String sFileName = pathname.getAbsolutePath();
                    sFileName = sFileName.substring(APP_DIR_LEN);
                    sFileName = sFileName.replace(File.separatorChar, '/');
                    props.put(sFileName, MD5Digest.this.digest(pathname));
                }
                return false;
            }
        });
        this.storeResult(props);
    }

    public Properties digestAppMD5(String _sAppPath) throws Exception {
        final Properties props = new Properties();
        File fAppDir = new File(_sAppPath);
        if (!fAppDir.exists() || !fAppDir.isDirectory()) {
            throw new Exception("Invlaid application dir: " + _sAppPath);
        }
        final int APP_DIR_LEN = fAppDir.getAbsolutePath().length() + 1;
        this.m_oDigest = MessageDigest.getInstance("MD5");
        fAppDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    if (!".svn".equals(pathname.getName())) {
                        pathname.listFiles(this);
                    }
                } else {
                    String sFileName = pathname.getAbsolutePath();
                    sFileName = sFileName.substring(APP_DIR_LEN);
                    sFileName = sFileName.replace(File.separatorChar, '/');
                    props.put(sFileName, MD5Digest.this.digest(pathname));
                }
                return false;
            }
        });
        return props;
    }

    public Set getDifference() throws Exception {
        final TreeSet result = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                DifferenceRecord r1 = (DifferenceRecord)o1;
                DifferenceRecord r2 = (DifferenceRecord)o2;
                return r1.getName().compareTo(r2.getName());
            }
        });
        File fAppDir = new File(this.m_sAppDir);
        if (!fAppDir.exists() || !fAppDir.isDirectory()) {
            throw new Exception("Invlaid application dir: " + this.m_sAppDir);
        }
        final Properties props = this.loadStandardDigest();
        final int APP_DIR_LEN = fAppDir.getAbsolutePath().length() + 1;
        this.m_oDigest = MessageDigest.getInstance("MD5");
        fAppDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    if (!".svn".equals(pathname.getName())) {
                        pathname.listFiles(this);
                    }
                } else {
                    String sFileName = pathname.getAbsolutePath();
                    sFileName = sFileName.substring(APP_DIR_LEN);
                    String standard = props.getProperty(sFileName = sFileName.replace(File.separatorChar, '/'));
                    if (standard == null) {
                        result.add(new DifferenceRecord(pathname.getAbsolutePath(), false));
                    } else {
                        String digest = MD5Digest.this.digest(pathname);
                        if (!standard.equals(digest)) {
                            result.add(new DifferenceRecord(pathname.getAbsolutePath()));
                        }
                    }
                }
                return false;
            }
        });
        return result;
    }

    private Properties loadStandardDigest() throws Exception {
        Properties props = new Properties();
        FileInputStream fins = null;
        try {
            fins = new FileInputStream(this.m_sDigestStoreFile);
            props.load(fins);
        }
        finally {
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    public String digest(File file) {
        ByteArrayOutputStream baos;
        block19: {
            FileInputStream fins = null;
            baos = new ByteArrayOutputStream((int)file.length());
            try {
                try {
                    fins = new FileInputStream(file);
                    int len = -1;
                    while ((len = fins.read(this.BUFFER, 0, 4096)) != -1) {
                        baos.write(this.BUFFER, 0, len);
                    }
                    baos.flush();
                }
                catch (Exception len) {
                    if (fins != null) {
                        try {
                            fins.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (fins != null) {
                    try {
                        fins.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.m_oDigest != null) {
            this.m_oDigest.reset();
        } else {
            try {
                this.m_oDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                logger.error((Object)"Fail to instance MD5 Dig", (Throwable)e);
            }
        }
        this.m_oDigest.update(baos.toByteArray());
        BigInteger bigInteger = new BigInteger(1, this.m_oDigest.digest());
        return bigInteger.toString(16);
    }

    public String digest(String _sFile) throws Exception {
        File file = new File(_sFile);
        if (!file.exists() || !file.isFile()) {
            return "";
        }
        this.m_oDigest = MessageDigest.getInstance("MD5");
        return this.digest(file);
    }

    public void generaterDelListFile(String _sAppMD5File, String _sStandardMD5File, String _sDelListFile) throws Exception {
        Properties propsApp = new Properties();
        propsApp.load(new FileInputStream(new File(_sAppMD5File)));
        Properties propsStandard = new Properties();
        propsStandard.load(new FileInputStream(new File(_sStandardMD5File)));
        Enumeration<?> enumeration = propsApp.propertyNames();
        Properties propsDel = new Properties();
        while (enumeration.hasMoreElements()) {
            String sKey = (String)enumeration.nextElement();
            if (propsStandard.containsKey(sKey)) continue;
            propsDel.put(sKey, propsApp.get(sKey));
        }
        this.storeResult(propsDel, _sDelListFile);
    }

    private void storeResult(Properties props) throws FileNotFoundException, IOException {
        this.storeResult(props, this.m_sDigestStoreFile);
    }

    private void storeResult(Properties props, String _sDigestStoreFile) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        try {
            File file = new File(_sDigestStoreFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            props.store(fos, "wcmapp file md5 digest.");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] argss) {
        String sApp1091 = "D:\\TRS\\TRSWCMV65_07221\\Tomcat\\webapps\\";
        String[] sAppPath = new String[]{"wcm"};
        try {
            int i = 0;
            while (i < sAppPath.length) {
                MD5Digest digest = new MD5Digest(String.valueOf(sApp1091) + sAppPath[i], String.valueOf(sApp1091) + sAppPath[i] + ".properties");
                digest.digest();
                System.out.println("generate media files MD5 datas finished!");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class DifferenceRecord {
        private String m_sFileName;
        private boolean m_bModified;

        public DifferenceRecord(String _sFileName) {
            this(_sFileName, true);
        }

        public DifferenceRecord(String _sFileName, boolean _bModified) {
            this.m_sFileName = _sFileName;
            this.m_bModified = _bModified;
        }

        public String getName() {
            return this.m_sFileName;
        }

        public boolean isModified() {
            return this.m_bModified;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            if (another == null || !(another instanceof DifferenceRecord)) {
                return false;
            }
            return this.m_sFileName.equals(((DifferenceRecord)another).m_sFileName);
        }

        public int hashCode() {
            return this.m_sFileName.hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_sFileName) + ":" + (this.m_bModified ? "modified" : "added");
        }
    }
}

