/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUrl;
import com.trs.infra.util.IURLAcceptor;
import com.trs.infra.util.WCMHTMLContentURLAcceptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFilter {
    public static String stripTags(String string, String[] stringArray) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        String string2 = "(?i)<\\s*(";
        String string3 = "<\\s*/\\s*(";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim() == "") continue;
            if (i < stringArray.length - 1) {
                string2 = string2 + stringArray[i] + "|";
                string3 = string3 + stringArray[i] + "|";
                continue;
            }
            string2 = string2 + stringArray[i] + ")[^>]*>";
            string3 = string3 + stringArray[i] + ")\\s*>";
        }
        string = string.replaceAll(string2 + "[^<]*" + string3, "");
        string = string.replaceAll(string2, "");
        return string;
    }

    public static String stripTags(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        String string2 = "(?i)<\\s*(script|iframe|frame|link)[^>]*>[^<]*<\\s*/\\s*(script|iframe|frame|link)\\s*>";
        String string3 = "(?i)<\\s*link[^>]*>";
        string = string.replaceAll(string2, "");
        string = string.replaceAll(string3, "");
        return string;
    }

    public static String stripUrl(String string, String string2, String[] stringArray, IURLAcceptor iURLAcceptor) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        if (iURLAcceptor == null) {
            return string;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{".jsp", ".do"};
        }
        String string3 = "(?i)<\\s*(a|link)\\s*.*?href\\s*=\\s*(['\"][^'\"]*['\"]|[^\\s>]*)";
        String string4 = "(?i)(<\\s*(a|link)\\s*.*?href\\s*=\\s*)";
        String string5 = "(?i)<\\s*(script|iframe|frame|img)\\s*.*?src\\s*=\\s*(['\"][^'\"]*['\"]|[^\\s>]*)";
        String string6 = "(?i)(<\\s*(script|iframe|frame|img)\\s*.*?src\\s*=\\s*)";
        String string7 = "(?i)(url\\()([^\\)]*)";
        String string8 = "(?i)(url\\()";
        string = TextFilter.stripUrl(string, string2, stringArray, string3, string4, iURLAcceptor);
        string = TextFilter.stripUrl(string, string2, stringArray, string5, string6, iURLAcceptor);
        string = TextFilter.stripUrl(string, string2, stringArray, string7, string8, iURLAcceptor);
        return string;
    }

    private static String stripUrl(String string, String string2, String[] stringArray, String string3, String string4, IURLAcceptor iURLAcceptor) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        if (CMyString.isEmpty(string3)) {
            return string;
        }
        if (CMyString.isEmpty(string4)) {
            return string;
        }
        if (iURLAcceptor == null) {
            return string;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{".jsp", ".do"};
        }
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        String string5 = null;
        String string6 = null;
        String string7 = "";
        block0: while (matcher.find()) {
            string5 = matcher.group(2);
            string6 = string5;
            if (string6.startsWith("\"") || string6.startsWith("'")) {
                string6 = string6.substring(1);
            }
            if (string6.endsWith("\"") || string6.endsWith("'")) {
                string6 = string6.substring(0, string6.length() - 1);
            }
            string7 = CMyUrl.extractFileName(string6);
            if (string6.matches("(?i)^(https?|file|ftp|gopher|mailto|MMS|ed2k|Flashget|thunder)://.*") && (CMyString.isEmpty(string2) || !string6.startsWith(string2))) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string7.endsWith(stringArray[i]) || iURLAcceptor.accept(string6, null, string7)) continue;
                if (string5.indexOf("?") >= 0) {
                    string5 = string5.replaceAll("\\?", "\\\\?");
                }
                String string8 = "";
                if (string5.startsWith("\"")) {
                    string8 = "\"\"";
                }
                if (string5.startsWith("'")) {
                    string8 = "''";
                }
                string = string.replaceAll(string4 + string5, "$1" + string8);
                continue block0;
            }
        }
        return string;
    }

    public static String stripScripts(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        String string2 = "(?i)<\\s*script[^>]*>[^<]*<\\s*/\\s*script\\s*>";
        String string3 = "(?i)(<[^>]*?)javascript:";
        string = string.replaceAll(string2, "");
        string = string.replaceAll(string3, "$1");
        return string;
    }

    public static String stripEvents(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            return string;
        }
        String[] stringArray = new String[]{"onload", "onunload", "onclick", "onchange", "onsubmit", "onreset", "onblur", "onfocus", "onabort", "onkeydown", "onkeypress", "onkeyup", "ondblclick", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup"};
        for (int i = 0; i < stringArray.length; ++i) {
            string = string.replaceAll("(?i)(<.*?)" + stringArray[i] + "(\\s*=)", "$1$2");
        }
        return string;
    }

    public static String stripText(String string, String[] stringArray, String string2, String[] stringArray2, IURLAcceptor iURLAcceptor) throws WCMException {
        string = TextFilter.stripScripts(string);
        string = TextFilter.stripEvents(string);
        string = TextFilter.stripTags(string, stringArray);
        string = TextFilter.stripUrl(string, string2, stringArray2, iURLAcceptor);
        return string;
    }

    public static String stripText(String string, boolean bl) throws WCMException {
        String[] stringArray = null;
        stringArray = bl ? new String[]{"iframe", "frame", "script"} : new String[]{"iframe", "frame"};
        String[] stringArray2 = new String[]{".jsp", ".do"};
        WCMHTMLContentURLAcceptor wCMHTMLContentURLAcceptor = new WCMHTMLContentURLAcceptor();
        string = TextFilter.stripScripts(string);
        string = TextFilter.stripEvents(string);
        string = TextFilter.stripTags(string, stringArray);
        string = TextFilter.stripUrl(string, "", stringArray2, wCMHTMLContentURLAcceptor);
        return string;
    }
}

