/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CharsetDetector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocaleServerCollector {
    private static Logger logger = Logger.getLogger(LocaleServerCollector.class);
    private static Pattern m_pLocalServer = Pattern.compile("(?)LocaleServer\\.getString\\(\"([^\"]*?)\"\\s*,\\s*\"(.*?)\"\\)");
    private String m_sRootPath;
    private String m_sLocaleOutputFile;
    private Map m_tmpLocaleParams = new HashMap();
    private List list = new ArrayList();
    private Writer m_localePropsWriter = null;

    public LocaleServerCollector(String string, String string2) {
        this.m_sRootPath = new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLocaleOutputFile = string2.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public void analyze() throws CMyException, IOException {
        this.analyzePath(new File(this.m_sRootPath));
        this.writeLocaleOutputFile();
    }

    private void analyzePath(File file) throws CMyException, IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.analyzePath(fileArray[i]);
            }
            return;
        }
        this.analyzeFile(file);
    }

    private boolean accept(String string) {
        return string.endsWith(".jsp");
    }

    private void analyzeFile(File file) throws CMyException, IOException {
        String string = file.getAbsolutePath();
        if (!this.accept(string)) {
            return;
        }
        String string2 = CharsetDetector.detect(string);
        String string3 = CMyFile.readFile(string, string2);
        this.analyzeContent(string, string3);
    }

    private void analyzeContent(String string, String string2) throws IOException {
        Matcher matcher = m_pLocalServer.matcher(string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = (String)this.m_tmpLocaleParams.get(string3);
            if (string5 != null) {
                if (string5.equals(string4)) continue;
                logger.warn((Object)(string + "\n\t===>\u91cd\u590d\u4f7f\u7528\u53d8\u91cf:" + string3 + "\n\t\u65e7\u503c:" + string5 + "\n\t\u65b0\u503c:" + string4 + "\n\t"));
                continue;
            }
            this.list.add(new String[]{string3, string4});
            this.m_tmpLocaleParams.put(string3, string4);
        }
    }

    /*
     * Loose catch block
     */
    private void writeLocaleOutputFile() {
        block8: {
            Collections.sort(this.list, new Comparator(){

                public int compare(Object object, Object object2) {
                    String[] stringArray = (String[])object;
                    String[] stringArray2 = (String[])object2;
                    return stringArray[0].compareToIgnoreCase(stringArray2[0]);
                }
            });
            Writer writer = this.getLocalePropsWriter();
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = (String[])this.list.get(i);
                writer.write(stringArray[0]);
                writer.write("=");
                writer.write(stringArray[1]);
                writer.write("\n");
            }
            Object var6_6 = null;
            try {
                this.closeLocalePropsWriter();
            }
            catch (IOException iOException) {
                logger.error((Object)"\u5173\u95ed\u591a\u8bed\u8a00\u5904\u7406\u6d41\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)iOException);
            }
            break block8;
            {
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.closeLocalePropsWriter();
                }
                catch (IOException iOException) {
                    logger.error((Object)"\u5173\u95ed\u591a\u8bed\u8a00\u5904\u7406\u6d41\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    private Writer getLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter == null) {
            if (!new File(this.m_sLocaleOutputFile).exists()) {
                CMyFile.makeDir(CMyFile.extractFilePath(this.m_sLocaleOutputFile), true);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_sLocaleOutputFile);
            this.m_localePropsWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    public static void main(String[] stringArray) throws CMyException, IOException {
        if (stringArray.length < 2) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            stringBuffer.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\u5982\uff1a\n");
            stringBuffer.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app/");
            stringBuffer.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            stringBuffer.append("\u5982\uff1a\n");
            stringBuffer.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/locale/zh_CN.properties\n");
            logger.error((Object)stringBuffer);
            return;
        }
        LocaleServerCollector localeServerCollector = new LocaleServerCollector(stringArray[0], stringArray[1]);
        localeServerCollector.analyze();
    }
}

